package org.babyfish.jimmer.sql.filter;

import org.babyfish.jimmer.sql.JSqlClient;
import org.babyfish.jimmer.sql.ast.table.Props;
import org.babyfish.jimmer.sql.cache.PropCacheInvalidator;
import org.babyfish.jimmer.sql.event.EntityEvent;

import java.util.SortedMap;

/**
 * Global filter which can work with multi-view cache for java, Kotlin developer should use `KCacheableFilter&lt;E&gt;`
 * @param <P> The EntityProps type generated by apt
 */
public interface CacheableFilter<P extends Props> extends Filter<P>, PropCacheInvalidator {

    /**
     * Return the sub keys of association cache for multi-view cache
     * @see <a href="https://babyfish-ct.github.io/jimmer/docs/cache/multiview-cache/concept#subkey">SubKeys for multi-view cache</a>
     * @return The sub key map
     */
    SortedMap<String, Object> getParameters();

    /**
     * Is the association cache affected by the change of CURRENT table?
     * @param e The change event of CURRENT table
     * @return Whether the association cache should be affected
     */
    boolean isAffectedBy(EntityEvent<?> e);

    /**
     *
     * @param sqlClient
     */
    default void initialize(JSqlClient sqlClient) {}
}
