/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.filter.impl;

import java.util.Collections;
import java.util.SortedMap;
import org.babyfish.jimmer.impl.util.TypeCache;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.meta.LogicalDeletedInfo;
import org.babyfish.jimmer.sql.ast.PropExpression;
import org.babyfish.jimmer.sql.ast.table.Props;
import org.babyfish.jimmer.sql.event.EntityEvent;
import org.babyfish.jimmer.sql.filter.CacheableFilter;
import org.babyfish.jimmer.sql.filter.Filter;
import org.babyfish.jimmer.sql.filter.FilterArgs;
import org.babyfish.jimmer.sql.filter.impl.FilterWrapper;
import org.babyfish.jimmer.sql.runtime.EntityManager;
import org.babyfish.jimmer.sql.runtime.LogicalDeletedBehavior;

public class LogicalDeletedFilterProvider {
    private static final TypeCache<Filter<Props>> DEFAULT_CACHE = new TypeCache(LogicalDeletedFilterProvider::createDefault, true);
    private static final TypeCache<Filter<Props>> IGNORED_CACHE = new TypeCache(LogicalDeletedFilterProvider::createIgnored, true);
    private static final TypeCache<Filter<Props>> REVERSED_CACHE = new TypeCache(LogicalDeletedFilterProvider::createReversed, true);
    private final LogicalDeletedBehavior behavior;
    private final EntityManager entityManager;
    private final String microServiceName;

    public LogicalDeletedFilterProvider(LogicalDeletedBehavior behavior, EntityManager entityManager, String microServiceName) {
        this.behavior = behavior;
        this.entityManager = entityManager;
        this.microServiceName = microServiceName;
    }

    public Filter<Props> get(ImmutableType type) {
        switch (this.behavior) {
            case IGNORED: {
                return (Filter)IGNORED_CACHE.get(type);
            }
            case REVERSED: {
                return (Filter)REVERSED_CACHE.get(type);
            }
        }
        return (Filter)DEFAULT_CACHE.get(type);
    }

    public LogicalDeletedFilterProvider toBehavior(LogicalDeletedBehavior behavior) {
        if (this.behavior == behavior) {
            return this;
        }
        return new LogicalDeletedFilterProvider(behavior, this.entityManager, this.microServiceName);
    }

    public LogicalDeletedBehavior getBehavior() {
        return this.behavior;
    }

    private static Filter<Props> createDefault(ImmutableType type) {
        LogicalDeletedInfo info = type.getLogicalDeletedInfo();
        return info != null ? new DefaultFilter(info) : null;
    }

    private static Filter<Props> createIgnored(ImmutableType type) {
        LogicalDeletedInfo info = type.getLogicalDeletedInfo();
        return info != null ? new IgnoredFilter(info) : null;
    }

    private static Filter<Props> createReversed(ImmutableType type) {
        LogicalDeletedInfo info = type.getLogicalDeletedInfo();
        return info != null ? new ReversedFilter(info) : null;
    }

    static class DefaultFilter
    implements CacheableFilter<Props>,
    FilterWrapper,
    Internal {
        protected final LogicalDeletedInfo info;

        DefaultFilter(LogicalDeletedInfo info) {
            this.info = info;
        }

        @Override
        public Class<?> getFilterType() {
            return this.getClass();
        }

        @Override
        public ImmutableType getImmutableType() {
            return this.info.getProp().getDeclaringType();
        }

        @Override
        public void filter(FilterArgs<Props> args) {
            PropExpression expr = args.getTable().get(this.info.getProp().getName());
            LogicalDeletedInfo.Action action = this.info.getAction();
            if (action instanceof LogicalDeletedInfo.Action.Eq) {
                LogicalDeletedInfo.Action.Eq eq = (LogicalDeletedInfo.Action.Eq)action;
                args.where(expr.eq(eq.getValue()));
            } else if (action instanceof LogicalDeletedInfo.Action.Ne) {
                LogicalDeletedInfo.Action.Ne ne = (LogicalDeletedInfo.Action.Ne)action;
                args.where(expr.ne(ne.getValue()));
            } else if (action instanceof LogicalDeletedInfo.Action.IsNull) {
                args.where(expr.isNull());
            } else if (action instanceof LogicalDeletedInfo.Action.IsNotNull) {
                args.where(expr.isNotNull());
            }
        }

        @Override
        public SortedMap<String, Object> getParameters() {
            return Collections.emptySortedMap();
        }

        @Override
        public boolean isAffectedBy(EntityEvent<?> e) {
            return e.isChanged(this.info.getProp());
        }
    }

    public static class IgnoredFilter
    implements Filter<Props>,
    FilterWrapper,
    Internal {
        protected final LogicalDeletedInfo info;

        IgnoredFilter(LogicalDeletedInfo info) {
            this.info = info;
        }

        @Override
        public Class<?> getFilterType() {
            return this.getClass();
        }

        @Override
        public ImmutableType getImmutableType() {
            return this.info.getProp().getDeclaringType();
        }

        @Override
        public void filter(FilterArgs<Props> args) {
        }
    }

    private static class ReversedFilter
    implements Filter<Props>,
    FilterWrapper,
    Internal {
        protected final LogicalDeletedInfo info;

        ReversedFilter(LogicalDeletedInfo info) {
            this.info = info;
        }

        @Override
        public Class<?> getFilterType() {
            return this.getClass();
        }

        @Override
        public ImmutableType getImmutableType() {
            return this.info.getProp().getDeclaringType();
        }

        @Override
        public void filter(FilterArgs<Props> args) {
            PropExpression expr = args.getTable().get(this.info.getProp().getName());
            LogicalDeletedInfo.Action action = this.info.getAction().reversed();
            if (action instanceof LogicalDeletedInfo.Action.Eq) {
                LogicalDeletedInfo.Action.Eq eq = (LogicalDeletedInfo.Action.Eq)action;
                args.where(expr.eq(eq.getValue()));
            } else if (action instanceof LogicalDeletedInfo.Action.Ne) {
                LogicalDeletedInfo.Action.Ne ne = (LogicalDeletedInfo.Action.Ne)action;
                args.where(expr.ne(ne.getValue()));
            } else if (action instanceof LogicalDeletedInfo.Action.IsNull) {
                args.where(expr.isNull());
            } else if (action instanceof LogicalDeletedInfo.Action.IsNotNull) {
                args.where(expr.isNotNull());
            }
        }
    }

    public static interface Internal {
    }
}

