/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.cache.redisson;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.UUID;
import org.babyfish.jimmer.sql.cache.CacheTracker;
import org.babyfish.jimmer.sql.cache.redisson.InvalidateMessage;
import org.babyfish.jimmer.sql.cache.spi.AbstractCacheTracker;
import org.redisson.api.RTopic;
import org.redisson.api.RedissonClient;
import org.redisson.api.listener.BaseStatusListener;
import org.redisson.api.listener.MessageListener;
import org.redisson.api.listener.StatusListener;

public class RedissonCacheTracker
extends AbstractCacheTracker {
    private static final String CHANNEL = "_jimmer_:invalidate";
    private final UUID trackerId = UUID.randomUUID();
    private final RTopic topic;

    public RedissonCacheTracker(RedissonClient redisson) {
        this.topic = redisson.getTopic(CHANNEL);
        this.topic.addListener(InvalidateMessage.class, (MessageListener)new MessageListener<InvalidateMessage>(){

            public void onMessage(CharSequence channel, InvalidateMessage msg) {
                if (!msg.trackerId.equals(RedissonCacheTracker.this.trackerId)) {
                    RedissonCacheTracker.this.firer().invalidate(msg.toEvent());
                }
            }
        });
        this.topic.addListener((StatusListener)new BaseStatusListener(){

            public void onSubscribe(String channel) {
                RedissonCacheTracker.this.firer().reconnect();
            }
        });
    }

    @Override
    protected void publishInvalidationEvent(CacheTracker.InvalidationEvent event) {
        String ids;
        try {
            ids = InvalidateMessage.MAPPER.writeValueAsString(event.getIds());
        }
        catch (JsonProcessingException ex) {
            throw new IllegalArgumentException("Cannot serialize the ids of InvalidationEvent", ex);
        }
        this.topic.publish((Object)new InvalidateMessage(this.trackerId, event.getType().toString(), event.getProp() != null ? event.getProp().getName() : null, ids));
    }
}

