/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.cache.redisson;

import java.time.Duration;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import org.babyfish.jimmer.sql.cache.CacheLocker;
import org.babyfish.jimmer.sql.cache.chain.LockableBinder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;

public class RedissonCacheLocker
implements CacheLocker {
    private final RedissonClient redisson;
    private final int lockUpgradeThreshold;

    public RedissonCacheLocker(RedissonClient redisson) {
        this(redisson, 64);
    }

    public RedissonCacheLocker(RedissonClient redisson, int lockUpgradeThreshold) {
        if (lockUpgradeThreshold < 2) {
            throw new IllegalArgumentException("lockUpgradeThreshold cannot be less than 2");
        }
        this.redisson = Objects.requireNonNull(redisson, "redisson cannot be null");
        this.lockUpgradeThreshold = lockUpgradeThreshold;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void locking(@NotNull LockableBinder<?, ?> binder, @NotNull Set<?> missedKeys, @Nullable SortedMap<String, Object> parameterMap, @Nullable Duration waitingDuration, @NotNull Duration lockingDuration, CacheLocker.Action action) throws InterruptedException {
        RLock lock;
        String lockPrefix = "$lock$" + binder.keyPrefix();
        if (parameterMap != null) {
            lockPrefix = lockPrefix + ":" + parameterMap;
        }
        if (missedKeys.size() >= this.lockUpgradeThreshold) {
            lock = this.redisson.getLock(lockPrefix);
        } else {
            lockPrefix = lockPrefix + '-';
            TreeSet<String> lockNames = new TreeSet<String>();
            for (Object missedKey : missedKeys) {
                lockNames.add(lockPrefix + missedKey);
            }
            RLock[] locks = new RLock[lockNames.size()];
            int index = 0;
            for (String lockName : lockNames) {
                locks[index++] = this.redisson.getLock(lockName);
            }
            lock = this.redisson.getMultiLock(locks);
        }
        if (waitingDuration == null) {
            lock.lockInterruptibly(lockingDuration.toMillis(), TimeUnit.MILLISECONDS);
            try {
                action.execute(true);
            }
            finally {
                lock.unlock();
            }
        } else if (lock.tryLock(waitingDuration.toMillis(), lockingDuration.toMillis(), TimeUnit.MILLISECONDS)) {
            try {
                action.execute(true);
            }
            finally {
                lock.unlock();
            }
        } else {
            action.execute(false);
        }
    }
}

