/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.cache.chain;

import java.util.ArrayList;
import java.util.List;
import org.babyfish.jimmer.sql.cache.Cache;
import org.babyfish.jimmer.sql.cache.chain.Binder;
import org.babyfish.jimmer.sql.cache.chain.ChainCacheImpl;
import org.babyfish.jimmer.sql.cache.chain.LoadingBinder;
import org.babyfish.jimmer.sql.cache.chain.LockedBinder;
import org.babyfish.jimmer.sql.cache.chain.ParameterizedChainCacheImpl;
import org.babyfish.jimmer.sql.cache.chain.SimpleBinder;

public class ChainCacheBuilder<K, V> {
    private final List<Binder<K>> binders = new ArrayList<Binder<K>>();
    private Boolean hasParameterizedBinder = null;
    private boolean hasLockableBinder = false;
    private Binder.TrackingMode trackingMode = Binder.TrackingMode.NONE;

    public ChainCacheBuilder<K, V> add(LoadingBinder<K, V> binder) {
        if (binder != null) {
            if (Boolean.TRUE.equals(this.hasParameterizedBinder)) {
                throw new IllegalStateException("Parameterized binder and normal binder cannot be mixed");
            }
            this.hasParameterizedBinder = false;
            this.validateNewBinder(binder);
            this.binders.add(binder);
        }
        return this;
    }

    public ChainCacheBuilder<K, V> add(LoadingBinder.Parameterized<K, V> binder) {
        if (binder != null) {
            if (Boolean.FALSE.equals(this.hasParameterizedBinder)) {
                throw new IllegalStateException("Parameterized binder and normal binder cannot be mixed");
            }
            this.hasParameterizedBinder = true;
            this.validateNewBinder(binder);
            this.binders.add(binder);
        }
        return this;
    }

    public ChainCacheBuilder<K, V> add(SimpleBinder<K, V> binder) {
        if (binder != null) {
            boolean isParameterized = binder instanceof SimpleBinder.Parameterized;
            if (this.hasParameterizedBinder != null && !this.hasParameterizedBinder.equals(isParameterized)) {
                throw new IllegalStateException("Parameterized binder and normal binder cannot be mixed");
            }
            this.hasParameterizedBinder = isParameterized;
            this.validateNewBinder(binder);
            this.binders.add(binder);
        }
        return this;
    }

    private void validateNewBinder(Binder<K> binder) {
        if (binder instanceof LockedBinder) {
            this.hasLockableBinder = true;
        } else if (this.hasLockableBinder) {
            throw new IllegalStateException("Non-lockable binder cannot be added after lockable binder");
        }
        switch (binder.tracingMode()) {
            case NONE: 
            case CONSUMER: {
                if (this.trackingMode == Binder.TrackingMode.NONE) break;
                throw new IllegalStateException("The binder with the tracking mode \"" + (Object)((Object)binder.tracingMode()) + "\" cannot be added after lockable binder with the tracking mode \"" + this.trackingMode.name() + "\"");
            }
            case PRODUCER: {
                if (this.trackingMode == Binder.TrackingMode.CONSUMER || this.trackingMode == Binder.TrackingMode.NONE) break;
                throw new IllegalStateException("The binder with the tracking mode \"" + (Object)((Object)binder.tracingMode()) + "\" cannot be added after lockable binder with the tracking mode \"" + this.trackingMode.name() + "\"");
            }
        }
    }

    public Cache<K, V> build() {
        List<Binder<K>> binders = this.binders;
        if (binders.isEmpty()) {
            return null;
        }
        if (this.hasParameterizedBinder.booleanValue()) {
            return new ParameterizedChainCacheImpl(binders);
        }
        return new ChainCacheImpl(binders);
    }
}

