/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.cache;

import java.util.Collection;
import org.babyfish.jimmer.impl.util.Classes;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.meta.TargetLevel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface CacheTracker {
    public void addInvalidateListener(InvalidationListener var1);

    public void removeInvalidateListener(InvalidationListener var1);

    public void addReconnectListener(ReconnectListener var1);

    public void removeReconnectListener(ReconnectListener var1);

    public Firer firer();

    public Publisher publisher();

    public static class InvalidationEvent {
        private final ImmutableType type;
        private final ImmutableProp prop;
        private final Collection<?> ids;

        public InvalidationEvent(ImmutableType type, Collection<?> ids) {
            Class expectedIdType = Classes.boxTypeOf((Class)type.getIdProp().getReturnClass());
            for (Object id : ids) {
                if (id != null && expectedIdType.isAssignableFrom(id.getClass())) continue;
                throw new IllegalArgumentException("The type of id \"" + id + "\" does not match the id property \"" + type.getIdProp() + "\"");
            }
            this.type = type;
            this.prop = null;
            this.ids = ids;
        }

        public InvalidationEvent(ImmutableProp prop, Collection<?> ids) {
            if (!prop.isAssociation(TargetLevel.ENTITY)) {
                throw new IllegalArgumentException("The prop \"" + prop + "\" is not association property");
            }
            ImmutableType type = prop.getDeclaringType();
            ImmutableProp idProp = type.getIdProp();
            Class expectedIdType = Classes.boxTypeOf((Class)idProp.getReturnClass());
            for (Object id : ids) {
                if (id != null && expectedIdType.isAssignableFrom(id.getClass())) continue;
                throw new IllegalArgumentException("The id \"" + id + "\" does not match the id property \"" + idProp + "\" of declaring type");
            }
            this.type = type;
            this.prop = prop;
            this.ids = ids;
        }

        @NotNull
        public ImmutableType getType() {
            return this.type;
        }

        @Nullable
        public ImmutableProp getProp() {
            return this.prop;
        }

        @NotNull
        public Collection<?> getIds() {
            return this.ids;
        }

        public String toString() {
            if (this.prop != null) {
                return this.prop.toString() + this.ids;
            }
            return this.type.toString() + this.ids;
        }
    }

    public static interface Publisher {
        public void invalidate(InvalidationEvent var1);
    }

    public static interface Firer {
        public void invalidate(InvalidationEvent var1);

        public void reconnect();
    }

    public static interface ReconnectListener {
        public void onReconnect();
    }

    @FunctionalInterface
    public static interface InvalidationListener {
        public void onInvalidate(InvalidationEvent var1);
    }
}

