/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.mutation.save;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.LogicalDeletedInfo;
import org.babyfish.jimmer.sql.DissociateAction;
import org.babyfish.jimmer.sql.ast.Expression;
import org.babyfish.jimmer.sql.ast.impl.AbstractMutableStatementImpl;
import org.babyfish.jimmer.sql.ast.impl.AstContext;
import org.babyfish.jimmer.sql.ast.impl.mutation.save.AbstractOperator;
import org.babyfish.jimmer.sql.ast.impl.mutation.save.DeleteContext;
import org.babyfish.jimmer.sql.ast.impl.mutation.save.DisconnectingType;
import org.babyfish.jimmer.sql.ast.impl.mutation.save.DisconnectionArgs;
import org.babyfish.jimmer.sql.ast.impl.mutation.save.ExclusiveIdPairPredicates;
import org.babyfish.jimmer.sql.ast.impl.mutation.save.IdPairs;
import org.babyfish.jimmer.sql.ast.impl.mutation.save.MiddleTableOperator;
import org.babyfish.jimmer.sql.ast.impl.mutation.save.MutationTrigger;
import org.babyfish.jimmer.sql.ast.impl.mutation.save.QueryReason;
import org.babyfish.jimmer.sql.ast.impl.query.AbstractMutableQueryImpl;
import org.babyfish.jimmer.sql.ast.impl.query.FilterLevel;
import org.babyfish.jimmer.sql.ast.impl.query.MutableRootQueryImpl;
import org.babyfish.jimmer.sql.ast.impl.query.MutableSubQueryImpl;
import org.babyfish.jimmer.sql.ast.impl.render.AbstractSqlBuilder;
import org.babyfish.jimmer.sql.ast.impl.render.BatchSqlBuilder;
import org.babyfish.jimmer.sql.ast.impl.render.ComparisonPredicates;
import org.babyfish.jimmer.sql.ast.impl.table.TableImplementor;
import org.babyfish.jimmer.sql.ast.impl.value.ValueGetter;
import org.babyfish.jimmer.sql.ast.table.Props;
import org.babyfish.jimmer.sql.ast.tuple.Tuple2;
import org.babyfish.jimmer.sql.filter.Filter;
import org.babyfish.jimmer.sql.filter.impl.FilterManager;
import org.babyfish.jimmer.sql.meta.ColumnDefinition;
import org.babyfish.jimmer.sql.runtime.ExecutionPurpose;
import org.babyfish.jimmer.sql.runtime.SqlBuilder;

class ChildTableOperator
extends AbstractOperator {
    final DeleteContext ctx;
    private final ChildTableOperator parent;
    final int mutationSubQueryDepth;
    private final QueryReason queryReason;
    final DisconnectingType disconnectingType;
    private final String tableName;
    private final List<ValueGetter> sourceGetters;
    final List<ValueGetter> targetGetters;

    ChildTableOperator(DeleteContext ctx) {
        this(null, ctx);
    }

    private ChildTableOperator(ChildTableOperator parent, ImmutableProp backReferenceProp) {
        this(parent, parent.ctx.backPropOf(backReferenceProp));
    }

    private ChildTableOperator(ChildTableOperator parent, DeleteContext ctx) {
        super(ctx.options.getSqlClient(), ctx.con);
        Filter<Props> filter;
        DisconnectingType disconnectingType;
        DissociateAction dissociateAction = ctx.options.getDissociateAction(ctx.path.getBackProp());
        if (parent == null) {
            DisconnectingType disconnectingType2 = DisconnectingType.NONE;
        }
        switch (dissociateAction) {
            case CHECK: {
                disconnectingType = DisconnectingType.CHECKING;
                break;
            }
            case SET_NULL: {
                disconnectingType = DisconnectingType.SET_NULL;
                break;
            }
            case DELETE: {
                ColumnDefinition definition = (ColumnDefinition)ctx.backProp.getStorage(ctx.options.getSqlClient().getMetadataStrategy());
                if (definition.isForeignKey() || ctx.path.getType().getLogicalDeletedInfo() == null) {
                    disconnectingType = DisconnectingType.PHYSICAL_DELETE;
                    break;
                }
                disconnectingType = DisconnectingType.LOGICAL_DELETE;
                break;
            }
            default: {
                disconnectingType = DisconnectingType.NONE;
            }
        }
        QueryReason queryReason = QueryReason.NONE;
        if (ctx.trigger != null) {
            queryReason = QueryReason.TRIGGER;
        } else if (disconnectingType == DisconnectingType.CHECKING) {
            queryReason = QueryReason.CHECKING;
        } else if (disconnectingType == DisconnectingType.LOGICAL_DELETE && FilterManager.hasUserFilter(filter = ctx.options.getSqlClient().getFilters().getTargetFilter(ctx.path.getProp()))) {
            queryReason = QueryReason.FILTER;
        }
        int mutationSubQueryDepth = 0;
        if (parent != null && (mutationSubQueryDepth = parent.mutationSubQueryDepth + 1) >= ctx.options.getSqlClient().getMaxMutationSubQueryDepth()) {
            mutationSubQueryDepth = 0;
            queryReason = QueryReason.TOO_DEEP;
        }
        this.ctx = ctx;
        this.parent = parent;
        this.mutationSubQueryDepth = mutationSubQueryDepth;
        this.queryReason = queryReason;
        this.disconnectingType = disconnectingType;
        this.tableName = ctx.path.getType().getTableName(this.sqlClient.getMetadataStrategy());
        this.sourceGetters = ValueGetter.valueGetters(this.sqlClient, ctx.backProp);
        this.targetGetters = ValueGetter.valueGetters(this.sqlClient, ctx.path.getType().getIdProp());
    }

    final int disconnectExcept(IdPairs idPairs) {
        return this.disconnect(DisconnectionArgs.retain(idPairs, this));
    }

    private int disconnect(DisconnectionArgs args) {
        List<Object> preExecutedIds;
        if (args.isEmpty()) {
            return 0;
        }
        if ((args.deletedIds == null || this != args.caller) && (preExecutedIds = this.preDisconnect(args)) != null) {
            return this.disconnect(DisconnectionArgs.delete(preExecutedIds, this));
        }
        for (ChildTableOperator subOperator : this.subOperators()) {
            subOperator.disconnect(args);
        }
        if (this.disconnectingType.isDelete()) {
            for (MiddleTableOperator middleTableOperator : this.middleTableOperators()) {
                middleTableOperator.disconnect(args);
            }
        }
        return this.disconnectImpl(args);
    }

    private List<Object> preDisconnect(DisconnectionArgs args) {
        if (this.queryReason == QueryReason.NONE) {
            return null;
        }
        MutationTrigger trigger = this.ctx.trigger;
        if (trigger != null) {
            List<Tuple2<Object, Object>> tuples = this.findDisconnectingTuples(args);
            ArrayList<Object> targetIds = new ArrayList<Object>(tuples.size());
            for (Tuple2<Object, Object> tuple : tuples) {
                trigger.deleteMiddleTable(this.ctx.path.getProp(), tuple.get_1(), tuple.get_2());
                targetIds.add(tuple.get_2());
            }
            return targetIds;
        }
        return this.findDisconnectingIds(args);
    }

    private int disconnectImpl(DisconnectionArgs args) {
        if (args.deletedIds != null) {
            SqlBuilder builder = new SqlBuilder(new AstContext(this.sqlClient));
            this.addOperationHead(builder);
            builder.enter(AbstractSqlBuilder.ScopeType.WHERE);
            this.addPredicates(builder, args, null);
            builder.leave();
            return this.execute(builder);
        }
        if (this.targetGetters.size() == 1 && this.sqlClient.getDialect().isAnyEqualityOfArraySupported()) {
            return this.disconnectExceptByBatch(args);
        }
        return this.disconnectExceptByInPredicate(args);
    }

    private int disconnectExceptByBatch(DisconnectionArgs args) {
        BatchSqlBuilder builder = new BatchSqlBuilder(this.sqlClient);
        this.addOperationHead(builder);
        builder.enter(AbstractSqlBuilder.ScopeType.WHERE);
        this.addPredicates(builder, args, null);
        builder.leave();
        return this.execute(builder, args.retainedIdPairs.entries());
    }

    private int disconnectExceptByInPredicate(DisconnectionArgs args) {
        SqlBuilder builder = new SqlBuilder(new AstContext(this.sqlClient));
        this.addOperationHead(builder);
        builder.enter(AbstractSqlBuilder.ScopeType.WHERE);
        this.addPredicates(builder, args, null);
        builder.leave();
        return this.execute(builder);
    }

    private void addOperationHead(AbstractSqlBuilder<?> builder) {
        if (this.disconnectingType == DisconnectingType.PHYSICAL_DELETE) {
            ((AbstractSqlBuilder)builder.sql("delete from ")).sql(this.tableName);
        } else if (this.disconnectingType == DisconnectingType.LOGICAL_DELETE) {
            LogicalDeletedInfo logicalDeletedInfo = this.ctx.path.getType().getLogicalDeletedInfo();
            assert (logicalDeletedInfo != null);
            ((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)builder.sql("update ")).sql(this.tableName)).enter(AbstractSqlBuilder.ScopeType.SET)).logicalDeleteAssignment(logicalDeletedInfo, null)).leave();
        } else {
            ((AbstractSqlBuilder)((AbstractSqlBuilder)builder.sql("update ")).sql(this.tableName)).enter(AbstractSqlBuilder.ScopeType.SET);
            for (ValueGetter sourceGetter : this.sourceGetters) {
                ((AbstractSqlBuilder)((AbstractSqlBuilder)builder.separator()).sql(sourceGetter)).sql(" = null");
            }
            builder.leave();
        }
    }

    final void addPredicates(AbstractSqlBuilder<?> builder, DisconnectionArgs args, String alias) {
        if (builder instanceof BatchSqlBuilder) {
            this.addPredicatesImpl((BatchSqlBuilder)builder, args.deletedIds, args.caller, alias);
        } else {
            this.addPredicatesImpl((SqlBuilder)builder, args, alias);
        }
        if (this.disconnectingType == DisconnectingType.LOGICAL_DELETE) {
            LogicalDeletedInfo logicalDeletedInfo = this.ctx.path.getType().getLogicalDeletedInfo();
            assert (logicalDeletedInfo != null);
            ((AbstractSqlBuilder)builder.sql(" and ")).logicalDeleteFilter(logicalDeletedInfo, null);
        }
    }

    private void addPredicatesImpl(BatchSqlBuilder builder, Collection<?> deletedIds, Object caller, String alias) {
        if (this != caller && this.parent != null) {
            builder.enter(this.sourceGetters.size() == 1 ? AbstractSqlBuilder.ScopeType.NULL : AbstractSqlBuilder.ScopeType.TUPLE);
            for (ValueGetter valueGetter : this.sourceGetters) {
                builder.separator();
                builder.sql(valueGetter);
            }
            builder.leave();
            ((BatchSqlBuilder)builder.sql(" in ")).enter(AbstractSqlBuilder.ScopeType.SUB_QUERY);
            builder.enter(AbstractSqlBuilder.ScopeType.SELECT);
            List<ValueGetter> parentGetters = ValueGetter.valueGetters(builder.sqlClient(), this.parent.ctx.path.getType().getIdProp());
            for (ValueGetter parentGetter : parentGetters) {
                ((BatchSqlBuilder)builder.separator()).sql(parentGetter);
            }
            builder.leave();
            ((BatchSqlBuilder)builder.sql(" from ")).sql(this.parent.tableName);
            builder.enter(AbstractSqlBuilder.ScopeType.WHERE);
            this.parent.addPredicatesImpl(builder, deletedIds, caller, alias);
            builder.leave();
            builder.leave();
            return;
        }
        builder.separator();
        if (deletedIds != null) {
            builder.enter(this.targetGetters.size() == 1 ? AbstractSqlBuilder.ScopeType.NULL : AbstractSqlBuilder.ScopeType.AND);
            for (ValueGetter valueGetter : this.targetGetters) {
                builder.separator();
                ((BatchSqlBuilder)((BatchSqlBuilder)((BatchSqlBuilder)builder.sql(valueGetter)).sql(valueGetter)).sql(" = ")).variable(valueGetter);
            }
            builder.leave();
            return;
        }
        ExclusiveIdPairPredicates.addPredicates(builder, this.sourceGetters, this.targetGetters);
    }

    private void addPredicatesImpl(SqlBuilder builder, DisconnectionArgs args, String alias) {
        if (this != args.caller && this.parent != null) {
            builder.enter(this.sourceGetters.size() == 1 ? AbstractSqlBuilder.ScopeType.NULL : AbstractSqlBuilder.ScopeType.TUPLE);
            for (ValueGetter valueGetter : this.sourceGetters) {
                builder.separator();
                builder.sql(valueGetter);
            }
            ((SqlBuilder)builder.sql(" in ")).enter(AbstractSqlBuilder.ScopeType.SUB_QUERY);
            builder.enter(AbstractSqlBuilder.ScopeType.SELECT);
            List<ValueGetter> parentGetters = ValueGetter.valueGetters(builder.sqlClient(), this.parent.ctx.path.getType().getIdProp());
            for (ValueGetter parentGetter : parentGetters) {
                ((SqlBuilder)builder.separator()).sql(parentGetter);
            }
            builder.leave();
            ((SqlBuilder)builder.sql(" from ")).sql(this.parent.tableName);
            builder.enter(AbstractSqlBuilder.ScopeType.WHERE);
            this.parent.addPredicatesImpl(builder, args, alias);
            builder.leave();
            builder.leave();
            builder.leave();
            return;
        }
        builder.separator();
        Collection<Object> deletedIds = args.deletedIds;
        if (deletedIds != null) {
            ComparisonPredicates.renderIn(false, ValueGetter.alias(alias, this.targetGetters), deletedIds, builder);
            return;
        }
        IdPairs idPairs = args.retainedIdPairs;
        if (idPairs.entries().size() == 1) {
            Tuple2<Object, Collection<Object>> tuple = idPairs.entries().iterator().next();
            ComparisonPredicates.renderEq(false, ValueGetter.alias(alias, this.sourceGetters), tuple.get_1(), builder);
            if (!tuple.get_2().isEmpty()) {
                builder.separator();
                ComparisonPredicates.renderIn(true, ValueGetter.alias(alias, this.targetGetters), tuple.get_2(), builder);
            }
            return;
        }
        ExclusiveIdPairPredicates.addPredicates(builder, ValueGetter.alias(alias, this.sourceGetters), ValueGetter.alias(alias, this.targetGetters), idPairs);
    }

    private List<Tuple2<Object, Object>> findDisconnectingTuples(DisconnectionArgs args) {
        MutableRootQueryImpl query = new MutableRootQueryImpl(this.sqlClient, this.ctx.path.getType(), ExecutionPurpose.MUTATE, FilterLevel.DEFAULT);
        this.addDisconnectingConditions(query, args);
        return (List)query.select(query.getTableImplementor().getAssociatedId(this.ctx.backProp), query.getTableImplementor().getId()).execute(this.con);
    }

    private List<Object> findDisconnectingIds(DisconnectionArgs args) {
        MutableRootQueryImpl query = new MutableRootQueryImpl(this.sqlClient, this.ctx.path.getType(), ExecutionPurpose.MUTATE, FilterLevel.DEFAULT);
        this.addDisconnectingConditions(query, args);
        return (List)query.select(query.getTableImplementor().getId()).execute(this.con);
    }

    private void addDisconnectingConditions(AbstractMutableQueryImpl query, DisconnectionArgs args) {
        TableImplementor<?> table = query.getTableImplementor();
        if (this != args.caller) {
            MutableSubQueryImpl subQuery = new MutableSubQueryImpl((AbstractMutableStatementImpl)query, this.parent.ctx.path.getType());
            TableImplementor<?> parentTable = subQuery.getTableImplementor();
            this.parent.addDisconnectingConditions(subQuery, args);
            query.where(table.getAssociatedId(this.ctx.backProp).in(subQuery.select(parentTable.getId())));
            return;
        }
        Collection<Object> deletedIds = args.deletedIds;
        if (deletedIds != null) {
            if (!deletedIds.isEmpty()) {
                query.where(table.getId().in(deletedIds));
            }
            return;
        }
        IdPairs retainedIdPairs = args.retainedIdPairs;
        if (retainedIdPairs.entries().size() == 1) {
            query.where(table.getAssociatedId(this.ctx.backProp).in(Tuple2.projection1(retainedIdPairs.entries())));
            if (!retainedIdPairs.tuples().isEmpty()) {
                query.where(table.getId().notIn(Tuple2.projection2(retainedIdPairs.tuples())));
            }
            return;
        }
        query.where(table.getAssociatedId(this.ctx.backProp).in(Tuple2.projection1(retainedIdPairs.entries())));
        if (!retainedIdPairs.tuples().isEmpty()) {
            query.where(Expression.tuple(table.getAssociatedId(this.ctx.backProp), table.getId()).notIn(retainedIdPairs.tuples()));
        }
    }

    private List<ChildTableOperator> subOperators() {
        ArrayList<ChildTableOperator> subOperators = null;
        if (this.ctx.path.getParent() == null || this.disconnectingType.isDelete()) {
            for (ImmutableProp backProp : this.sqlClient.getEntityManager().getAllBackProps(this.ctx.path.getType())) {
                if (!backProp.isColumnDefinition() || this.disconnectingType == DisconnectingType.NONE) continue;
                if (subOperators == null) {
                    subOperators = new ArrayList<ChildTableOperator>();
                }
                subOperators.add(new ChildTableOperator(this, backProp));
            }
        }
        if (subOperators == null) {
            return Collections.emptyList();
        }
        return subOperators;
    }

    private List<MiddleTableOperator> middleTableOperators() {
        MiddleTableOperator middleTableOperator;
        ArrayList<MiddleTableOperator> middleTableOperators = null;
        for (ImmutableProp prop : this.ctx.path.getType().getProps().values()) {
            if (!prop.isMiddleTableDefinition()) continue;
            if (middleTableOperators == null) {
                middleTableOperators = new ArrayList<MiddleTableOperator>();
            }
            middleTableOperator = MiddleTableOperator.propOf(this, prop);
            if (middleTableOperator.middleTable.isReadonly()) continue;
            middleTableOperators.add(middleTableOperator);
        }
        if (this.ctx.path.getParent() == null || this.disconnectingType.isDelete()) {
            for (ImmutableProp backProp : this.sqlClient.getEntityManager().getAllBackProps(this.ctx.path.getType())) {
                if (!backProp.isMiddleTableDefinition()) continue;
                if (middleTableOperators == null) {
                    middleTableOperators = new ArrayList();
                }
                middleTableOperator = MiddleTableOperator.backPropOf(this, backProp);
                if (middleTableOperator.middleTable.isReadonly()) continue;
                middleTableOperators.add(middleTableOperator);
            }
        }
        if (middleTableOperators == null) {
            return Collections.emptyList();
        }
        return middleTableOperators;
    }
}

