/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.mutation.save;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.meta.LogicalDeletedInfo;
import org.babyfish.jimmer.meta.PropId;
import org.babyfish.jimmer.meta.TargetLevel;
import org.babyfish.jimmer.meta.TypedProp;
import org.babyfish.jimmer.runtime.DraftSpi;
import org.babyfish.jimmer.runtime.ImmutableSpi;
import org.babyfish.jimmer.runtime.Internal;
import org.babyfish.jimmer.sql.DraftInterceptor;
import org.babyfish.jimmer.sql.DraftPreProcessor;
import org.babyfish.jimmer.sql.Key;
import org.babyfish.jimmer.sql.KeyUniqueConstraint;
import org.babyfish.jimmer.sql.ast.Expression;
import org.babyfish.jimmer.sql.ast.PropExpression;
import org.babyfish.jimmer.sql.ast.impl.mutation.SaveOptions;
import org.babyfish.jimmer.sql.ast.impl.mutation.save.Keys;
import org.babyfish.jimmer.sql.ast.impl.mutation.save.PreHandler;
import org.babyfish.jimmer.sql.ast.impl.mutation.save.SaveContext;
import org.babyfish.jimmer.sql.ast.impl.mutation.save.Shape;
import org.babyfish.jimmer.sql.ast.impl.mutation.save.ShapedEntityMap;
import org.babyfish.jimmer.sql.ast.impl.mutation.save.Tuples;
import org.babyfish.jimmer.sql.ast.impl.query.FilterLevel;
import org.babyfish.jimmer.sql.ast.impl.query.Queries;
import org.babyfish.jimmer.sql.ast.impl.value.PropertyGetter;
import org.babyfish.jimmer.sql.ast.mutation.LockMode;
import org.babyfish.jimmer.sql.ast.mutation.SaveMode;
import org.babyfish.jimmer.sql.ast.query.MutableQuery;
import org.babyfish.jimmer.sql.ast.table.Table;
import org.babyfish.jimmer.sql.fetcher.Fetcher;
import org.babyfish.jimmer.sql.fetcher.IdOnlyFetchType;
import org.babyfish.jimmer.sql.fetcher.impl.FetcherImpl;
import org.babyfish.jimmer.sql.meta.ColumnDefinition;
import org.babyfish.jimmer.sql.meta.MetadataStrategy;
import org.babyfish.jimmer.sql.runtime.ExecutionPurpose;
import org.babyfish.jimmer.sql.runtime.JSqlClientImplementor;
import org.babyfish.jimmer.sql.runtime.SaveException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class AbstractPreHandler
implements PreHandler {
    final SaveContext ctx;
    private final DraftPreProcessor<DraftSpi> processor;
    private final DraftInterceptor<Object, DraftSpi> interceptor;
    private final ImmutableProp idProp;
    final Set<ImmutableProp> keyProps;
    private final ImmutableProp versionProp;
    final List<DraftSpi> draftsWithId = new ArrayList<DraftSpi>();
    final List<DraftSpi> draftsWithKey = new ArrayList<DraftSpi>();
    private Map<Object, ImmutableSpi> idObjMap;
    private Map<Object, ImmutableSpi> keyObjMap;
    private Fetcher<ImmutableSpi> originalFetcher;
    private boolean resolved;

    AbstractPreHandler(SaveContext ctx) {
        this.ctx = ctx;
        this.processor = ctx.options.getSqlClient().getDraftPreProcessor(ctx.path.getType());
        this.interceptor = ctx.options.getSqlClient().getDraftInterceptor(ctx.path.getType());
        this.idProp = ctx.path.getType().getIdProp();
        this.keyProps = ctx.path.getType().getKeyProps();
        this.versionProp = ctx.path.getType().getVersionProp();
    }

    @Override
    public void add(DraftSpi draft) {
        if (this.processor != null) {
            this.processor.beforeSave(draft);
        }
        if (draft.__isLoaded(this.idProp.getId())) {
            this.draftsWithId.add(draft);
        } else {
            if (this.keyProps.isEmpty()) {
                throw new SaveException.NoKeyProps(this.ctx.path, "Cannot save \"" + this.ctx.path.getType() + "\" that have no properties decorated by \"@" + Key.class.getName() + "\"");
            }
            for (ImmutableProp keyProp : this.keyProps) {
                if (draft.__isLoaded(keyProp.getId())) continue;
                throw new SaveException.NoKeyProp(this.ctx.path, "Cannot save \"" + this.ctx.path.getType() + "\" with the unloaded key property \"" + keyProp + "\"");
            }
            this.draftsWithKey.add(draft);
        }
    }

    @Override
    @Nullable
    public Map<Object, ImmutableSpi> originalIdObjMap() {
        return this.idObjMap;
    }

    @Override
    @Nullable
    public Map<Object, ImmutableSpi> originalkeyObjMap() {
        return this.keyObjMap;
    }

    Map<Object, ImmutableSpi> findOldMapByIds() {
        Map<Object, ImmutableSpi> idObjMap = this.idObjMap;
        if (idObjMap == null) {
            ArrayList<Object> ids = new ArrayList<Object>(this.draftsWithId.size());
            for (DraftSpi draft : this.draftsWithId) {
                ids.add(draft.__get(this.idProp.getId()));
            }
            List<ImmutableSpi> entities = this.findOldList((q, t) -> q.where(t.get(this.idProp).in(ids)));
            if (entities.isEmpty()) {
                return Collections.emptyMap();
            }
            idObjMap = new LinkedHashMap<Object, ImmutableSpi>((entities.size() * 4 + 2) / 3);
            for (ImmutableSpi entity : entities) {
                idObjMap.put(entity.__get(this.idProp.getId()), entity);
            }
            this.idObjMap = idObjMap;
        }
        return idObjMap;
    }

    Map<Object, ImmutableSpi> findOldMapByKeys() {
        Map<Object, ImmutableSpi> keyObjMap = this.keyObjMap;
        if (keyObjMap == null) {
            Set<ImmutableProp> keyProps = this.keyProps;
            ArrayList<Object> keys = new ArrayList<Object>(this.draftsWithKey.size());
            for (DraftSpi draft : this.draftsWithKey) {
                keys.add(Keys.keyOf((ImmutableSpi)draft, keyProps));
            }
            List<ImmutableSpi> entities = this.findOldList((q, t) -> {
                Expression<Object> keyExpr;
                if (keyProps.size() == 1) {
                    keyExpr = t.get((ImmutableProp)keyProps.iterator().next());
                } else {
                    Expression[] arr = new Expression[keyProps.size()];
                    int index = 0;
                    for (ImmutableProp keyProp : keyProps) {
                        PropExpression expr = keyProp.isReference(TargetLevel.PERSISTENT) ? t.join(keyProp).get(keyProp.getTargetType().getIdProp()) : t.get(keyProp);
                        arr[index++] = expr;
                    }
                    keyExpr = Tuples.expressionOf(arr);
                }
                q.where(keyExpr.nullableIn(keys));
            });
            if (entities.isEmpty()) {
                return Collections.emptyMap();
            }
            keyObjMap = new LinkedHashMap<Object, ImmutableSpi>((entities.size() * 4 + 2) / 3);
            for (ImmutableSpi entity : entities) {
                ImmutableSpi conflictEntity = keyObjMap.put(Keys.keyOf(entity, keyProps), entity);
                if (conflictEntity == null) continue;
                throw new SaveException.KeyNotUnique(this.ctx.path, "Key properties " + keyProps + " cannot guarantee uniqueness under that path, do you forget to add unique constraint for that key?");
            }
            this.keyObjMap = keyObjMap;
        }
        return keyObjMap;
    }

    @NotNull
    private List<ImmutableSpi> findOldList(BiConsumer<MutableQuery, Table<?>> block) {
        ImmutableType type = this.ctx.path.getType();
        SaveOptions options = this.ctx.options;
        return (List)Internal.requiresNewDraftContext(draftContext -> {
            List list = (List)Queries.createQuery(options.getSqlClient(), type, ExecutionPurpose.MUTATE, FilterLevel.DEFAULT, (q, table) -> {
                block.accept((MutableQuery)q, (Table<?>)table);
                if (this.ctx.trigger != null) {
                    return q.select(table);
                }
                return q.select(table.fetch(this.originalFetcher()));
            }).forUpdate(options.getLockMode() == LockMode.PESSIMISTIC).execute(this.ctx.con);
            return draftContext.resolveList(list);
        });
    }

    private Fetcher<ImmutableSpi> originalFetcher() {
        Fetcher<ImmutableSpi> oldFetcher = this.originalFetcher;
        if (oldFetcher == null) {
            Collection<TypedProp<?, ?>> typedProps;
            ImmutableType type = this.ctx.path.getType();
            Fetcher fetcherImplementor = new FetcherImpl(this.ctx.path.getType().getJavaClass());
            for (ImmutableProp keyProp : this.keyProps) {
                fetcherImplementor = fetcherImplementor.add(keyProp.getName(), IdOnlyFetchType.RAW);
            }
            DraftInterceptor<?, ?> interceptor = this.ctx.options.getSqlClient().getDraftInterceptor(type);
            if (interceptor != null && (typedProps = interceptor.dependencies()) != null) {
                for (TypedProp<?, ?> typedProp : typedProps) {
                    fetcherImplementor = fetcherImplementor.add(typedProp.unwrap().getName(), IdOnlyFetchType.RAW);
                }
            }
            if (this.ctx.backReferenceFrozen) {
                fetcherImplementor = fetcherImplementor.add(this.ctx.backReferenceProp.getName(), IdOnlyFetchType.RAW);
            }
            this.originalFetcher = oldFetcher = fetcherImplementor;
        }
        return oldFetcher;
    }

    final boolean isQueryRequiredForUpdate(boolean hashId, Collection<DraftSpi> drafts) {
        if (this.interceptor != null || this.ctx.trigger != null || this.ctx.backReferenceFrozen) {
            return true;
        }
        JSqlClientImplementor sqlClient = this.ctx.options.getSqlClient();
        if (this.ctx.options.getMode() == SaveMode.UPSERT) {
            boolean usingOptimisticLock;
            if (!sqlClient.getDialect().isUpsertSupported()) {
                return true;
            }
            boolean bl = usingOptimisticLock = this.ctx.path.getType().getVersionProp() != null || this.ctx.options.getUserOptimisticLock(this.ctx.path.getType()) != null;
            if (usingOptimisticLock) {
                return true;
            }
            if (!hashId) {
                KeyUniqueConstraint constraint = this.ctx.path.getType().getJavaClass().getAnnotation(KeyUniqueConstraint.class);
                if (constraint == null) {
                    return true;
                }
                if (!constraint.noMoreUniqueConstraints() && !sqlClient.getDialect().isUpsertWithMultipleUniqueConstraintSupported()) {
                    return true;
                }
                if (constraint.isNullNotDistinct()) {
                    Set<ImmutableProp> keyProps = this.ctx.options.getKeyProps(this.ctx.path.getType());
                    ArrayList<PropertyGetter> nullableGetters = new ArrayList<PropertyGetter>();
                    for (PropertyGetter getter : Shape.fullOf(sqlClient, this.ctx.path.getType().getJavaClass()).getGetters()) {
                        if (!getter.metadata().isNullable() || !keyProps.contains(getter.prop())) continue;
                        nullableGetters.add(getter);
                    }
                    if (!nullableGetters.isEmpty()) {
                        for (DraftSpi draft : drafts) {
                            for (PropertyGetter nullableGetter : nullableGetters) {
                                if (nullableGetter.get(draft) != null) continue;
                                return true;
                            }
                        }
                    }
                }
            }
        }
        if (this.ctx.options.getMode() == SaveMode.UPDATE_ONLY) {
            MetadataStrategy strategy = sqlClient.getMetadataStrategy();
            for (DraftSpi draft : drafts) {
                for (ImmutableProp prop : this.ctx.path.getType().getProps().values()) {
                    if (!draft.__isLoaded(prop.getId()) || !prop.isAssociation(TargetLevel.PERSISTENT) || prop.getStorage(strategy) instanceof ColumnDefinition || !draft.__isLoaded(prop.getId())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    final void callInterceptor(DraftSpi draft, ImmutableSpi original) {
        if (original == null && this.ctx.options.getMode() != SaveMode.UPDATE_ONLY) {
            this.assignId(draft);
            this.assignVersion(draft);
            this.assignLocalDeletedInfo(draft);
        }
        if (this.interceptor != null) {
            this.interceptor.beforeSave(draft, original);
        }
    }

    private void assignId(DraftSpi draft) {
        PropId idPropId = this.idProp.getId();
        if (draft.__isLoaded(idPropId)) {
            return;
        }
        Object id = this.ctx.allocateId();
        if (id != null) {
            draft.__set(idPropId, id);
        }
    }

    private void assignVersion(DraftSpi draft) {
        ImmutableProp versionProp = this.versionProp;
        if (versionProp == null) {
            return;
        }
        PropId versionPropId = versionProp.getId();
        if (!draft.__isLoaded(versionPropId)) {
            draft.__set(versionPropId, (Object)0);
        }
    }

    private void assignLocalDeletedInfo(DraftSpi draft) {
        LogicalDeletedInfo logicalDeletedInfo = this.ctx.path.getType().getLogicalDeletedInfo();
        if (logicalDeletedInfo == null) {
            return;
        }
        Object value = logicalDeletedInfo.allocateInitializedValue();
        draft.__set(logicalDeletedInfo.getProp().getId(), value);
    }

    final void resolve() {
        if (!this.resolved) {
            this.onResolve();
            this.resolved = true;
        }
    }

    abstract void onResolve();

    final ShapedEntityMap<DraftSpi> createEntityMap(Collection<DraftSpi> c1, Collection<DraftSpi> c2) {
        ShapedEntityMap<DraftSpi> entityMap = new ShapedEntityMap<DraftSpi>(this.ctx.options.getSqlClient(), this.keyProps);
        if (c1 != null) {
            for (DraftSpi draft : c1) {
                entityMap.add(draft);
            }
        }
        if (c2 != null) {
            for (DraftSpi draft : c2) {
                entityMap.add(draft);
            }
        }
        return entityMap;
    }
}

