/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.cache.spi;

import java.util.Collections;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.sql.cache.CacheTracker;
import org.babyfish.jimmer.sql.cache.chain.Binder;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractBinder<K>
implements Binder<K> {
    protected final ImmutableType type;
    protected final ImmutableProp prop;

    public AbstractBinder(@Nullable ImmutableType type, @Nullable ImmutableProp prop, @Nullable CacheTracker tracker) {
        if (type == null == (prop == null)) {
            throw new IllegalArgumentException("The nullity of type and prop must be different");
        }
        if (prop == null) {
            this.type = type;
            this.prop = null;
        } else {
            this.type = null;
            this.prop = prop;
        }
        if (tracker != null) {
            tracker.addInvalidationListener(new InvalidationListenerImpl());
            tracker.addReconnectListener(this::invalidateAll);
        }
    }

    @Override
    @Nullable
    public final ImmutableType type() {
        return this.type;
    }

    @Override
    @Nullable
    public final ImmutableProp prop() {
        return this.prop;
    }

    protected abstract void invalidateAll();

    private class InvalidationListenerImpl
    implements CacheTracker.InvalidationListener {
        private InvalidationListenerImpl() {
        }

        @Override
        public void onInvalidate(CacheTracker.InvalidationEvent event) {
            if (AbstractBinder.this.type == event.getType() && AbstractBinder.this.prop == event.getProp()) {
                AbstractBinder.this.deleteAll(Collections.singleton(event.getId()), null);
            }
        }
    }
}

