/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.cache.redisson;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.util.UUID;
import org.babyfish.jimmer.jackson.ImmutableModule;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.sql.cache.CacheTracker;
import org.babyfish.jimmer.sql.cache.spi.AbstractCacheTracker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.redisson.api.RTopic;
import org.redisson.api.RedissonClient;
import org.redisson.api.listener.BaseStatusListener;
import org.redisson.api.listener.MessageListener;
import org.redisson.api.listener.StatusListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedissonCacheTracker
extends AbstractCacheTracker {
    private static final Logger LOGGER = LoggerFactory.getLogger(RedissonCacheTracker.class);
    private static final ObjectMapper MAPPER = new ObjectMapper().registerModule((Module)new JavaTimeModule()).registerModule((Module)new ImmutableModule());
    private static final String CHANNEL = "_jimmer_:invalidate";
    private final UUID trackerId = UUID.randomUUID();
    private final RTopic topic;

    public RedissonCacheTracker(RedissonClient redisson) {
        this.topic = redisson.getTopic(CHANNEL);
        this.topic.addListener(InvalidationMessage.class, (MessageListener)new MessageListener<InvalidationMessage>(){

            public void onMessage(CharSequence channel, InvalidationMessage msg) {
                if (!msg.trackerId.equals(RedissonCacheTracker.this.trackerId)) {
                    RedissonCacheTracker.this.firer().invalidate(msg.toEvent());
                }
            }
        });
        this.topic.addListener((StatusListener)new BaseStatusListener(){

            public void onSubscribe(String channel) {
                RedissonCacheTracker.this.firer().reconnect();
            }
        });
    }

    @Override
    protected void publishInvalidationEvent(CacheTracker.InvalidationEvent event) {
        this.topic.publish((Object)new InvalidationMessage(this.trackerId, event.getType().toString(), event.getProp() != null ? event.getProp().getName() : null, event.getId().toString()));
    }

    private static class InvalidationMessage {
        @NotNull
        final UUID trackerId;
        @NotNull
        final String typeName;
        @Nullable
        final String propName;
        @NotNull
        final String id;

        InvalidationMessage(@NotNull UUID trackerId, @NotNull String typeName, @Nullable String propName, @NotNull String id) {
            this.trackerId = trackerId;
            this.typeName = typeName;
            this.propName = propName;
            this.id = id;
        }

        CacheTracker.InvalidationEvent toEvent() {
            Object id;
            Class<?> javaType;
            try {
                javaType = Class.forName(this.typeName, true, Thread.currentThread().getContextClassLoader());
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException("Cannot resolve the type name \"" + this.typeName + "\"");
            }
            ImmutableType type = ImmutableType.get(javaType);
            try {
                id = MAPPER.readValue(this.id, type.getIdProp().getReturnClass());
            }
            catch (JsonProcessingException e) {
                throw new IllegalStateException("Can not parse \"id\" to the type \"" + type.getIdProp().getReturnClass().getName() + "\"");
            }
            if (this.propName != null) {
                ImmutableProp prop = type.getProp(this.propName);
                return new CacheTracker.InvalidationEvent(prop, id);
            }
            return new CacheTracker.InvalidationEvent(type, id);
        }
    }
}

