/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.cache.chain;

import java.time.Duration;
import java.util.Collection;
import java.util.Map;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.sql.cache.CacheLocker;
import org.babyfish.jimmer.sql.cache.chain.LockableBinder;
import org.babyfish.jimmer.sql.cache.chain.LockedBinder;
import org.babyfish.jimmer.sql.cache.chain.SimpleBinder;
import org.jetbrains.annotations.Nullable;

class LockedSimpleBinder<K, V>
implements SimpleBinder<K, V>,
LockedBinder<K, V> {
    private final LockableBinder<K, V> raw;
    private final CacheLocker locker;
    private final Duration waitDuration;
    private final Duration leaseDuration;

    LockedSimpleBinder(LockableBinder<K, V> raw, CacheLocker locker, Duration waitDuration, Duration leaseDuration) {
        if (raw instanceof LockedBinder) {
            raw = ((LockedBinder)((Object)raw)).unwrap();
        }
        if (raw instanceof SimpleBinder.Parameterized) {
            throw new IllegalArgumentException("The raw binder cannot be \"" + SimpleBinder.Parameterized.class.getName() + "\"");
        }
        this.raw = raw;
        this.locker = locker;
        this.waitDuration = waitDuration;
        this.leaseDuration = leaseDuration;
    }

    @Override
    public LockableBinder<K, V> unwrap() {
        return this.raw;
    }

    @Override
    public CacheLocker locker() {
        return this.locker;
    }

    @Override
    public Duration waitDuration() {
        return this.waitDuration;
    }

    @Override
    public Duration leaseDuration() {
        return this.leaseDuration;
    }

    @Override
    @Nullable
    public ImmutableType type() {
        return this.raw.type();
    }

    @Override
    @Nullable
    public ImmutableProp prop() {
        return this.raw.prop();
    }

    @Override
    public Map<K, V> getAll(Collection<K> keys) {
        return this.raw.getAll(keys);
    }

    @Override
    public void setAll(Map<K, V> map) {
        this.raw.setAll(map);
    }

    @Override
    public void deleteAll(Collection<K> keys, Object reason) {
        this.raw.deleteAll(keys, reason);
    }
}

