/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.cache.caffeine;

import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.babyfish.jimmer.lang.Ref;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.sql.cache.CacheTracker;
import org.babyfish.jimmer.sql.cache.chain.CacheChain;
import org.babyfish.jimmer.sql.cache.chain.LoadingBinder;
import org.babyfish.jimmer.sql.cache.spi.AbstractBinder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CaffeineValueBinder<K, V>
extends AbstractBinder<K>
implements LoadingBinder<K, V> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CaffeineValueBinder.class);
    private final int maximumSize;
    private final Duration duration;
    private LoadingCache<K, Ref<V>> loadingCache;

    protected CaffeineValueBinder(@Nullable ImmutableType type, @Nullable ImmutableProp prop, @Nullable CacheTracker tracker, int maximumSize, @NotNull Duration duration) {
        super(type, prop, tracker);
        this.maximumSize = maximumSize;
        this.duration = duration;
    }

    @Override
    public void initialize(final CacheChain<K, V> chain) {
        this.loadingCache = Caffeine.newBuilder().maximumSize((long)this.maximumSize).expireAfterWrite(this.duration).build(new CacheLoader<K, Ref<V>>(){

            public Ref<V> load(K key) {
                Map map = chain.loadAll(Collections.singleton(key));
                Object value = map.get(key);
                if (value != null || map.containsKey(key)) {
                    return Ref.of(value);
                }
                return null;
            }

            public Map<K, Ref<V>> loadAll(Iterable<? extends K> keys) {
                Map map = chain.loadAll((Collection)keys);
                return map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> Ref.of(e.getValue())));
            }
        });
    }

    @Override
    public Map<K, V> getAll(Collection<K> keys) {
        Map map = this.loadingCache.getAll(keys);
        HashMap convertedMap = new HashMap((map.size() * 4 + 2) / 3);
        for (Map.Entry e : map.entrySet()) {
            convertedMap.put(e.getKey(), ((Ref)e.getValue()).getValue());
        }
        return convertedMap;
    }

    @Override
    public void deleteAll(Collection<K> keys, Object reason) {
        if (reason == null || reason.equals("caffeine")) {
            this.loadingCache.invalidateAll(keys);
        }
    }

    @Override
    protected void invalidateAll() {
        this.loadingCache.invalidateAll();
    }

    @NotNull
    public static <K, V> Builder<K, V> forObject(ImmutableType type) {
        return new Builder(type, null);
    }

    @NotNull
    public static <K, V> Builder<K, V> forProp(ImmutableProp prop) {
        return new Builder(null, prop);
    }

    public static class Builder<K, V> {
        private final ImmutableType type;
        private final ImmutableProp prop;
        private CacheTracker tracker;
        private int maximumSize = 100;
        private Duration duration = Duration.ofMinutes(1L);

        public Builder(ImmutableType type, ImmutableProp prop) {
            this.type = type;
            this.prop = prop;
        }

        public Builder<K, V> subscribe(CacheTracker tracker) {
            this.tracker = tracker;
            return this;
        }

        public Builder<K, V> maximumSize(int maximumSize) {
            this.maximumSize = maximumSize;
            return this;
        }

        public Builder<K, V> duration(Duration duration) {
            this.duration = duration;
            return this;
        }

        public CaffeineValueBinder<K, V> build() {
            return new CaffeineValueBinder(this.type, this.prop, this.tracker, this.maximumSize, this.duration);
        }
    }
}

