/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.cache;

import java.time.Duration;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.sql.cache.Cache;
import org.babyfish.jimmer.sql.cache.CacheLocker;
import org.babyfish.jimmer.sql.cache.CacheTracker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface CacheCreator {
    public static final Duration DEFAULT_REMOTE_DURATION = Duration.ofMinutes(30L);
    public static final int DEFAULT_REMOTE_DURATION_RANDOM_PERCENT = 30;
    public static final int DEFAULT_LOCAL_CACHE_MAX_SIZE = 100;
    public static final Duration DEFAULT_LOCAL_DURATION = Duration.ofMinutes(1L);

    @NotNull
    default public CacheCreator withRemoteDuration(@Nullable Duration duration) {
        return this.withRemoteDuration(duration, 30);
    }

    @NotNull
    public CacheCreator withRemoteDuration(@Nullable Duration var1, int var2);

    @NotNull
    default public CacheCreator withLocalCache(int maxSize) {
        return this.withLocalCache(maxSize, DEFAULT_LOCAL_DURATION);
    }

    @NotNull
    default public CacheCreator withLocalCache(Duration duration) {
        return this.withLocalCache(100, duration);
    }

    @NotNull
    public CacheCreator withLocalCache(int var1, @Nullable Duration var2);

    @NotNull
    default public CacheCreator withoutLocalCache() {
        return this.withLocalCache(0, null);
    }

    @NotNull
    public CacheCreator withLock(@Nullable CacheLocker var1, @Nullable Duration var2, @Nullable Duration var3);

    @NotNull
    default public CacheCreator withHardLock(@Nullable CacheLocker locker, @Nullable Duration leaseDuration) {
        return this.withLock(locker, null, leaseDuration);
    }

    @NotNull
    default public CacheCreator withSoftLock(@Nullable CacheLocker locker, @Nullable Duration leaseDuration) {
        return this.withLock(locker, Duration.ZERO, leaseDuration);
    }

    @NotNull
    default public CacheCreator withoutLock() {
        return this.withLock(null, null, null);
    }

    @NotNull
    public CacheCreator withTracking(@Nullable CacheTracker var1);

    @NotNull
    default public CacheCreator withoutTracking() {
        return this.withTracking(null);
    }

    public <K, V> Cache<K, V> createForObject(ImmutableType var1);

    public <K, V> Cache<K, V> createForProp(ImmutableProp var1, boolean var2);
}

