/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.util;

public abstract class AbstractIdentityDataManager<K, V> {
    private static final int CAPACITY = 8;
    private final Node<K, V>[] tab = new Node[8];

    protected V getValue(K key) {
        int h = System.identityHashCode(key);
        h ^= h >>> 16;
        int index = 7 & h;
        Node<K, V> node = this.tab[index];
        while (node != null) {
            if (node.key == key) {
                return node.value;
            }
            node = node.next;
        }
        return null;
    }

    protected V getOrCreateValue(K key) {
        Node<K, V> startNode;
        int h = System.identityHashCode(key);
        h ^= h >>> 16;
        int index = 7 & h;
        Node<K, V> node = startNode = this.tab[index];
        while (node != null) {
            if (node.key == key) {
                return node.value;
            }
            node = node.next;
        }
        V value = this.createValue(key);
        this.tab[index] = new Node(h, key, value, startNode);
        return value;
    }

    protected boolean putValue(K key, V value) {
        Node<K, V> startNode;
        int h = System.identityHashCode(key);
        h ^= h >>> 16;
        int index = 7 & h;
        Node<K, V> node = startNode = this.tab[index];
        while (node != null) {
            if (node.key == key) {
                node.value = value;
                return false;
            }
            node = node.next;
        }
        this.tab[index] = new Node(h, key, value, startNode);
        return true;
    }

    protected abstract V createValue(K var1);

    private static class Node<K, V> {
        final int hash;
        final K key;
        V value;
        Node<K, V> next;

        private Node(int hash, K key, V value, Node<K, V> next) {
            this.hash = hash;
            this.key = key;
            this.value = value;
            this.next = next;
        }
    }
}

