/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.render;

import org.babyfish.jimmer.meta.LogicalDeletedInfo;
import org.babyfish.jimmer.sql.ast.impl.value.ValueGetter;
import org.babyfish.jimmer.sql.runtime.JSqlClientImplementor;
import org.babyfish.jimmer.sql.runtime.SqlFormatter;

public abstract class AbstractSqlBuilder<T extends AbstractSqlBuilder<T>> {
    protected final StringBuilder builder = new StringBuilder();
    private boolean indentRequired;

    protected abstract SqlFormatter formatter();

    protected abstract ScopeManager scopeManager();

    public abstract JSqlClientImplementor sqlClient();

    public T sql(String sql) {
        this.preAppend();
        this.builder.append(sql);
        return (T)this;
    }

    public T sql(ValueGetter getter) {
        getter.metadata().renderTo(this);
        return (T)this;
    }

    public T logicalDeleteAssignment(LogicalDeletedInfo logicalDeletedInfo, String alias) {
        String assignedName = logicalDeletedInfo.getColumnName();
        if (alias != null) {
            assignedName = alias + '.' + assignedName;
        }
        ((AbstractSqlBuilder)this.sql(assignedName)).sql(" = ");
        Object value = logicalDeletedInfo.generateValue();
        if (value == null) {
            this.sql("null");
        } else {
            this.rawVariable(value);
        }
        return (T)this;
    }

    public T logicalDeleteFilter(LogicalDeletedInfo logicalDeletedInfo, String alias) {
        LogicalDeletedInfo.Action action;
        String assignedName = logicalDeletedInfo.getColumnName();
        if (alias != null) {
            assignedName = alias + '.' + assignedName;
        }
        if ((action = logicalDeletedInfo.getAction()) instanceof LogicalDeletedInfo.Action.Eq) {
            LogicalDeletedInfo.Action.Eq eq = (LogicalDeletedInfo.Action.Eq)action;
            ((AbstractSqlBuilder)this.sql(assignedName)).sql(" = ");
            this.rawVariable(eq.getValue());
        } else if (action instanceof LogicalDeletedInfo.Action.Ne) {
            LogicalDeletedInfo.Action.Ne ne = (LogicalDeletedInfo.Action.Ne)action;
            ((AbstractSqlBuilder)this.sql(assignedName)).sql(" <> ");
            this.rawVariable(ne.getValue());
        } else if (action instanceof LogicalDeletedInfo.Action.IsNull) {
            ((AbstractSqlBuilder)this.sql(assignedName)).sql(" is null");
        } else if (action instanceof LogicalDeletedInfo.Action.IsNotNull) {
            ((AbstractSqlBuilder)this.sql(assignedName)).sql(" is not null");
        }
        return (T)this;
    }

    public abstract T rawVariable(Object var1);

    public T enter(String separator) {
        this.enterImpl(ScopeType.BLANK, separator);
        return (T)this;
    }

    public T enter(ScopeType type) {
        this.enterImpl(type, null);
        return (T)this;
    }

    private void enterImpl(ScopeType type, String separator) {
        boolean ignored;
        ScopeManager scopeManager = this.scopeManager();
        Scope parentScope = scopeManager.current;
        boolean bl = ignored = type == ScopeType.NULL || type == ScopeType.TUPLE && parentScope != null && parentScope.type == ScopeType.TUPLE;
        if (!ignored) {
            if (type == ScopeType.SMART_OR) {
                if (parentScope == null) {
                    this.part(ScopeType.SUB_QUERY.prefix);
                } else if (parentScope.isAndLike()) {
                    this.part(ScopeType.SUB_QUERY.prefix);
                }
            } else {
                this.part(type.prefix);
            }
        }
        scopeManager.current = new Scope(parentScope, type, ignored, separator);
    }

    public T separator() {
        Scope scope = this.scopeManager().current;
        if (scope != null && scope.dirty) {
            boolean forceInLine = false;
            if (scope.type == ScopeType.LIST) {
                boolean bl = forceInLine = ++scope.listSeparatorCount < this.formatter().getListParamCountInLine();
                if (!forceInLine) {
                    scope.listSeparatorCount = 0;
                }
            }
            if (scope.type.isSeparatorIndent) {
                this.part(scope.separator, forceInLine);
            } else {
                --scope.depth;
                this.part(scope.separator, forceInLine);
                ++scope.depth;
            }
            scope.dirty = false;
        }
        return (T)this;
    }

    public T leave() {
        Scope parentScope;
        ScopeManager scopeManager = this.scopeManager();
        Scope scope = scopeManager.current;
        scopeManager.current = parentScope = scope.parent;
        if (!scope.ignored) {
            if (scope.type == ScopeType.SMART_OR) {
                if (parentScope == null) {
                    this.part(ScopeType.SUB_QUERY.suffix);
                } else if (parentScope.isAndLike()) {
                    this.part(ScopeType.SUB_QUERY.suffix);
                }
            } else {
                this.part(scope.type.suffix);
            }
        }
        return (T)this;
    }

    private void part(ScopeType.Part part) {
        this.part(part, false);
    }

    private void part(ScopeType.Part part, boolean forceInLine) {
        if (part == null) {
            return;
        }
        this.space(part.before, forceInLine);
        this.preAppend();
        this.builder.append(part.value);
        this.space(part.after, forceInLine);
    }

    public T space(char ch) {
        return this.space(ch, false);
    }

    public T space(char ch, boolean forceInLine) {
        switch (ch) {
            case '?': {
                if (!forceInLine && this.formatter().isPretty()) {
                    this.newLine();
                    break;
                }
                this.preAppend();
                this.builder.append(' ');
                break;
            }
            case ' ': {
                this.preAppend();
                this.builder.append(' ');
                break;
            }
            case '\n': {
                if (forceInLine || !this.formatter().isPretty()) break;
                this.newLine();
            }
        }
        return (T)this;
    }

    protected final void preAppend() {
        Scope scope = this.scopeManager().current;
        if (scope != null) {
            scope.setDirty();
        }
        if (scope == null || !this.indentRequired) {
            this.indentRequired = false;
            return;
        }
        this.indentRequired = false;
        String indent = this.formatter().getIndent();
        for (int i = scope.depth; i > 0; --i) {
            this.builder.append(indent);
        }
    }

    private void newLine() {
        this.builder.append('\n');
        this.indentRequired = true;
    }

    public static enum ScopeType {
        NULL(null, null, null),
        BLANK(null, null, null),
        SELECT("select?", ",?", null),
        SELECT_DISTINCT("select distinct?", ",?", null),
        SET("?set?", ",?", null),
        WHERE("?where?", "?and?", null),
        ORDER_BY("?order by?", ",?", null),
        GROUP_BY("?group by?", ",?", null),
        HAVING("?having?", "?and?", null),
        SUB_QUERY("(\n", null, "\n)"),
        LIST("(\n", ",?", "\n)"),
        COMMA(null, ",?", null),
        TUPLE("(", ", ", ")"),
        AND(null, "?and?", null, false),
        OR(null, "?or?", null, false),
        SMART_OR(null, "?or?", null, false),
        VALUES("?values\n", ",?", null);

        final Part prefix;
        final Part separator;
        final Part suffix;
        final boolean isSeparatorIndent;

        private ScopeType(String prefix, String separator, String suffix) {
            this(prefix, separator, suffix, true);
        }

        private ScopeType(String prefix, String separator, String suffix, boolean isSeparatorIndent) {
            this.prefix = ScopeType.partOf(prefix);
            this.separator = ScopeType.partOf(separator);
            this.suffix = ScopeType.partOf(suffix);
            this.isSeparatorIndent = isSeparatorIndent;
        }

        private static Part partOf(String value) {
            if (value == null) {
                return null;
            }
            char before = ScopeType.spaceChar(value.charAt(0));
            char after = value.length() > 1 ? ScopeType.spaceChar(value.charAt(value.length() - 1)) : (char)'\u0000';
            return new Part(before, value.substring(before == '\u0000' ? 0 : 1, value.length() - (after == '\u0000' ? 0 : 1)), after);
        }

        private static char spaceChar(char c) {
            return c == ' ' || c == '\n' || c == '?' ? c : (char)'\u0000';
        }

        private static class Part {
            final char before;
            final String value;
            final char after;

            Part(char before, String value, char after) {
                this.before = before;
                this.value = value;
                this.after = after;
            }
        }
    }

    protected static class ScopeManager {
        public Scope current;

        public Scope cloneScope() {
            if (this.current == null) {
                return null;
            }
            return new Scope(this.current);
        }
    }

    protected static class Scope {
        final Scope parent;
        final ScopeType type;
        final boolean ignored;
        final ScopeType.Part separator;
        int depth;
        boolean dirty;
        int listSeparatorCount;

        Scope(Scope parent, ScopeType type, boolean ignored, String separator) {
            this.parent = parent;
            this.type = type;
            this.ignored = ignored;
            this.depth = ignored ? (parent != null ? parent.depth : 0) : (parent != null ? parent.depth + 1 : 1);
            this.separator = separator != null ? ScopeType.partOf(separator) : type.separator;
        }

        Scope(Scope base) {
            this.parent = base.parent != null ? new Scope(base.parent) : null;
            this.type = base.type;
            this.ignored = base.ignored;
            this.separator = base.separator;
            this.depth = base.depth;
            this.dirty = base.dirty;
            this.listSeparatorCount = base.listSeparatorCount;
        }

        void setDirty() {
            Scope scope = this;
            while (scope != null && !scope.dirty) {
                scope.dirty = true;
                scope = scope.parent;
            }
        }

        public boolean isAndLike() {
            Scope scope = this;
            while (scope != null) {
                ScopeType scopeType = scope.type;
                if (scopeType != ScopeType.NULL) {
                    return scopeType == ScopeType.AND || scopeType == ScopeType.WHERE || scopeType == ScopeType.HAVING;
                }
                scope = scope.parent;
            }
            return false;
        }
    }
}

