/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.mutation.save;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.babyfish.jimmer.meta.PropId;
import org.babyfish.jimmer.runtime.ImmutableSpi;
import org.babyfish.jimmer.sql.ast.impl.mutation.save.EsNode;
import org.jetbrains.annotations.NotNull;

public class EntitySet<E>
extends EsNode<E>
implements Collection<E> {
    private static final int CAPACITY = 8;
    private final PropId[] propIds;
    private EsNode<E>[] tab;
    private int size;
    private int modCount;

    EntitySet(PropId[] propIds) {
        super(0, null, null, null, null);
        this.propIds = propIds;
        this.before = this;
        this.after = this;
    }

    @Override
    public boolean isEmpty() {
        return this.after == this;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean contains(Object o) {
        EsNode<E> startNode;
        if (this.tab == null) {
            return false;
        }
        int h = this.h((ImmutableSpi)this.data);
        h ^= h >>> 16;
        int index = 7 & h;
        EsNode<E> node = startNode = this.tab[index];
        while (node != null) {
            if (node.hash == h && this.eq((ImmutableSpi)node.data, (ImmutableSpi)this.data)) {
                return true;
            }
            node = node.next;
        }
        return false;
    }

    @Override
    public boolean containsAll(@NotNull Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean add(E data) {
        EsNode<E> startNode;
        if (this.tab == null) {
            this.tab = new EsNode[8];
        }
        int h = this.h((ImmutableSpi)data);
        h ^= h >>> 16;
        int index = 7 & h;
        EsNode<E> node = startNode = this.tab[index];
        while (node != null) {
            if (node.hash == h && this.eq((ImmutableSpi)node.data, (ImmutableSpi)data)) {
                node.data = data;
                ++this.modCount;
                return false;
            }
            node = node.next;
        }
        EsNode last = this.before;
        EsNode<E> node2 = new EsNode<E>(h, data, startNode, last, this);
        last.after = node2;
        this.before = node2;
        this.tab[index] = node2;
        ++this.modCount;
        ++this.size;
        return true;
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends E> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(@NotNull Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(@NotNull Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public Iterator<E> iterator() {
        if (this.after == this) {
            return Collections.emptyIterator();
        }
        return new Itr();
    }

    @Override
    @NotNull
    public @NotNull Object @NotNull [] toArray() {
        Object[] arr = new Object[this.size];
        int index = 0;
        for (E e : this) {
            arr[index++] = e;
        }
        return arr;
    }

    @Override
    public <T> T @NotNull [] toArray(@NotNull T[] a) {
        T[] arr = a.length < this.size ? (Object[])Array.newInstance(a.getClass().getComponentType(), this.size) : a;
        int index = 0;
        for (E e : this) {
            arr[index++] = e;
        }
        return arr;
    }

    public E first() {
        EsNode after = this.after;
        if (after == this) {
            throw new NoSuchElementException();
        }
        return after.data;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        boolean addComma = false;
        for (E e : this) {
            if (addComma) {
                builder.append(", ");
            } else {
                addComma = true;
            }
            builder.append(e);
        }
        builder.append("]");
        return builder.toString();
    }

    private int h(ImmutableSpi spi) {
        int hash = 1;
        for (int i = this.propIds.length - 1; i >= 0; --i) {
            Object v = spi.__get(this.propIds[i]);
            hash = hash * 31 + (v != null ? v.hashCode() : 0);
        }
        return hash;
    }

    private boolean eq(ImmutableSpi a, ImmutableSpi b) {
        for (int i = this.propIds.length - 1; i >= 0; --i) {
            Object v2;
            Object v1 = a.__get(this.propIds[i]);
            if (Objects.equals(v1, v2 = b.__get(this.propIds[i]))) continue;
            return false;
        }
        return true;
    }

    private class Itr
    implements Iterator<E> {
        private final int modCount;
        private EsNode<E> current;

        public Itr() {
            this.modCount = EntitySet.this.modCount;
            this.current = EntitySet.this.after;
        }

        @Override
        public boolean hasNext() {
            if (EntitySet.this.modCount != this.modCount) {
                throw new ConcurrentModificationException();
            }
            return this.current != EntitySet.this;
        }

        @Override
        public E next() {
            if (EntitySet.this.modCount != this.modCount) {
                throw new ConcurrentModificationException();
            }
            if (this.current == EntitySet.this) {
                throw new NoSuchElementException();
            }
            Object data = this.current.data;
            this.current = this.current.after;
            return data;
        }
    }
}

