/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.mutation;

import java.sql.Connection;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.babyfish.jimmer.sql.association.meta.AssociationType;
import org.babyfish.jimmer.sql.ast.Executable;
import org.babyfish.jimmer.sql.ast.Expression;
import org.babyfish.jimmer.sql.ast.impl.AstContext;
import org.babyfish.jimmer.sql.ast.impl.mutation.MiddleTableOperator;
import org.babyfish.jimmer.sql.ast.impl.mutation.MutationTrigger;
import org.babyfish.jimmer.sql.ast.impl.mutation.NativePredicates;
import org.babyfish.jimmer.sql.ast.impl.render.AbstractSqlBuilder;
import org.babyfish.jimmer.sql.ast.tuple.Tuple2;
import org.babyfish.jimmer.sql.ast.tuple.Tuple3;
import org.babyfish.jimmer.sql.event.TriggerType;
import org.babyfish.jimmer.sql.meta.MetadataStrategy;
import org.babyfish.jimmer.sql.meta.MiddleTable;
import org.babyfish.jimmer.sql.runtime.ExecutionPurpose;
import org.babyfish.jimmer.sql.runtime.JSqlClientImplementor;
import org.babyfish.jimmer.sql.runtime.Selectors;
import org.babyfish.jimmer.sql.runtime.SqlBuilder;
import org.jetbrains.annotations.Nullable;

class AssociationExecutable
implements Executable<Integer> {
    final JSqlClientImplementor sqlClient;
    final Connection con;
    private final AssociationType associationType;
    private final boolean reversed;
    private final boolean forDelete;
    private final boolean defaultCheckExistence;
    private final Boolean nullOrCheckedExistence;
    private final Set<Tuple2<?, ?>> idTuples;

    public AssociationExecutable(JSqlClientImplementor sqlClient, Connection con, AssociationType associationType, boolean reversed, boolean forDelete, boolean defaultCheckExistence, Collection<Tuple2<?, ?>> idTuples) {
        this(sqlClient, con, associationType, reversed, forDelete, defaultCheckExistence, null, idTuples);
    }

    private AssociationExecutable(JSqlClientImplementor sqlClient, Connection con, AssociationType associationType, boolean reversed, boolean forDelete, boolean defaultCheckExistence, Boolean nullOrCheckedExistence, Collection<Tuple2<?, ?>> idTuples) {
        this.sqlClient = sqlClient;
        this.con = con;
        this.associationType = associationType;
        this.reversed = reversed;
        this.forDelete = forDelete;
        this.defaultCheckExistence = defaultCheckExistence;
        this.nullOrCheckedExistence = nullOrCheckedExistence;
        this.idTuples = idTuples instanceof Set ? (Set<Object>)idTuples : new LinkedHashSet(idTuples);
    }

    public AssociationExecutable setCheckExistence(@Nullable Boolean checkExistence) {
        if (this.nullOrCheckedExistence == checkExistence) {
            return this;
        }
        return new AssociationExecutable(this.sqlClient, this.con, this.associationType, this.reversed, this.forDelete, this.defaultCheckExistence, checkExistence, this.idTuples);
    }

    @Override
    public Integer execute() {
        if (this.con != null) {
            return this.executeImpl(this.con);
        }
        return this.sqlClient.getConnectionManager().execute(this::executeImpl);
    }

    @Override
    public Integer execute(Connection con) {
        if (con != null) {
            return this.executeImpl(con);
        }
        if (this.con != null) {
            return this.executeImpl(this.con);
        }
        return this.sqlClient.getConnectionManager().execute(this::executeImpl);
    }

    private Integer executeImpl(Connection con) {
        if (this.idTuples.isEmpty()) {
            return 0;
        }
        MutationTrigger trigger = this.createTrigger();
        MiddleTableOperator operator = this.getMiddleTypeOperator(con, trigger);
        if (this.forDelete) {
            int affectedRowCount = operator.remove(this.idTuples, trigger != null);
            if (trigger != null) {
                trigger.submit(this.sqlClient, con);
            }
            return affectedRowCount;
        }
        Set<Tuple2<Tuple2<Object, Object>, Tuple2<Object, Object>>> addingPairs = this.idTuples;
        if (this.nullOrCheckedExistence != null ? this.nullOrCheckedExistence != false : this.defaultCheckExistence) {
            addingPairs = new LinkedHashSet(addingPairs);
            HashSet<Tuple2<Object, Object>> existingPairs = new HashSet<Tuple2<Object, Object>>(this.find(con));
            addingPairs.removeAll(existingPairs);
            if (addingPairs.isEmpty()) {
                return 0;
            }
        }
        int affectedRowCount = operator.add(addingPairs);
        if (trigger != null) {
            trigger.submit(this.sqlClient, con);
        }
        return affectedRowCount;
    }

    private List<Tuple2<Object, Object>> find(Connection con) {
        MetadataStrategy strategy = this.sqlClient.getMetadataStrategy();
        MiddleTable middleTable = this.reversed ? this.associationType.getMiddleTable(strategy).getInverse() : this.associationType.getMiddleTable(strategy);
        Tuple2<Expression<?>, Expression<?>> expressionPair = this.getExpressionPair();
        SqlBuilder builder = new SqlBuilder(new AstContext(this.sqlClient));
        ((SqlBuilder)((SqlBuilder)((SqlBuilder)((SqlBuilder)builder.enter(AbstractSqlBuilder.ScopeType.SELECT)).definition(middleTable.getColumnDefinition()).separator()).definition(middleTable.getTargetColumnDefinition()).leave()).from().sql(this.associationType.getTableName(strategy))).enter(AbstractSqlBuilder.ScopeType.WHERE);
        NativePredicates.renderTuplePredicates(false, middleTable.getColumnDefinition(), middleTable.getTargetColumnDefinition(), this.idTuples, builder);
        builder.leave();
        Tuple3<String, List<Object>, List<Integer>> sqlResult = builder.build();
        return Selectors.select(this.sqlClient, con, sqlResult.get_1(), sqlResult.get_2(), sqlResult.get_3(), Arrays.asList(expressionPair.get_1(), expressionPair.get_2()), ExecutionPurpose.QUERY);
    }

    private Tuple2<Expression<?>, Expression<?>> getExpressionPair() {
        Class srcType = this.associationType.getSourceType().getIdProp().getElementClass();
        Class tgtType = this.associationType.getTargetType().getIdProp().getElementClass();
        if (this.reversed) {
            return new Tuple2(Expression.any().nullValue(tgtType), Expression.any().nullValue(srcType));
        }
        return new Tuple2(Expression.any().nullValue(srcType), Expression.any().nullValue(tgtType));
    }

    private MiddleTableOperator getMiddleTypeOperator(Connection con, MutationTrigger trigger) {
        return MiddleTableOperator.tryGet(this.sqlClient, con, this.reversed ? this.associationType.getBaseProp().getOpposite() : this.associationType.getBaseProp(), trigger);
    }

    private MutationTrigger createTrigger() {
        return this.sqlClient.getTriggerType() == TriggerType.BINLOG_ONLY ? null : new MutationTrigger();
    }
}

