/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.cache;

import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.meta.TargetLevel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface CacheTracker {
    public void addInvalidationListener(InvalidationListener var1);

    public void removeInvalidationListener(InvalidationListener var1);

    public void addReconnectListener(ReconnectListener var1);

    public void removeReconnectListener(ReconnectListener var1);

    public Firer firer();

    public Publisher publisher();

    public static class InvalidationEvent {
        private final ImmutableType type;
        private final ImmutableProp prop;
        private final Object id;

        public InvalidationEvent(ImmutableType type, Object id) {
            Class idType = type.getIdProp().getReturnClass();
            if (id == null || !idType.isAssignableFrom(id.getClass())) {
                throw new IllegalArgumentException("The id \"" + id + "\" does not match the id property \"" + type.getIdProp() + "\"");
            }
            this.type = type;
            this.prop = null;
            this.id = id;
        }

        public InvalidationEvent(ImmutableProp prop, Object id) {
            if (!prop.isAssociation(TargetLevel.ENTITY)) {
                throw new IllegalArgumentException("The prop \"" + prop + "\" is not association property");
            }
            ImmutableType type = prop.getDeclaringType();
            ImmutableProp idProp = type.getIdProp();
            if (id == null || !idProp.getReturnClass().isAssignableFrom(id.getClass())) {
                throw new IllegalArgumentException("The id \"" + id + "\" does not match the id property \"" + idProp + "\" of declaring type");
            }
            this.type = type;
            this.prop = prop;
            this.id = id;
        }

        @NotNull
        public ImmutableType getType() {
            return this.type;
        }

        @Nullable
        public ImmutableProp getProp() {
            return this.prop;
        }

        @NotNull
        public Object getId() {
            return this.id;
        }
    }

    public static interface Publisher {
        public void invalidate(InvalidationEvent var1);
    }

    public static interface Firer {
        public void invalidate(InvalidationEvent var1);

        public void reconnect();
    }

    public static interface ReconnectListener {
        public void onReconnect();
    }

    @FunctionalInterface
    public static interface InvalidationListener {
        public void onInvalidate(InvalidationEvent var1);
    }
}

