/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.mutation.save;

import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.PropId;
import org.babyfish.jimmer.runtime.ImmutableSpi;
import org.babyfish.jimmer.sql.ast.impl.mutation.save.Batch;
import org.babyfish.jimmer.sql.ast.impl.mutation.save.EntitySet;
import org.babyfish.jimmer.sql.ast.impl.mutation.save.SemNode;
import org.babyfish.jimmer.sql.ast.impl.mutation.save.Shape;
import org.babyfish.jimmer.sql.runtime.JSqlClientImplementor;
import org.jetbrains.annotations.NotNull;

class ShapedEntityMap<E>
extends SemNode<E>
implements Iterable<Batch<E>> {
    private static final ShapedEntityMap<Object> EMPTY = new ShapedEntityMap(null, null);
    private final JSqlClientImplementor sqlClient;
    private final Set<ImmutableProp> keyProps;
    private static final int CAPACITY = 8;
    private SemNode<E>[] tab;
    private int modCount;

    ShapedEntityMap(JSqlClientImplementor sqlClient, Set<ImmutableProp> keyProps) {
        super(0, null, null, null, null, null);
        this.sqlClient = sqlClient;
        this.keyProps = keyProps;
        this.before = this;
        this.after = this;
    }

    void add(E entity) {
        EntitySet<E> entities;
        SemNode<E> startNode;
        if (this == EMPTY) {
            throw new UnsupportedOperationException("The empty shaped entity map is readonly");
        }
        if (this.tab == null) {
            this.tab = new SemNode[8];
        }
        Shape key = Shape.of(this.sqlClient, (ImmutableSpi)entity);
        int h = key.hashCode();
        h ^= h >>> 16;
        int index = 7 & h;
        SemNode<E> node = startNode = this.tab[index];
        while (node != null) {
            if (node.hash == h && node.key.equals(key)) {
                node.entities.add(entity);
                ++this.modCount;
                return;
            }
            node = node.next;
        }
        PropId idPropId = key.getType().getIdProp().getId();
        if (((ImmutableSpi)entity).__isLoaded(idPropId)) {
            entities = new EntitySet<E>(new PropId[]{idPropId});
        } else {
            Set<ImmutableProp> keyProps = this.keyProps;
            PropId[] keyPropIds = new PropId[keyProps.size()];
            int i = 0;
            for (ImmutableProp keyProp : keyProps) {
                keyPropIds[i++] = keyProp.getId();
            }
            entities = new EntitySet(keyPropIds);
        }
        entities.add(entity);
        SemNode last = this.before;
        SemNode node2 = new SemNode(h, key, entities, startNode, last, this);
        last.after = node2;
        this.before = node2;
        this.tab[index] = node2;
        ++this.modCount;
    }

    boolean isEmpty() {
        return this.after == this;
    }

    @Override
    @NotNull
    public Iterator<Batch<E>> iterator() {
        if (this.after == this) {
            return Collections.emptyIterator();
        }
        return new Itr();
    }

    public String toString() {
        if (this.after == this) {
            return "{}";
        }
        StringBuilder builder = new StringBuilder("{");
        boolean addComma = false;
        SemNode n = this.after;
        while (n != this) {
            if (addComma) {
                builder.append(", ");
            } else {
                addComma = true;
            }
            builder.append(n.key).append(": ").append(n.entities);
            n = n.after;
        }
        builder.append('}');
        return builder.toString();
    }

    static <E> ShapedEntityMap<E> empty() {
        return EMPTY;
    }

    private class Itr
    implements Iterator<Batch<E>> {
        private final int modCount;
        private SemNode<E> current;

        public Itr() {
            this.modCount = ShapedEntityMap.this.modCount;
            this.current = ShapedEntityMap.this.after;
        }

        @Override
        public boolean hasNext() {
            if (ShapedEntityMap.this.modCount != this.modCount) {
                throw new ConcurrentModificationException();
            }
            return this.current != ShapedEntityMap.this;
        }

        @Override
        public Batch<E> next() {
            if (ShapedEntityMap.this.modCount != this.modCount) {
                throw new ConcurrentModificationException();
            }
            if (this.current == ShapedEntityMap.this) {
                throw new NoSuchElementException();
            }
            SemNode batch = this.current;
            this.current = this.current.after;
            return batch;
        }
    }
}

