/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.mutation.save;

import java.sql.Connection;
import java.sql.ResultSet;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.runtime.ImmutableSpi;
import org.babyfish.jimmer.sql.JoinSql;
import org.babyfish.jimmer.sql.OneToMany;
import org.babyfish.jimmer.sql.ast.impl.mutation.SaveOptions;
import org.babyfish.jimmer.sql.ast.impl.mutation.save.MutationTrigger;
import org.babyfish.jimmer.sql.ast.mutation.AffectedTable;
import org.babyfish.jimmer.sql.ast.mutation.AssociatedSaveMode;
import org.babyfish.jimmer.sql.ast.mutation.SaveMode;
import org.babyfish.jimmer.sql.meta.IdGenerator;
import org.babyfish.jimmer.sql.meta.UserIdGenerator;
import org.babyfish.jimmer.sql.meta.impl.IdentityIdGenerator;
import org.babyfish.jimmer.sql.meta.impl.SequenceIdGenerator;
import org.babyfish.jimmer.sql.runtime.ExecutionPurpose;
import org.babyfish.jimmer.sql.runtime.Executor;
import org.babyfish.jimmer.sql.runtime.JSqlClientImplementor;
import org.babyfish.jimmer.sql.runtime.MutationPath;
import org.babyfish.jimmer.sql.runtime.SaveException;

class SaveContext {
    final SaveOptions options;
    final Connection con;
    final MutationTrigger trigger;
    final boolean triggerSubmitImmediately;
    final Map<AffectedTable, Integer> affectedRowCountMap;
    final MutationPath path;
    final ImmutableProp backReferenceProp;
    final boolean backReferenceFrozen;

    SaveContext(SaveOptions options, Connection con, ImmutableType type) {
        this(options, con, type, true, new LinkedHashMap<AffectedTable, Integer>());
    }

    SaveContext(SaveOptions options, Connection con, ImmutableType type, boolean triggerSubmitImmediately, Map<AffectedTable, Integer> affectedRowCountMap) {
        this.options = options;
        this.con = con;
        this.trigger = options.getTriggers() != null ? new MutationTrigger() : null;
        this.triggerSubmitImmediately = triggerSubmitImmediately && this.trigger != null;
        this.affectedRowCountMap = affectedRowCountMap;
        this.path = MutationPath.root(type);
        this.backReferenceProp = null;
        this.backReferenceFrozen = false;
    }

    private SaveContext(SaveContext base, ImmutableProp prop) {
        this.options = base.options.toMode(base.options.getAssociatedMode(prop) == AssociatedSaveMode.APPEND ? SaveMode.INSERT_ONLY : SaveMode.UPSERT);
        this.con = base.con;
        this.trigger = base.trigger;
        this.triggerSubmitImmediately = this.trigger != null;
        this.affectedRowCountMap = base.affectedRowCountMap;
        this.path = base.path.to(prop);
        if (prop.getAssociationAnnotation().annotationType() == OneToMany.class) {
            this.backReferenceProp = prop.getMappedBy();
            this.backReferenceFrozen = !((OneToMany)prop.getAssociationAnnotation()).isTargetTransferable();
        } else {
            this.backReferenceProp = prop.getMappedBy();
            this.backReferenceFrozen = false;
        }
    }

    public Object allocateId() {
        IdGenerator idGenerator = this.options.getSqlClient().getIdGenerator(this.path.getType().getJavaClass());
        if (idGenerator == null) {
            throw new SaveException.NoIdGenerator(this.path, "Cannot save \"" + this.path.getType() + "\" without id because id generator is not specified");
        }
        JSqlClientImplementor sqlClient = this.options.getSqlClient();
        if (idGenerator instanceof SequenceIdGenerator) {
            String sql = sqlClient.getDialect().getSelectIdFromSequenceSql(((SequenceIdGenerator)idGenerator).getSequenceName());
            return sqlClient.getExecutor().execute(new Executor.Args<Object>(sqlClient, this.con, sql, Collections.emptyList(), sqlClient.getSqlFormatter().isPretty() ? Collections.emptyList() : null, ExecutionPurpose.MUTATE, null, stmt -> {
                try (ResultSet rs = stmt.executeQuery();){
                    rs.next();
                    Object object = rs.getObject(1);
                    return object;
                }
            }));
        }
        if (idGenerator instanceof UserIdGenerator) {
            return ((UserIdGenerator)idGenerator).generate(this.path.getType().getJavaClass());
        }
        if (idGenerator instanceof IdentityIdGenerator) {
            return null;
        }
        throw new SaveException.IllegalIdGenerator(this.path, "Illegal id generator type: \"" + idGenerator.getClass().getName() + "\", id generator must be sub type of \"" + SequenceIdGenerator.class.getName() + "\", \"" + IdentityIdGenerator.class.getName() + "\" or \"" + UserIdGenerator.class.getName() + "\"");
    }

    public SaveContext to(ImmutableProp prop) {
        return new SaveContext(this, prop);
    }

    void throwNoVersionError() {
        throw new SaveException.OptimisticLockError(this.path, "The version property \"" + this.path.getType().getVersionProp() + "\" must be specified");
    }

    void throwOptimisticLockError(ImmutableSpi row) {
        throw new SaveException.OptimisticLockError(this.path, "Cannot update the entity whose type is \"" + this.path.getType() + "\" and id is \"" + row.__get(this.path.getType().getIdProp().getId()) + "\" because of optimistic lock error");
    }

    void throwReadonlyMiddleTable() {
        throw new SaveException.ReadonlyMiddleTable(this.path, "The property \"" + this.path.getProp() + "\" which is based on readonly middle table cannot be saved");
    }

    void throwReversedRemoteAssociation() {
        throw new SaveException.ReversedRemoteAssociation(this.path, "The property \"" + this.path.getProp() + "\" which is reversed(with `mappedBy`) remote(across different microservices) association cannot be supported by save command");
    }

    void throwUnstructuredAssociation() {
        throw new SaveException.UnstructuredAssociation(this.path, "The property \"" + this.path.getProp() + "\" which is unstructured association(decorated by @" + JoinSql.class.getName() + ") cannot be supported by save command");
    }

    void throwIllegalTargetIds(Collection<Object> illegalTargetIds) {
        if (!illegalTargetIds.isEmpty()) {
            throw new SaveException.IllegalTargetId(this.path, "Illegal ids: " + illegalTargetIds);
        }
    }
}

