/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.dialect;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.util.UUID;
import org.babyfish.jimmer.sql.dialect.Dialect;
import org.babyfish.jimmer.sql.dialect.PaginationContext;

public class DefaultDialect
implements Dialect {
    public static final DefaultDialect INSTANCE = new DefaultDialect();

    protected DefaultDialect() {
    }

    @Override
    public void paginate(PaginationContext ctx) {
        ctx.origin().space().sql("limit ").variable(ctx.getLimit());
        if (ctx.getOffset() > 0L) {
            ctx.sql(" offset ").variable(ctx.getOffset());
        }
    }

    public String sqlType(Class<?> elementType) {
        if (elementType == String.class) {
            return "varchar";
        }
        if (elementType == UUID.class) {
            return "varchar";
        }
        if (elementType == Boolean.TYPE) {
            return "boolean";
        }
        if (elementType == Byte.TYPE) {
            return "tinyint";
        }
        if (elementType == Short.TYPE) {
            return "smallint";
        }
        if (elementType == Integer.TYPE) {
            return "int";
        }
        if (elementType == Long.TYPE) {
            return "bigint";
        }
        if (elementType == Float.TYPE) {
            return "float";
        }
        if (elementType == Double.TYPE) {
            return "double";
        }
        if (elementType == BigDecimal.class) {
            return "decimal";
        }
        if (elementType == Date.class || elementType == LocalDate.class) {
            return "date";
        }
        if (elementType == Time.class || elementType == LocalTime.class) {
            return "time";
        }
        if (elementType == OffsetTime.class) {
            return "time";
        }
        if (elementType == java.util.Date.class || elementType == Timestamp.class) {
            return "timestamp";
        }
        if (elementType == LocalDateTime.class) {
            return "datetime";
        }
        if (elementType == OffsetDateTime.class || elementType == ZonedDateTime.class) {
            return "datetime";
        }
        return null;
    }

    public String toString() {
        return this.getClass().getName();
    }
}

