/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.cache;

import org.babyfish.jimmer.impl.util.ClassCache;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.meta.TargetLevel;
import org.babyfish.jimmer.sql.fetcher.Fetcher;
import org.babyfish.jimmer.sql.fetcher.IdOnlyFetchType;
import org.babyfish.jimmer.sql.fetcher.impl.FetcherImpl;

class ObjectCacheFetchers {
    private static final ClassCache<Fetcher<?>> CACHE = new ClassCache(ObjectCacheFetchers::create, false);

    ObjectCacheFetchers() {
    }

    static <V> Fetcher<V> of(Class<V> type) {
        return (Fetcher)CACHE.get(type);
    }

    private static Fetcher<?> create(Class<?> type) {
        ImmutableType immutableType = ImmutableType.get(type);
        Fetcher<Object> fetcher = new FetcherImpl(type);
        for (ImmutableProp prop : immutableType.getObjectCacheProps().values()) {
            ImmutableProp fetchedProp;
            ImmutableProp idViewProp = prop.getIdViewProp();
            ImmutableProp immutableProp = fetchedProp = idViewProp != null ? idViewProp : prop;
            if (prop.isReference(TargetLevel.PERSISTENT)) {
                fetcher = fetcher.add(fetchedProp.getName(), IdOnlyFetchType.RAW);
                continue;
            }
            fetcher = fetcher.add(fetchedProp.getName());
        }
        return fetcher;
    }
}

