/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.value;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.babyfish.jimmer.lang.Ref;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.TargetLevel;
import org.babyfish.jimmer.runtime.ImmutableSpi;
import org.babyfish.jimmer.sql.ast.impl.table.TableImplementor;
import org.babyfish.jimmer.sql.ast.impl.value.EmbeddedValueGetter;
import org.babyfish.jimmer.sql.ast.impl.value.GetterMetadata;
import org.babyfish.jimmer.sql.ast.impl.value.SimpleValueGetter;
import org.babyfish.jimmer.sql.ast.impl.value.TransientValueGetter;
import org.babyfish.jimmer.sql.ast.impl.value.ValueGetter;
import org.babyfish.jimmer.sql.ast.table.Table;
import org.babyfish.jimmer.sql.ast.table.spi.TableProxy;
import org.babyfish.jimmer.sql.meta.ColumnDefinition;
import org.babyfish.jimmer.sql.meta.EmbeddedColumns;
import org.babyfish.jimmer.sql.meta.MetadataStrategy;
import org.babyfish.jimmer.sql.meta.MiddleTable;
import org.babyfish.jimmer.sql.meta.MultipleJoinColumns;
import org.babyfish.jimmer.sql.meta.SingleColumn;
import org.babyfish.jimmer.sql.meta.Storage;
import org.babyfish.jimmer.sql.runtime.JSqlClientImplementor;
import org.babyfish.jimmer.sql.runtime.ScalarProvider;

abstract class AbstractValueGetter
implements ValueGetter,
GetterMetadata {
    private final ScalarProvider<Object, Object> scalarProvider;
    private final String sqlTypeName;

    AbstractValueGetter(ScalarProvider<Object, Object> scalarProvider, String sqlTypeName) {
        this.scalarProvider = scalarProvider;
        this.sqlTypeName = sqlTypeName;
    }

    @Override
    public final Object get(Object value) {
        Object scalarValue = this.getRaw(value);
        if (scalarValue == null || this.scalarProvider == null) {
            return scalarValue;
        }
        try {
            return this.scalarProvider.toSql(scalarValue);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Cannot convert the value \"" + scalarValue + "\" to sql value by the scalar provider \"" + this.scalarProvider + "\"");
        }
    }

    protected abstract Object getRaw(Object var1);

    static List<ValueGetter> createValueGetters(JSqlClientImplementor sqlClient, ImmutableProp prop, Object value) {
        return AbstractValueGetter.createValueGetters(sqlClient, null, false, Collections.singletonList(prop), value);
    }

    static List<ValueGetter> createValueGetters(JSqlClientImplementor sqlClient, Table<?> table, boolean rawId, List<ImmutableProp> props, Object value) {
        boolean inverse = false;
        if (table != null) {
            inverse = table instanceof TableProxy ? ((TableProxy)table).__isInverse() : ((TableImplementor)table).isInverse();
        }
        MetadataStrategy strategy = sqlClient.getMetadataStrategy();
        ColumnDefinition definition = null;
        ImmutableProp originalRootProp = props.get(0);
        if (originalRootProp.isColumnDefinition()) {
            definition = (ColumnDefinition)originalRootProp.getStorage(strategy);
        } else if (props.size() > 1) {
            ImmutableProp mappedBy = originalRootProp.getMappedBy();
            if (mappedBy != null) {
                Storage storage = mappedBy.getStorage(strategy);
                if (storage instanceof MiddleTable) {
                    definition = inverse ? ((MiddleTable)storage).getTargetColumnDefinition() : ((MiddleTable)storage).getColumnDefinition();
                } else if (inverse) {
                    definition = (ColumnDefinition)storage;
                }
            } else if (originalRootProp.isMiddleTableDefinition()) {
                MiddleTable middleTable = (MiddleTable)originalRootProp.getStorage(strategy);
                definition = inverse ? middleTable.getColumnDefinition() : middleTable.getTargetColumnDefinition();
            }
            if (definition != null) {
                props = props.subList(1, props.size());
            }
        }
        if (definition == null) {
            if (props.size() > 1 && props.get(1).isColumnDefinition()) {
                definition = (ColumnDefinition)props.get(1).getStorage(strategy);
                props = props.subList(1, props.size());
                rawId = false;
            } else {
                return Collections.singletonList(new TransientValueGetter(props));
            }
        }
        ImmutableProp rootProp = props.get(0);
        List<Object> restProps = props.size() == 1 ? Collections.emptyList() : (rootProp.isAssociation(TargetLevel.ENTITY) ? props.subList(2, props.size()) : props.subList(1, props.size()));
        if (definition instanceof MultipleJoinColumns) {
            MultipleJoinColumns joinColumns = (MultipleJoinColumns)definition;
            EmbeddedColumns targetIdColumns = inverse ? (EmbeddedColumns)originalRootProp.getDeclaringType().getIdProp().getStorage(strategy) : (EmbeddedColumns)originalRootProp.getTargetType().getIdProp().getStorage(strategy);
            int size = joinColumns.size();
            ArrayList<ValueGetter> getters = new ArrayList<ValueGetter>();
            for (int i = 0; i < size; ++i) {
                List<ImmutableProp> deeperProps;
                String columnName = joinColumns.name(i);
                String referencedColumnName = joinColumns.referencedName(i);
                List embeddedProps = targetIdColumns.path(referencedColumnName);
                if (!AbstractValueGetter.startsWith(embeddedProps, restProps) || !AbstractValueGetter.isLoaded(value, deeperProps = embeddedProps.subList(restProps.size(), embeddedProps.size()))) continue;
                ImmutableProp deepestProp = (ImmutableProp)embeddedProps.get(embeddedProps.size() - 1);
                getters.add(new EmbeddedValueGetter(table, rawId, columnName, deeperProps, sqlClient.getScalarProvider(deepestProp), ((SingleColumn)deepestProp.getStorage(strategy)).getSqlType()));
            }
            return getters;
        }
        if (definition instanceof EmbeddedColumns) {
            EmbeddedColumns embeddedColumns = (EmbeddedColumns)definition;
            int size = embeddedColumns.size();
            ArrayList<ValueGetter> getters = new ArrayList<ValueGetter>();
            for (int i = 0; i < size; ++i) {
                List embeddedProps = embeddedColumns.path(i);
                if (!AbstractValueGetter.startsWith(embeddedProps, restProps)) continue;
                String columnName = embeddedColumns.name(i);
                List<ImmutableProp> deeperProps = embeddedProps.subList(restProps.size(), embeddedProps.size());
                if (!AbstractValueGetter.isLoaded(value, deeperProps)) continue;
                ImmutableProp deepestProp = (ImmutableProp)embeddedProps.get(embeddedProps.size() - 1);
                getters.add(new EmbeddedValueGetter(table, rawId, columnName, deeperProps, sqlClient.getScalarProvider(deepestProp), ((SingleColumn)deepestProp.getStorage(strategy)).getSqlType()));
            }
            return getters;
        }
        ImmutableProp finalProp = rootProp.isReference(TargetLevel.ENTITY) ? rootProp.getTargetType().getIdProp() : rootProp;
        return Collections.singletonList(new SimpleValueGetter(table, rawId, definition.name(0), rootProp, sqlClient.getScalarProvider(finalProp), ((SingleColumn)finalProp.getStorage(strategy)).getSqlType()));
    }

    private static boolean startsWith(List<ImmutableProp> props, List<ImmutableProp> prefixProps) {
        int size = prefixProps.size();
        if (props.size() < size) {
            return false;
        }
        for (int i = 0; i < size; ++i) {
            if (prefixProps.get(i) == props.get(i)) continue;
            return false;
        }
        return true;
    }

    private static boolean isLoaded(Object value, List<ImmutableProp> props) {
        for (ImmutableProp prop : props) {
            if (value == null) {
                return true;
            }
            ImmutableSpi spi = (ImmutableSpi)value;
            if (!spi.__isLoaded(prop.getId())) {
                return false;
            }
            value = spi.__get(prop.getId());
        }
        return true;
    }

    @Override
    public final GetterMetadata metadata() {
        return this;
    }

    @Override
    public final boolean isJson() {
        return this.scalarProvider != null && this.scalarProvider.isJsonScalar();
    }

    @Override
    public boolean hasDefaultValue() {
        ImmutableProp prop = this.getValueProp();
        return prop != null && prop.getDefaultValueRef() != null;
    }

    @Override
    public final Object getDefaultValue() {
        ImmutableProp vp = this.getValueProp();
        if (vp == null) {
            return null;
        }
        Ref ref = vp.getDefaultValueRef();
        if (ref == null) {
            return null;
        }
        return ref.getValue();
    }

    @Override
    public Class<?> getSqlType() {
        if (this.scalarProvider != null) {
            return this.scalarProvider.getSqlType();
        }
        return this.getValueProp().getReturnClass();
    }

    @Override
    public String getSqlTypeName() {
        return this.sqlTypeName;
    }
}

