/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.mutation.save;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.PropId;
import org.babyfish.jimmer.runtime.DraftSpi;
import org.babyfish.jimmer.runtime.ImmutableSpi;
import org.babyfish.jimmer.sql.ast.Predicate;
import org.babyfish.jimmer.sql.ast.impl.Ast;
import org.babyfish.jimmer.sql.ast.impl.OptimisticLockValueFactoryFactories;
import org.babyfish.jimmer.sql.ast.impl.mutation.save.Batch;
import org.babyfish.jimmer.sql.ast.impl.mutation.save.Keys;
import org.babyfish.jimmer.sql.ast.impl.mutation.save.MutationTrigger;
import org.babyfish.jimmer.sql.ast.impl.mutation.save.SaveContext;
import org.babyfish.jimmer.sql.ast.impl.mutation.save.Shape;
import org.babyfish.jimmer.sql.ast.impl.query.FilterLevel;
import org.babyfish.jimmer.sql.ast.impl.query.MutableRootQueryImpl;
import org.babyfish.jimmer.sql.ast.impl.render.AbstractSqlBuilder;
import org.babyfish.jimmer.sql.ast.impl.render.BatchSqlBuilder;
import org.babyfish.jimmer.sql.ast.impl.table.TableImplementor;
import org.babyfish.jimmer.sql.ast.impl.value.PropertyGetter;
import org.babyfish.jimmer.sql.ast.mutation.UserOptimisticLock;
import org.babyfish.jimmer.sql.ast.table.spi.TableProxy;
import org.babyfish.jimmer.sql.ast.table.spi.UntypedJoinDisabledTableProxy;
import org.babyfish.jimmer.sql.ast.tuple.Tuple2;
import org.babyfish.jimmer.sql.dialect.Dialect;
import org.babyfish.jimmer.sql.meta.IdGenerator;
import org.babyfish.jimmer.sql.meta.MetadataStrategy;
import org.babyfish.jimmer.sql.meta.SingleColumn;
import org.babyfish.jimmer.sql.meta.impl.IdentityIdGenerator;
import org.babyfish.jimmer.sql.meta.impl.SequenceIdGenerator;
import org.babyfish.jimmer.sql.runtime.ExecutionPurpose;
import org.babyfish.jimmer.sql.runtime.Executor;
import org.babyfish.jimmer.sql.runtime.JSqlClientImplementor;
import org.babyfish.jimmer.sql.runtime.SaveException;

class Operator {
    private static final String GENERAL_OPTIMISTIC_DISABLED_JOIN_REASON = "Joining is disabled in general optimistic lock";
    final SaveContext ctx;

    Operator(SaveContext ctx) {
        this.ctx = ctx;
    }

    public int insert(Batch<DraftSpi> batch) {
        if (batch.entities().isEmpty()) {
            return 0;
        }
        JSqlClientImplementor sqlClient = this.ctx.options.getSqlClient();
        ArrayList<PropertyGetter> defaultGetters = new ArrayList<PropertyGetter>();
        for (PropertyGetter getter : Shape.fullOf(sqlClient, batch.shape().getType().getJavaClass()).getGetters()) {
            if (!getter.metadata().hasDefaultValue() || batch.shape().contains(getter)) continue;
            defaultGetters.add(getter);
        }
        SequenceIdGenerator sequenceIdGenerator = null;
        if (batch.shape().getIdGetters().isEmpty()) {
            IdGenerator idGenerator = sqlClient.getIdGenerator(this.ctx.path.getType().getJavaClass());
            if (idGenerator instanceof SequenceIdGenerator) {
                sequenceIdGenerator = (SequenceIdGenerator)idGenerator;
            } else if (!(idGenerator instanceof IdentityIdGenerator)) {
                throw new SaveException.IllegalIdGenerator(this.ctx.path, "In order to insert object without id, the id generator must be identity or sequence");
            }
        }
        MetadataStrategy strategy = sqlClient.getMetadataStrategy();
        BatchSqlBuilder builder = new BatchSqlBuilder(sqlClient);
        ((BatchSqlBuilder)((BatchSqlBuilder)builder.sql("insert into ")).sql(this.ctx.path.getType().getTableName(strategy))).enter(AbstractSqlBuilder.ScopeType.TUPLE);
        if (sequenceIdGenerator != null) {
            ((BatchSqlBuilder)builder.separator()).sql(((SingleColumn)this.ctx.path.getType().getIdProp().getStorage(strategy)).getName());
        }
        for (PropertyGetter getter : batch.shape().getGetters()) {
            ((BatchSqlBuilder)builder.separator()).sql(getter);
        }
        for (PropertyGetter defaultGetter : defaultGetters) {
            ((BatchSqlBuilder)builder.separator()).sql(defaultGetter);
        }
        ((BatchSqlBuilder)((BatchSqlBuilder)builder.leave()).sql(" values")).enter(AbstractSqlBuilder.ScopeType.TUPLE);
        if (sequenceIdGenerator != null) {
            ((BatchSqlBuilder)((BatchSqlBuilder)((BatchSqlBuilder)builder.separator()).sql("(")).sql(sqlClient.getDialect().getSelectIdFromSequenceSql(sequenceIdGenerator.getSequenceName()))).sql(")");
        }
        for (PropertyGetter getter : batch.shape().getGetters()) {
            ((BatchSqlBuilder)builder.separator()).variable(getter);
        }
        for (PropertyGetter defaultGetter : defaultGetters) {
            ((BatchSqlBuilder)builder.separator()).defaultVariable(defaultGetter);
        }
        builder.leave();
        MutationTrigger trigger = this.ctx.trigger;
        if (trigger != null) {
            for (DraftSpi draft : batch.entities()) {
                trigger.modifyEntityTable(null, draft);
            }
        }
        return this.execute(builder, batch, false);
    }

    public int update(Map<Object, ImmutableSpi> originalIdObjMap, Map<Object, ImmutableSpi> originalKeyObjMap, Batch<DraftSpi> batch) {
        BatchSqlBuilder builder;
        block13: {
            if (batch.shape().getIdGetters().isEmpty()) {
                throw new IllegalArgumentException("Cannot update batch whose shape does not have id");
            }
            if (batch.entities().isEmpty()) {
                return 0;
            }
            JSqlClientImplementor sqlClient = this.ctx.options.getSqlClient();
            MetadataStrategy strategy = sqlClient.getMetadataStrategy();
            Predicate userOptimisticLockPredicate = this.userLockOptimisticPredicate();
            PropertyGetter versionGetter = batch.shape().getVersionGetter();
            if (userOptimisticLockPredicate == null && versionGetter == null && this.ctx.path.getType().getVersionProp() != null) {
                this.ctx.throwNoVersionError();
            }
            builder = new BatchSqlBuilder(sqlClient);
            ((BatchSqlBuilder)((BatchSqlBuilder)builder.sql("update ")).sql(this.ctx.path.getType().getTableName(strategy))).enter(AbstractSqlBuilder.ScopeType.SET);
            for (PropertyGetter getter : batch.shape().getGetters()) {
                if (getter.prop().isId() || getter.prop().isVersion() && userOptimisticLockPredicate == null) continue;
                ((BatchSqlBuilder)((BatchSqlBuilder)((BatchSqlBuilder)builder.separator()).sql(getter)).sql(" = ")).variable(getter);
            }
            if (userOptimisticLockPredicate == null && versionGetter != null) {
                ((BatchSqlBuilder)((BatchSqlBuilder)((BatchSqlBuilder)((BatchSqlBuilder)builder.separator()).sql(versionGetter)).sql(" = ")).sql(versionGetter)).sql(" + 1");
            }
            ((BatchSqlBuilder)builder.leave()).enter(AbstractSqlBuilder.ScopeType.WHERE);
            for (PropertyGetter getter : batch.shape().getIdGetters()) {
                ((BatchSqlBuilder)((BatchSqlBuilder)((BatchSqlBuilder)builder.separator()).sql(getter)).sql(" = ")).variable(getter);
            }
            if (userOptimisticLockPredicate != null) {
                builder.separator();
                ((Ast)((Object)userOptimisticLockPredicate)).renderTo(builder);
            } else if (versionGetter != null) {
                ((BatchSqlBuilder)((BatchSqlBuilder)((BatchSqlBuilder)builder.separator()).sql(versionGetter)).sql(" = ")).variable(versionGetter);
            }
            builder.leave();
            MutationTrigger trigger = this.ctx.trigger;
            if (trigger == null) break block13;
            if (batch.shape().getIdGetters().isEmpty()) {
                Set<ImmutableProp> keyProps = this.ctx.options.getKeyProps(this.ctx.path.getType());
                for (DraftSpi draft : batch.entities()) {
                    trigger.modifyEntityTable(originalIdObjMap.get(Keys.keyOf((ImmutableSpi)draft, keyProps)), draft);
                }
            } else {
                PropId idPropId = this.ctx.path.getType().getIdProp().getId();
                for (DraftSpi draft : batch.entities()) {
                    trigger.modifyEntityTable(originalKeyObjMap.get(draft.__get(idPropId)), draft);
                }
            }
        }
        return this.execute(builder, batch, true);
    }

    public int upsert(Batch<DraftSpi> batch) {
        if (batch.entities().isEmpty()) {
            return 0;
        }
        if (this.ctx.trigger != null) {
            throw new AssertionError((Object)"Internal bug: Upsert cannot be called if the trigger is not null");
        }
        JSqlClientImplementor sqlClient = this.ctx.options.getSqlClient();
        Shape fullShape = Shape.fullOf(sqlClient, batch.shape().getType().getJavaClass());
        ArrayList<PropertyGetter> defaultGetters = new ArrayList<PropertyGetter>();
        for (PropertyGetter getter : fullShape.getGetters()) {
            if (!getter.metadata().hasDefaultValue() || batch.shape().contains(getter)) continue;
            defaultGetters.add(getter);
        }
        SequenceIdGenerator sequenceIdGenerator = null;
        if (batch.shape().getIdGetters().isEmpty()) {
            IdGenerator idGenerator = sqlClient.getIdGenerator(this.ctx.path.getType().getJavaClass());
            if (idGenerator instanceof SequenceIdGenerator) {
                sequenceIdGenerator = (SequenceIdGenerator)idGenerator;
            } else if (!(idGenerator instanceof IdentityIdGenerator)) {
                throw new SaveException.IllegalIdGenerator(this.ctx.path, "In order to insert object without id, the id generator must be identity or sequence");
            }
        }
        ArrayList<PropertyGetter> insertedGetters = new ArrayList<PropertyGetter>();
        if (sequenceIdGenerator != null) {
            insertedGetters.addAll(batch.shape().getIdGetters());
        }
        insertedGetters.addAll(batch.shape().getGetters());
        insertedGetters.addAll(defaultGetters);
        ArrayList<PropertyGetter> conflictGetters = new ArrayList<PropertyGetter>();
        if (!batch.shape().getIdGetters().isEmpty()) {
            conflictGetters.addAll(batch.shape().getIdGetters());
        } else {
            Set<ImmutableProp> keyProps = this.ctx.options.getKeyProps(this.ctx.path.getType());
            for (PropertyGetter getter : fullShape.getGetters()) {
                if (!keyProps.contains(getter.prop())) continue;
                conflictGetters.add(getter);
            }
        }
        ArrayList<PropertyGetter> updatedGetters = new ArrayList<PropertyGetter>();
        for (PropertyGetter getter : batch.shape().getGetters()) {
            if (conflictGetters.contains(getter)) continue;
            updatedGetters.add(getter);
        }
        for (PropertyGetter defaultGetter : defaultGetters) {
            if (conflictGetters.contains(defaultGetter)) continue;
            updatedGetters.add(defaultGetter);
        }
        Predicate userOptimisticLockPredicate = this.userLockOptimisticPredicate();
        PropertyGetter versionGetter = batch.shape().getVersionGetter();
        if (userOptimisticLockPredicate == null && versionGetter == null && this.ctx.path.getType().getVersionProp() != null) {
            this.ctx.throwNoVersionError();
        }
        BatchSqlBuilder builder = new BatchSqlBuilder(sqlClient);
        UpsertContextImpl updateContext = new UpsertContextImpl(builder, sequenceIdGenerator, insertedGetters, conflictGetters, updatedGetters, userOptimisticLockPredicate, versionGetter);
        sqlClient.getDialect().upsert(updateContext);
        return this.execute(builder, batch, true);
    }

    private Predicate userLockOptimisticPredicate() {
        UserOptimisticLock<?, ?> userOptimisticLock = this.ctx.options.getUserOptimisticLock(this.ctx.path.getType());
        if (userOptimisticLock == null) {
            return null;
        }
        MutableRootQueryImpl fakeQuery = new MutableRootQueryImpl(this.ctx.options.getSqlClient(), this.ctx.path.getType(), ExecutionPurpose.MUTATE, FilterLevel.DEFAULT);
        Object table = fakeQuery.getTable();
        table = table instanceof TableImplementor ? new UntypedJoinDisabledTableProxy((TableImplementor)table, GENERAL_OPTIMISTIC_DISABLED_JOIN_REASON) : ((TableProxy)table).__disableJoin(GENERAL_OPTIMISTIC_DISABLED_JOIN_REASON);
        return userOptimisticLock.predicate(table, OptimisticLockValueFactoryFactories.of());
    }

    private int execute(BatchSqlBuilder builder, Batch<DraftSpi> batch, boolean updatable) {
        JSqlClientImplementor sqlClient = this.ctx.options.getSqlClient();
        PropertyGetter versionGetter = batch.shape().getVersionGetter();
        Tuple2<String, BatchSqlBuilder.VariableMapper> tuple = builder.build();
        try (Executor.BatchContext batchContext = sqlClient.getExecutor().executeBatch(sqlClient, this.ctx.con, tuple.get_1(), batch.shape().getIdGetters().isEmpty() ? this.ctx.path.getType().getIdProp() : null);){
            BatchSqlBuilder.VariableMapper mapper = tuple.get_2();
            for (DraftSpi draft : batch.entities()) {
                batchContext.add(mapper.variables(draft));
            }
            int[] rowCounts = batchContext.execute();
            if (batch.shape().getIdGetters().isEmpty()) {
                Object[] generatedIds = batchContext.generatedIds();
                if (generatedIds.length != batch.entities().size()) {
                    throw new IllegalStateException("The inserted row count is " + batch.entities().size() + ", but the count of generated ids is " + generatedIds.length);
                }
                PropId idPropId = this.ctx.path.getType().getIdProp().getId();
                int index = 0;
                for (DraftSpi draft : batch.entities()) {
                    draft.__set(idPropId, generatedIds[index++]);
                }
            }
            if (updatable && versionGetter != null) {
                PropId versionPropId = versionGetter.prop().getId();
                Iterator<DraftSpi> itr = batch.entities().iterator();
                for (int rowCount : rowCounts) {
                    DraftSpi draft = itr.next();
                    if (rowCount == 0) {
                        this.ctx.throwOptimisticLockError((ImmutableSpi)draft);
                    }
                    Integer version = (Integer)draft.__get(versionPropId);
                    draft.__set(versionPropId, (Object)(version + 1));
                }
            }
            int sumRowCount = 0;
            for (int rowCount : rowCounts) {
                if (rowCount == 0) continue;
                ++sumRowCount;
            }
            int n = sumRowCount;
            return n;
        }
    }

    private class UpsertContextImpl
    implements Dialect.UpsertContext {
        private final BatchSqlBuilder builder;
        private final SequenceIdGenerator sequenceIdGenerator;
        private final List<PropertyGetter> insertedGetters;
        private final List<PropertyGetter> conflictGetters;
        private final List<PropertyGetter> updatedGetters;
        private final Predicate userOptimisticLockPredicate;
        private final PropertyGetter versionGetter;

        private UpsertContextImpl(BatchSqlBuilder builder, SequenceIdGenerator sequenceIdGenerator, List<PropertyGetter> insertedGetters, List<PropertyGetter> conflictGetters, List<PropertyGetter> updatedGetters, Predicate userOptimisticLockPredicate, PropertyGetter versionGetter) {
            this.builder = builder;
            this.sequenceIdGenerator = sequenceIdGenerator;
            this.insertedGetters = insertedGetters;
            this.conflictGetters = conflictGetters;
            this.updatedGetters = updatedGetters;
            this.userOptimisticLockPredicate = userOptimisticLockPredicate;
            this.versionGetter = versionGetter;
        }

        @Override
        public boolean hasUpdatedColumns() {
            return !this.updatedGetters.isEmpty();
        }

        @Override
        public boolean hasOptimisticLock() {
            return this.userOptimisticLockPredicate != null || this.versionGetter != null;
        }

        @Override
        public Dialect.UpsertContext sql(String sql) {
            this.builder.sql(sql);
            return this;
        }

        @Override
        public Dialect.UpsertContext appendTableName() {
            this.builder.sql(Operator.this.ctx.path.getType().getTableName(Operator.this.ctx.options.getSqlClient().getMetadataStrategy()));
            return this;
        }

        @Override
        public Dialect.UpsertContext appendInsertedColumns() {
            MetadataStrategy strategy = Operator.this.ctx.options.getSqlClient().getMetadataStrategy();
            this.builder.enter(AbstractSqlBuilder.ScopeType.COMMA);
            if (this.sequenceIdGenerator != null) {
                ((BatchSqlBuilder)((BatchSqlBuilder)((BatchSqlBuilder)this.builder.separator()).sql("(")).sql(this.builder.sqlClient().getDialect().getSelectIdFromSequenceSql(this.sequenceIdGenerator.getSequenceName()))).sql(")");
            }
            for (PropertyGetter getter : this.insertedGetters) {
                ((BatchSqlBuilder)this.builder.separator()).sql(getter);
            }
            this.builder.leave();
            return this;
        }

        @Override
        public Dialect.UpsertContext appendConflictColumns() {
            MetadataStrategy strategy = Operator.this.ctx.options.getSqlClient().getMetadataStrategy();
            this.builder.enter(AbstractSqlBuilder.ScopeType.COMMA);
            for (PropertyGetter getter : this.conflictGetters) {
                ((BatchSqlBuilder)this.builder.separator()).sql(getter);
            }
            this.builder.leave();
            return this;
        }

        @Override
        public Dialect.UpsertContext appendInsertingValues() {
            this.builder.enter(AbstractSqlBuilder.ScopeType.COMMA);
            for (PropertyGetter getter : this.insertedGetters) {
                ((BatchSqlBuilder)this.builder.separator()).variable(getter);
            }
            this.builder.leave();
            return this;
        }

        @Override
        public Dialect.UpsertContext appendUpdatingAssignments(String prefix, String suffix) {
            this.builder.enter(AbstractSqlBuilder.ScopeType.COMMA);
            for (PropertyGetter getter : this.updatedGetters) {
                ((BatchSqlBuilder)((BatchSqlBuilder)this.builder.separator()).sql(getter)).sql(" = ");
                if (getter.metadata().getValueProp().isVersion() && Operator.this.ctx.options.getUserOptimisticLock(Operator.this.ctx.path.getType()) == null) {
                    ((BatchSqlBuilder)((BatchSqlBuilder)this.builder.sql(prefix)).sql(getter)).sql(" + 1");
                    continue;
                }
                ((BatchSqlBuilder)((BatchSqlBuilder)this.builder.sql(prefix)).sql(getter)).sql(suffix);
            }
            this.builder.leave();
            return this;
        }

        @Override
        public Dialect.UpsertContext appendOptimisticLockCondition() {
            if (this.userOptimisticLockPredicate != null) {
                ((Ast)((Object)this.userOptimisticLockPredicate)).renderTo(this.builder);
            }
            if (this.versionGetter != null) {
                ((BatchSqlBuilder)((BatchSqlBuilder)this.builder.sql(this.versionGetter)).sql(" = ")).variable(this.versionGetter);
            }
            return this;
        }
    }
}

