/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.mutation.save;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.sql.DissociateAction;
import org.babyfish.jimmer.sql.ast.Expression;
import org.babyfish.jimmer.sql.ast.Predicate;
import org.babyfish.jimmer.sql.ast.impl.AstContext;
import org.babyfish.jimmer.sql.ast.impl.mutation.save.AbstractOperator;
import org.babyfish.jimmer.sql.ast.impl.mutation.save.DeleteContext;
import org.babyfish.jimmer.sql.ast.impl.mutation.save.ExclusiveIdPairPredicates;
import org.babyfish.jimmer.sql.ast.impl.mutation.save.IdPairs;
import org.babyfish.jimmer.sql.ast.impl.query.FilterLevel;
import org.babyfish.jimmer.sql.ast.impl.query.MutableRootQueryImpl;
import org.babyfish.jimmer.sql.ast.impl.render.AbstractSqlBuilder;
import org.babyfish.jimmer.sql.ast.impl.render.BatchSqlBuilder;
import org.babyfish.jimmer.sql.ast.impl.render.ComparisonPredicates;
import org.babyfish.jimmer.sql.ast.impl.table.TableImplementor;
import org.babyfish.jimmer.sql.ast.impl.value.ValueGetter;
import org.babyfish.jimmer.sql.ast.tuple.Tuple2;
import org.babyfish.jimmer.sql.runtime.ExecutionPurpose;
import org.babyfish.jimmer.sql.runtime.SqlBuilder;

class ChildTableOperator
extends AbstractOperator {
    private final DeleteContext ctx;
    private final ChildTableOperator parent;
    private final String tableName;
    private final List<ValueGetter> sourceGetters;
    private final List<ValueGetter> targetGetters;
    private List<ChildTableOperator> subOperators;

    ChildTableOperator(DeleteContext ctx) {
        this(null, ctx);
    }

    private ChildTableOperator(ChildTableOperator parent, ImmutableProp backReferenceProp) {
        this(parent, parent.ctx.backReferenceOf(backReferenceProp));
    }

    private ChildTableOperator(ChildTableOperator parent, DeleteContext ctx) {
        super(ctx.options.getSqlClient(), ctx.con);
        this.ctx = ctx;
        this.parent = parent;
        this.tableName = ctx.path.getType().getTableName(this.sqlClient.getMetadataStrategy());
        this.sourceGetters = ValueGetter.valueGetters(this.sqlClient, ctx.backReferenceProp);
        this.targetGetters = ValueGetter.valueGetters(this.sqlClient, ctx.path.getType().getIdProp());
        if (ctx.path.getParent() == null || ctx.options.getDissociateAction(ctx.path.getBackReferenceProp()) == DissociateAction.DELETE) {
            for (ImmutableProp backReferenceProp : this.sqlClient.getEntityManager().getAllBackProps(ctx.path.getType())) {
                if (!backReferenceProp.isColumnDefinition() || ctx.options.getDissociateAction(backReferenceProp) == DissociateAction.LAX) continue;
                List<ChildTableOperator> subOperators = this.subOperators;
                if (subOperators == null) {
                    this.subOperators = subOperators = new ArrayList<ChildTableOperator>();
                }
                subOperators.add(new ChildTableOperator(this, backReferenceProp));
            }
        }
    }

    IdPairs findDisconnectingIdPairs(IdPairs idPairs) {
        MutableRootQueryImpl query = new MutableRootQueryImpl(this.sqlClient, this.ctx.path.getType(), ExecutionPurpose.MUTATE, FilterLevel.DEFAULT);
        this.addDisconnectingConditions(query, idPairs);
        List tuples = (List)query.select(query.getTableImplementor().getAssociatedId(this.ctx.backReferenceProp), query.getTableImplementor().getId()).execute(this.con);
        return IdPairs.of(tuples);
    }

    private void addDisconnectingConditions(MutableRootQueryImpl<?> query, IdPairs idPairs) {
        TableImplementor<?> table = query.getTableImplementor();
        if (idPairs.entries().size() == 1) {
            query.where(new Predicate[]{table.getAssociatedId(this.ctx.backReferenceProp).in(Tuple2.projection1(idPairs.entries()))});
            if (!idPairs.tuples().isEmpty()) {
                query.where(new Predicate[]{table.getId().notIn(Tuple2.projection2(idPairs.tuples()))});
            }
            return;
        }
        query.where(new Predicate[]{table.getAssociatedId(this.ctx.backReferenceProp).in(Tuple2.projection1(idPairs.entries()))});
        if (!idPairs.tuples().isEmpty()) {
            query.where(new Predicate[]{Expression.tuple(table.getAssociatedId(this.ctx.backReferenceProp), table.getId()).notIn(idPairs.tuples())});
        }
    }

    int disconnectExcept(IdPairs idPairs) {
        if (this.subOperators != null) {
            for (ChildTableOperator subOperator : this.subOperators) {
                subOperator.disconnectExcept(idPairs);
            }
        }
        return this.disconnectExceptImpl(idPairs);
    }

    private int disconnectExceptImpl(IdPairs idPairs) {
        if (this.targetGetters.size() == 1 && this.sqlClient.getDialect().isAnyEqualityOfArraySupported()) {
            return this.disconnectExceptByBatch(idPairs);
        }
        return this.disconnectExceptByInPredicate(idPairs);
    }

    private int disconnectExceptByBatch(IdPairs idPairs) {
        BatchSqlBuilder builder = new BatchSqlBuilder(this.sqlClient);
        if (this.ctx.options.getDissociateAction(this.ctx.backReferenceProp) == DissociateAction.DELETE) {
            ((BatchSqlBuilder)builder.sql("delete from ")).sql(this.tableName);
        } else {
            ((BatchSqlBuilder)((BatchSqlBuilder)builder.sql("update ")).sql(this.tableName)).enter(AbstractSqlBuilder.ScopeType.SET);
            for (ValueGetter sourceGetter : this.sourceGetters) {
                ((BatchSqlBuilder)((BatchSqlBuilder)builder.separator()).sql(sourceGetter)).sql(" = null");
            }
            builder.leave();
        }
        builder.enter(AbstractSqlBuilder.ScopeType.WHERE);
        this.addPredicates(builder, null, idPairs);
        builder.leave();
        return this.execute(builder, idPairs.entries());
    }

    private int disconnectExceptByInPredicate(IdPairs idPairs) {
        SqlBuilder builder = new SqlBuilder(new AstContext(this.sqlClient));
        if (this.ctx.options.getDissociateAction(this.ctx.backReferenceProp) == DissociateAction.DELETE) {
            ((SqlBuilder)builder.sql("delete from ")).sql(this.tableName);
        } else {
            ((SqlBuilder)((SqlBuilder)builder.sql("update ")).sql(this.tableName)).enter(AbstractSqlBuilder.ScopeType.SET);
            for (ValueGetter sourceGetter : this.sourceGetters) {
                ((SqlBuilder)((SqlBuilder)builder.separator()).sql(sourceGetter)).sql(" = null");
            }
            builder.leave();
        }
        builder.enter(AbstractSqlBuilder.ScopeType.WHERE);
        this.addPredicates(builder, null, idPairs);
        builder.leave();
        return this.execute(builder);
    }

    private void addPredicates(BatchSqlBuilder builder, Collection<?> deletedIds, IdPairs retainedIdPairs) {
        if (this.parent != null) {
            builder.enter(this.sourceGetters.size() == 1 ? AbstractSqlBuilder.ScopeType.NULL : AbstractSqlBuilder.ScopeType.TUPLE);
            for (ValueGetter valueGetter : this.sourceGetters) {
                builder.separator();
                builder.sql(valueGetter);
            }
            ((BatchSqlBuilder)builder.sql(" in ")).enter(AbstractSqlBuilder.ScopeType.SUB_QUERY);
            builder.enter(AbstractSqlBuilder.ScopeType.SELECT);
            List<ValueGetter> parentGetters = ValueGetter.valueGetters(builder.sqlClient(), this.parent.ctx.path.getType().getIdProp());
            for (ValueGetter parentGetter : parentGetters) {
                ((BatchSqlBuilder)builder.separator()).sql(parentGetter);
            }
            builder.leave();
            ((BatchSqlBuilder)builder.sql(" from ")).sql(this.parent.tableName);
            builder.enter(AbstractSqlBuilder.ScopeType.WHERE);
            this.parent.addPredicates(builder, deletedIds, retainedIdPairs);
            builder.leave();
            builder.leave();
            builder.leave();
            return;
        }
        builder.separator();
        if (deletedIds != null) {
            builder.enter(this.targetGetters.size() == 1 ? AbstractSqlBuilder.ScopeType.NULL : AbstractSqlBuilder.ScopeType.AND);
            for (ValueGetter valueGetter : this.targetGetters) {
                builder.separator();
                ((BatchSqlBuilder)((BatchSqlBuilder)((BatchSqlBuilder)builder.sql(valueGetter)).sql(valueGetter)).sql(" = ")).variable(valueGetter);
            }
            builder.leave();
            return;
        }
        ExclusiveIdPairPredicates.addPredicates(builder, this.sourceGetters, this.targetGetters);
    }

    private void addPredicates(SqlBuilder builder, Collection<?> deletedIds, IdPairs retainedIdPairs) {
        if (this.parent != null) {
            builder.enter(this.sourceGetters.size() == 1 ? AbstractSqlBuilder.ScopeType.NULL : AbstractSqlBuilder.ScopeType.TUPLE);
            for (ValueGetter sourceGetter : this.sourceGetters) {
                builder.separator();
                builder.sql(sourceGetter);
            }
            ((SqlBuilder)builder.sql(" in ")).enter(AbstractSqlBuilder.ScopeType.SUB_QUERY);
            builder.enter(AbstractSqlBuilder.ScopeType.SELECT);
            List<ValueGetter> parentGetters = ValueGetter.valueGetters(builder.sqlClient(), this.parent.ctx.path.getType().getIdProp());
            for (ValueGetter parentGetter : parentGetters) {
                ((SqlBuilder)builder.separator()).sql(parentGetter);
            }
            builder.leave();
            ((SqlBuilder)builder.sql(" from ")).sql(this.parent.tableName);
            builder.enter(AbstractSqlBuilder.ScopeType.WHERE);
            this.parent.addPredicates(builder, deletedIds, retainedIdPairs);
            builder.leave();
            builder.leave();
            builder.leave();
            return;
        }
        builder.separator();
        if (deletedIds != null) {
            ComparisonPredicates.renderIn(false, this.targetGetters, deletedIds, builder);
            return;
        }
        if (retainedIdPairs.entries().size() == 1) {
            Tuple2<Object, Collection<Object>> tuple = retainedIdPairs.entries().iterator().next();
            ComparisonPredicates.renderEq(false, this.sourceGetters, tuple.get_1(), builder);
            if (!tuple.get_2().isEmpty()) {
                builder.separator();
                ComparisonPredicates.renderIn(true, this.targetGetters, tuple.get_2(), builder);
            }
            return;
        }
        ExclusiveIdPairPredicates.addPredicates(builder, this.sourceGetters, this.targetGetters, retainedIdPairs);
    }
}

