/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.mutation;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import org.babyfish.jimmer.ImmutableObjects;
import org.babyfish.jimmer.UnloadedException;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.meta.LogicalDeletedInfo;
import org.babyfish.jimmer.meta.PropId;
import org.babyfish.jimmer.meta.TargetLevel;
import org.babyfish.jimmer.meta.TypedProp;
import org.babyfish.jimmer.runtime.DraftSpi;
import org.babyfish.jimmer.runtime.ImmutableSpi;
import org.babyfish.jimmer.runtime.Internal;
import org.babyfish.jimmer.sql.DissociateAction;
import org.babyfish.jimmer.sql.DraftInterceptor;
import org.babyfish.jimmer.sql.JoinSql;
import org.babyfish.jimmer.sql.Key;
import org.babyfish.jimmer.sql.ManyToOne;
import org.babyfish.jimmer.sql.OnDissociate;
import org.babyfish.jimmer.sql.OneToOne;
import org.babyfish.jimmer.sql.ast.Predicate;
import org.babyfish.jimmer.sql.ast.PropExpression;
import org.babyfish.jimmer.sql.ast.impl.AstContext;
import org.babyfish.jimmer.sql.ast.impl.Variables;
import org.babyfish.jimmer.sql.ast.impl.mutation.AbstractEntitySaveCommandImpl;
import org.babyfish.jimmer.sql.ast.impl.mutation.ChildTableOperator;
import org.babyfish.jimmer.sql.ast.impl.mutation.DeleteCommandImpl;
import org.babyfish.jimmer.sql.ast.impl.mutation.Deleter;
import org.babyfish.jimmer.sql.ast.impl.mutation.IdAndKeyFetchers;
import org.babyfish.jimmer.sql.ast.impl.mutation.MiddleTableOperator;
import org.babyfish.jimmer.sql.ast.impl.mutation.MutableUpdateImpl;
import org.babyfish.jimmer.sql.ast.impl.mutation.MutationItem;
import org.babyfish.jimmer.sql.ast.impl.mutation.MutationTrigger;
import org.babyfish.jimmer.sql.ast.impl.mutation.NativePredicates;
import org.babyfish.jimmer.sql.ast.impl.mutation.SaverCache;
import org.babyfish.jimmer.sql.ast.impl.query.FilterLevel;
import org.babyfish.jimmer.sql.ast.impl.query.Queries;
import org.babyfish.jimmer.sql.ast.impl.render.AbstractSqlBuilder;
import org.babyfish.jimmer.sql.ast.impl.table.TableImplementor;
import org.babyfish.jimmer.sql.ast.mutation.AffectedTable;
import org.babyfish.jimmer.sql.ast.mutation.AssociatedSaveMode;
import org.babyfish.jimmer.sql.ast.mutation.LockMode;
import org.babyfish.jimmer.sql.ast.mutation.SaveMode;
import org.babyfish.jimmer.sql.ast.mutation.SimpleSaveResult;
import org.babyfish.jimmer.sql.ast.table.Table;
import org.babyfish.jimmer.sql.ast.table.spi.TableProxy;
import org.babyfish.jimmer.sql.ast.table.spi.UntypedJoinDisabledTableProxy;
import org.babyfish.jimmer.sql.ast.tuple.Tuple2;
import org.babyfish.jimmer.sql.ast.tuple.Tuple3;
import org.babyfish.jimmer.sql.dialect.Dialect;
import org.babyfish.jimmer.sql.dialect.OracleDialect;
import org.babyfish.jimmer.sql.dialect.PostgresDialect;
import org.babyfish.jimmer.sql.fetcher.impl.FetcherImpl;
import org.babyfish.jimmer.sql.meta.ColumnDefinition;
import org.babyfish.jimmer.sql.meta.IdGenerator;
import org.babyfish.jimmer.sql.meta.JoinTemplate;
import org.babyfish.jimmer.sql.meta.MetadataStrategy;
import org.babyfish.jimmer.sql.meta.MiddleTable;
import org.babyfish.jimmer.sql.meta.SingleColumn;
import org.babyfish.jimmer.sql.meta.UserIdGenerator;
import org.babyfish.jimmer.sql.meta.impl.IdentityIdGenerator;
import org.babyfish.jimmer.sql.meta.impl.SequenceIdGenerator;
import org.babyfish.jimmer.sql.runtime.Converters;
import org.babyfish.jimmer.sql.runtime.ExecutionException;
import org.babyfish.jimmer.sql.runtime.ExecutionPurpose;
import org.babyfish.jimmer.sql.runtime.Executor;
import org.babyfish.jimmer.sql.runtime.MutationPath;
import org.babyfish.jimmer.sql.runtime.SaveException;
import org.babyfish.jimmer.sql.runtime.SqlBuilder;

class Saver {
    private static final String GENERAL_OPTIMISTIC_DISABLED_JOIN_REASON = "Joining is disabled in general optimistic lock";
    private final AbstractEntitySaveCommandImpl.Data data;
    private final Connection con;
    private final SaverCache cache;
    private final MutationTrigger trigger;
    private final boolean triggerSubmitImmediately;
    private final Map<AffectedTable, Integer> affectedRowCountMap;
    private final MutationPath path;
    private boolean triggerSubmitted;

    Saver(AbstractEntitySaveCommandImpl.Data data, Connection con, ImmutableType type) {
        this(data, con, type, new SaverCache(data), true, new LinkedHashMap<AffectedTable, Integer>());
    }

    Saver(AbstractEntitySaveCommandImpl.Data data, Connection con, ImmutableType type, SaverCache cache, boolean triggerSubmitImmediately, Map<AffectedTable, Integer> affectedRowCountMap) {
        this.data = data;
        this.con = con;
        this.cache = cache;
        this.trigger = data.getTriggers() != null ? new MutationTrigger() : null;
        this.triggerSubmitImmediately = triggerSubmitImmediately && this.trigger != null;
        this.affectedRowCountMap = affectedRowCountMap;
        this.path = MutationPath.root(type);
    }

    Saver(Saver base, AbstractEntitySaveCommandImpl.Data data, ImmutableProp prop) {
        this.data = data;
        this.con = base.con;
        this.cache = base.cache;
        this.trigger = base.trigger;
        this.triggerSubmitImmediately = this.trigger != null;
        this.affectedRowCountMap = base.affectedRowCountMap;
        this.path = base.path.to(prop);
    }

    public <E> SimpleSaveResult<E> save(E entity) {
        ImmutableType immutableType = ImmutableType.get(entity.getClass());
        Object newEntity = Internal.produce((ImmutableType)immutableType, entity, draft -> this.saveImpl((DraftSpi)draft), this.trigger == null ? null : this.trigger::prepareSubmit);
        if (this.triggerSubmitImmediately) {
            this.submitTrigger();
        }
        return new SimpleSaveResult<Object>(this.affectedRowCountMap, entity, newEntity);
    }

    public void submitTrigger() {
        if (this.trigger != null && !this.triggerSubmitted) {
            this.trigger.submit(this.data.getSqlClient(), this.con);
            this.triggerSubmitted = true;
        }
    }

    private void saveImpl(DraftSpi draftSpi) {
        this.saveAssociations(draftSpi, ObjectType.EXISTING, true);
        ObjectType objectType = this.saveSelf(draftSpi);
        this.saveAssociations(draftSpi, objectType, false);
    }

    private void saveAssociations(DraftSpi currentDraftSpi, ObjectType currentObjectType, boolean forParent) {
        ImmutableType currentType = currentDraftSpi.__type();
        for (ImmutableProp prop : currentType.getProps().values()) {
            int rowCount;
            MiddleTableOperator middleTableOperator;
            if (!prop.isAssociation(TargetLevel.ENTITY) || prop.isColumnDefinition() != forParent || !currentDraftSpi.__isLoaded(prop.getId())) continue;
            if (this.isReadOnlyMiddleTable(prop)) {
                throw new SaveException.ReadonlyMiddleTable(this.path, "The property \"" + prop + "\" which is based on readonly middle table cannot be saved");
            }
            ImmutableType targetType = prop.getTargetType();
            if (prop.isRemote() && prop.getMappedBy() != null) {
                throw new SaveException.ReversedRemoteAssociation(this.path, "The property \"" + prop + "\" which is reversed(with `mappedBy`) remote(across different microservices) association cannot be supported by save command");
            }
            if (prop.getSqlTemplate() instanceof JoinTemplate) {
                throw new SaveException.UnstructuredAssociation(this.path, "The property \"" + prop + "\" which is unstructured association(decorated by @" + JoinSql.class.getName() + ") cannot be supported by save command");
            }
            PropId currentIdPropId = currentType.getIdProp().getId();
            Object currentId = currentDraftSpi.__isLoaded(currentIdPropId) ? currentDraftSpi.__get(currentIdPropId) : null;
            ImmutableProp mappedBy = prop.getMappedBy();
            ChildTableOperator childTableOperator = null;
            if (!prop.isRemote() && mappedBy != null && mappedBy.isColumnDefinition()) {
                childTableOperator = new ChildTableOperator(this.data.getSqlClient(), this.con, mappedBy, this.data.getLockMode() == LockMode.PESSIMISTIC, this.cache, this.trigger);
            }
            Object associatedValue = currentDraftSpi.__get(prop.getId());
            LinkedHashSet<Object> associatedObjectIds = new LinkedHashSet<Object>();
            if (associatedValue == null) {
                if (prop.isInputNotNull()) {
                    throw new SaveException.NullTarget(this.path, "The association \"" + prop + "\" cannot be null, because that association is decorated by \"@" + (prop.getAnnotation(ManyToOne.class) != null ? ManyToOne.class : OneToOne.class).getName() + "\" whose `inputNotNull` is true");
                }
            } else {
                List<DraftSpi> associatedObjects = associatedValue instanceof List ? (List<DraftSpi>)associatedValue : Collections.singletonList((DraftSpi)associatedValue);
                List<Object> idOnlyTargetIds = Collections.emptyList();
                if (this.data.isAutoCheckingProp(prop) || childTableOperator != null) {
                    PropId targetIdPropId = prop.getTargetType().getIdProp().getId();
                    idOnlyTargetIds = new ArrayList();
                    for (DraftSpi associatedObject : associatedObjects) {
                        if (!this.isNonIdPropLoaded((ImmutableSpi)associatedObject, false)) {
                            Object targetId;
                            try {
                                targetId = associatedObject.__get(targetIdPropId);
                            }
                            catch (UnloadedException ex) {
                                throw new SaveException.EmptyObject(this.path, "An associated object of the property \"" + prop + "\" does not have any properties");
                            }
                            idOnlyTargetIds.add(targetId);
                            continue;
                        }
                        if (!prop.isRemote()) continue;
                        throw new SaveException.LongRemoteAssociation(this.path, "The property \"" + prop + "\" is remote(across different microservices) association, but it has associated object which is not id-only");
                    }
                }
                if (this.data.isAutoCheckingProp(prop)) {
                    this.validateIdOnlyTargetIds(prop, idOnlyTargetIds);
                }
                if (childTableOperator != null) {
                    for (DraftSpi associatedObject : associatedObjects) {
                        if (!this.isNonIdPropLoaded((ImmutableSpi)associatedObject, false)) continue;
                        associatedObject.__set(mappedBy.getId(), Internal.produce((ImmutableType)currentType, null, backRef -> ((DraftSpi)backRef).__set(currentIdPropId, currentId)));
                    }
                    if (!idOnlyTargetIds.isEmpty()) {
                        int rowCount2 = childTableOperator.setParent(currentId, idOnlyTargetIds);
                        this.addOutput(AffectedTable.of(targetType), rowCount2);
                    }
                }
                for (DraftSpi associatedObject : associatedObjects) {
                    associatedObjectIds.add(this.saveAssociatedObjectAndGetId(prop, associatedObject));
                }
            }
            if (childTableOperator != null && currentObjectType != ObjectType.NEW && this.data.getAssociatedMode(prop) == AssociatedSaveMode.REPLACE) {
                DissociateAction dissociateAction = this.data.getDissociateAction(prop.getMappedBy());
                if (dissociateAction == DissociateAction.DELETE) {
                    List<Object> detachedTargetIds = childTableOperator.getDetachedChildIds(currentId, associatedObjectIds);
                    Deleter deleter = new Deleter(new DeleteCommandImpl.Data(this.data.getSqlClient(), this.data.getDeleteMode(), this.data.dissociateActionMap()), this.con, this.cache, this.trigger, this.affectedRowCountMap);
                    deleter.addPreHandleInput(prop.getTargetType(), detachedTargetIds);
                    deleter.execute(false);
                } else if (dissociateAction == DissociateAction.SET_NULL) {
                    int rowCount3 = childTableOperator.unsetParent(currentId, associatedObjectIds);
                    this.addOutput(AffectedTable.of(targetType), rowCount3);
                } else if (childTableOperator.exists(currentId, associatedObjectIds)) {
                    throw new SaveException.CannotDissociateTarget(this.path.to(prop), "Cannot dissociate child objects because the dissociation action of the many-to-one property \"" + mappedBy + "\" is not configured as \"set null\" or \"cascade\". There are two ways to resolve this issue: Decorate the many-to-one property \"" + mappedBy + "\" by @" + OnDissociate.class.getName() + " whose argument is `DissociateAction.SET_NULL` or `DissociateAction.DELETE` , or use save command's runtime configuration to override it");
                }
            }
            if ((middleTableOperator = MiddleTableOperator.tryGet(this.data.getSqlClient(), this.con, prop, this.trigger)) == null) continue;
            AssociatedSaveMode associatedMode = this.data.getAssociatedMode(prop);
            if (currentObjectType == ObjectType.NEW || associatedMode == AssociatedSaveMode.APPEND) {
                rowCount = middleTableOperator.addTargetIds(currentId, associatedObjectIds);
            } else if (associatedMode == AssociatedSaveMode.MERGE) {
                middleTableOperator.getTargetIds(currentId).forEach(associatedObjectIds::remove);
                rowCount = middleTableOperator.addTargetIds(currentId, associatedObjectIds);
            } else {
                rowCount = middleTableOperator.setTargetIds(currentId, associatedObjectIds);
            }
            this.addOutput(AffectedTable.of(prop), rowCount);
        }
    }

    private boolean isReadOnlyMiddleTable(ImmutableProp prop) {
        ImmutableProp mappedBy = prop.getMappedBy();
        if (mappedBy != null) {
            prop = mappedBy;
        }
        if (prop.isMiddleTableDefinition()) {
            MiddleTable middleTable = (MiddleTable)prop.getStorage(this.data.getSqlClient().getMetadataStrategy());
            return middleTable.isReadonly();
        }
        return false;
    }

    private void validateIdOnlyTargetIds(ImmutableProp prop, List<Object> targetIds) {
        if (targetIds.isEmpty()) {
            return;
        }
        LinkedHashSet<Object> illegalTargetIds = new LinkedHashSet<Object>(targetIds.size());
        for (Object targetId : targetIds) {
            if (this.cache.hasId(prop.getTargetType(), targetId)) continue;
            illegalTargetIds.add(targetId);
        }
        if (illegalTargetIds.isEmpty()) {
            return;
        }
        if (prop.isRemote()) {
            List<ImmutableSpi> targets;
            PropId targetIdPropId = prop.getTargetType().getIdProp().getId();
            try {
                targets = this.data.getSqlClient().getMicroServiceExchange().findByIds(prop.getTargetType().getMicroServiceName(), illegalTargetIds, new FetcherImpl(prop.getTargetType().getJavaClass()));
            }
            catch (Exception ex) {
                throw new SaveException.FailedRemoteValidation(this.path, "Cannot validate the id-only associated objects of remote association \"" + prop + "\"");
            }
            for (ImmutableSpi target : targets) {
                illegalTargetIds.remove(target.__get(targetIdPropId));
            }
        } else {
            List existingTargetIds = (List)Queries.createQuery(this.data.getSqlClient(), prop.getTargetType(), ExecutionPurpose.MUTATE, FilterLevel.DEFAULT, (q, t) -> {
                PropExpression idExpr = t.get(prop.getTargetType().getIdProp());
                q.where(new Predicate[]{idExpr.in(illegalTargetIds)});
                return q.select(idExpr);
            }).execute(this.con);
            illegalTargetIds.removeAll(new HashSet(existingTargetIds));
        }
        if (!illegalTargetIds.isEmpty()) {
            throw new SaveException.IllegalTargetId(this.path.to(prop), "Illegal ids: " + illegalTargetIds);
        }
    }

    private Object saveAssociatedObjectAndGetId(ImmutableProp prop, DraftSpi associatedDraftSpi) {
        if (this.isNonIdPropLoaded((ImmutableSpi)associatedDraftSpi, true)) {
            AbstractEntitySaveCommandImpl.Data associatedData = new AbstractEntitySaveCommandImpl.Data(this.data);
            associatedData.setMode(this.data.getAssociatedMode(prop) == AssociatedSaveMode.APPEND ? SaveMode.INSERT_ONLY : SaveMode.UPSERT);
            Saver associatedSaver = new Saver(this, associatedData, prop);
            associatedSaver.saveImpl(associatedDraftSpi);
        }
        return associatedDraftSpi.__get(associatedDraftSpi.__type().getIdProp().getId());
    }

    private ObjectType saveSelf(DraftSpi draftSpi) {
        if (this.cache.isSaved((ImmutableSpi)draftSpi)) {
            return ObjectType.EXISTING;
        }
        if (this.data.getMode() == SaveMode.INSERT_ONLY) {
            if (this.trigger != null) {
                this.trigger.modifyEntityTable(null, draftSpi);
            }
            this.insert(draftSpi);
            return ObjectType.NEW;
        }
        DraftInterceptor<?, ?> interceptor = this.data.getSqlClient().getDraftInterceptor(draftSpi.__type());
        PropId idPropId = draftSpi.__type().getIdProp().getId();
        if (this.trigger == null && this.data.getMode() == SaveMode.UPDATE_ONLY && draftSpi.__isLoaded(idPropId) && this.isKeyOnlyDraftHandler(interceptor, draftSpi.__type())) {
            this.update(draftSpi, (ImmutableSpi)ImmutableObjects.makeIdOnly((ImmutableType)draftSpi.__type(), (Object)draftSpi.__get(idPropId)), false);
            return ObjectType.EXISTING;
        }
        ImmutableSpi existingSpi = this.find(draftSpi);
        if (existingSpi != null) {
            boolean updated;
            if (draftSpi.__isLoaded(idPropId)) {
                updated = this.update(draftSpi, existingSpi, false);
            } else {
                draftSpi.__set(idPropId, existingSpi.__get(idPropId));
                updated = this.update(draftSpi, existingSpi, true);
            }
            if (updated && this.trigger != null) {
                this.trigger.modifyEntityTable(existingSpi, draftSpi);
            }
            return ObjectType.EXISTING;
        }
        if (this.data.getMode() == SaveMode.UPDATE_ONLY && this.path.getParent() == null) {
            this.addOutput(AffectedTable.of(draftSpi.__type()), 0);
            return ObjectType.UNKNOWN;
        }
        if (this.trigger != null) {
            this.trigger.modifyEntityTable(null, draftSpi);
        }
        this.insert(draftSpi);
        return ObjectType.NEW;
    }

    private void insert(DraftSpi draftSpi) {
        boolean generateKeys;
        Object overrideIdentityIdSql;
        Object id;
        this.callInterceptor(draftSpi, null);
        ImmutableType type = draftSpi.__type();
        IdGenerator idGenerator = this.data.getSqlClient().getIdGenerator(type.getJavaClass());
        Object object = id = draftSpi.__isLoaded(type.getIdProp().getId()) ? draftSpi.__get(type.getIdProp().getId()) : null;
        if (id == null) {
            if (idGenerator == null) {
                throw new SaveException.NoIdGenerator(this.path, "Cannot save \"" + type + "\" without id because id generator is not specified");
            }
            if (idGenerator instanceof SequenceIdGenerator) {
                String sql = this.data.getSqlClient().getDialect().getSelectIdFromSequenceSql(((SequenceIdGenerator)idGenerator).getSequenceName());
                id = this.data.getSqlClient().getExecutor().execute(new Executor.Args<Object>(this.data.getSqlClient(), this.con, sql, Collections.emptyList(), this.data.getSqlClient().getSqlFormatter().isPretty() ? Collections.emptyList() : null, ExecutionPurpose.MUTATE, null, stmt -> {
                    try (ResultSet rs = stmt.executeQuery();){
                        rs.next();
                        Object object = rs.getObject(1);
                        return object;
                    }
                }));
                this.setDraftId(draftSpi, id);
            } else if (idGenerator instanceof UserIdGenerator) {
                id = ((UserIdGenerator)idGenerator).generate(type.getJavaClass());
                this.setDraftId(draftSpi, id);
            } else if (!(idGenerator instanceof IdentityIdGenerator)) {
                throw new SaveException.IllegalIdGenerator(this.path, "Illegal id generator type: \"" + idGenerator.getClass().getName() + "\", id generator must be sub type of \"" + SequenceIdGenerator.class.getName() + "\", \"" + IdentityIdGenerator.class.getName() + "\" or \"" + UserIdGenerator.class.getName() + "\"");
            }
        }
        if (type.getVersionProp() != null && !draftSpi.__isLoaded(type.getVersionProp().getId())) {
            draftSpi.__set(type.getVersionProp().getId(), (Object)0);
        }
        ArrayList<MutationItem> items = new ArrayList<MutationItem>();
        for (ImmutableProp prop : draftSpi.__type().getProps().values()) {
            if (!prop.isColumnDefinition()) continue;
            if (!draftSpi.__isLoaded(prop.getId())) {
                if (prop.isNullable()) continue;
                if (prop.isLogicalDeleted()) {
                    LogicalDeletedInfo info = draftSpi.__type().getLogicalDeletedInfo();
                    assert (info != null);
                    draftSpi.__set(prop.getId(), info.allocateInitializedValue());
                } else {
                    if (prop.getDefaultValueRef() == null) continue;
                    draftSpi.__set(prop.getId(), prop.getDefaultValueRef().getValue());
                }
            }
            items.addAll(MutationItem.create(prop, draftSpi.__get(prop.getId())));
        }
        if (items.isEmpty()) {
            throw new SaveException.NoNonIdProps(this.path, "Cannot insert \"" + type + "\" without any properties");
        }
        SqlBuilder builder = new SqlBuilder(new AstContext(this.data.getSqlClient()));
        MetadataStrategy strategy = this.data.getSqlClient().getMetadataStrategy();
        ((SqlBuilder)((SqlBuilder)builder.sql("insert into ")).sql(type.getTableName(strategy))).enter(AbstractSqlBuilder.ScopeType.TUPLE);
        for (MutationItem item : items) {
            ((SqlBuilder)builder.separator()).sql(item.columnName(strategy));
        }
        builder.leave();
        if (id != null && idGenerator instanceof IdentityIdGenerator && (overrideIdentityIdSql = this.data.getSqlClient().getDialect().getOverrideIdentityIdSql()) != null) {
            ((SqlBuilder)builder.sql(" ")).sql((String)overrideIdentityIdSql);
        }
        ((SqlBuilder)builder.enter(AbstractSqlBuilder.ScopeType.VALUES)).enter(AbstractSqlBuilder.ScopeType.TUPLE);
        for (MutationItem item : items) {
            builder.separator();
            builder.variable(Variables.process(item.getValue(), item.getProp(), this.data.getSqlClient()));
        }
        ((SqlBuilder)builder.leave()).leave();
        boolean bl = generateKeys = id == null;
        if (generateKeys) {
            Dialect dialect = this.data.getSqlClient().getDialect();
            if (dialect instanceof PostgresDialect) {
                ((SqlBuilder)builder.sql(" returning ")).sql(((SingleColumn)type.getIdProp().getStorage(strategy)).getName());
            } else if (dialect instanceof OracleDialect) {
                throw new ExecutionException("\"" + IdentityIdGenerator.class.getName() + "\" is not supported by Oracle");
            }
        }
        Tuple3<String, List<Object>, List<Integer>> sqlResult = builder.build();
        Object insertedResult = this.data.getSqlClient().getExecutor().execute(new Executor.Args<Object>(this.data.getSqlClient(), this.con, sqlResult.get_1(), sqlResult.get_2(), sqlResult.get_3(), ExecutionPurpose.MUTATE, generateKeys ? (c, s) -> c.prepareStatement(s, 1) : null, stmt -> {
            if (generateKeys) {
                Object generatedId;
                int updateCount = stmt.executeUpdate();
                try (ResultSet rs = stmt.getGeneratedKeys();){
                    rs.next();
                    generatedId = rs.getObject(1);
                }
                return new Tuple2<Integer, Object>(updateCount, generatedId);
            }
            return stmt.executeUpdate();
        }));
        int rowCount = insertedResult instanceof Tuple2 ? (Integer)((Tuple2)insertedResult).get_1() : (Integer)insertedResult;
        this.addOutput(AffectedTable.of(type), rowCount);
        if (insertedResult instanceof Tuple2) {
            id = ((Tuple2)insertedResult).get_2();
            this.setDraftId(draftSpi, id);
        }
        this.cache.save((ImmutableSpi)draftSpi, true);
    }

    private boolean update(DraftSpi draftSpi, ImmutableSpi original, boolean excludeKeyProps) {
        ImmutableType type = draftSpi.__type();
        Set<Object> excludeProps = null;
        if (excludeKeyProps) {
            excludeProps = this.data.getKeyProps(type);
        }
        if (excludeProps == null) {
            excludeProps = Collections.emptySet();
        }
        boolean needUpdated = false;
        for (ImmutableProp prop : type.getProps().values()) {
            if (prop.isId() || !prop.isColumnDefinition() || !draftSpi.__isLoaded(prop.getId()) || excludeProps.contains(prop)) continue;
            needUpdated = true;
            break;
        }
        if (!needUpdated) {
            return false;
        }
        this.callInterceptor(draftSpi, original);
        ArrayList<MutationItem> items = new ArrayList<MutationItem>();
        LockMode lockMode = this.data.getLockMode();
        Integer version = null;
        BiFunction<Table<?>, Object, Predicate> lambda = lockMode == LockMode.OPTIMISTIC ? this.data.getOptimisticLockLambda(type) : null;
        for (ImmutableProp prop : type.getProps().values()) {
            if (!prop.isColumnDefinition() || !draftSpi.__isLoaded(prop.getId())) continue;
            if (prop.isVersion() && lockMode == LockMode.OPTIMISTIC) {
                version = (Integer)draftSpi.__get(prop.getId());
                continue;
            }
            if (prop.isId() || excludeProps.contains(prop)) continue;
            items.addAll(MutationItem.create(prop, draftSpi.__get(prop.getId())));
        }
        if (lockMode == LockMode.OPTIMISTIC && this.data.getOptimisticLockLambda(type) == null && type.getVersionProp() != null && version == null) {
            throw new SaveException.NoVersion(this.path, "Cannot update \"" + type + "\", the version property \"" + type.getVersionProp() + "\" is unloaded");
        }
        if (items.isEmpty() && version == null) {
            return false;
        }
        int rowCount = lambda != null ? this.executeUpdateWithLambda(draftSpi, items, version, lambda) : this.executeUpdateWithoutLambda(draftSpi, items, version);
        if (rowCount != 0) {
            this.addOutput(AffectedTable.of(type), rowCount);
            if (version != null) {
                Saver.increaseDraftVersion(draftSpi);
            }
            this.cache.save((ImmutableSpi)draftSpi, true);
        } else if (version != null || lambda != null) {
            throw new SaveException.OptimisticLockError(this.path, "Cannot update the entity whose type is \"" + type + "\" and id is \"" + draftSpi.__get(type.getIdProp().getId()) + "\" when using optimistic lock");
        }
        return true;
    }

    private int executeUpdateWithLambda(DraftSpi draftSpi, List<MutationItem> items, Integer version, BiFunction<Table<?>, Object, Predicate> lambda) {
        ImmutableType type = draftSpi.__type();
        ImmutableProp idProp = type.getIdProp();
        MutableUpdateImpl update = new MutableUpdateImpl(this.data.getSqlClient(), type, true);
        Object table = update.getTable();
        table = table instanceof TableImplementor ? new UntypedJoinDisabledTableProxy((TableImplementor)table, GENERAL_OPTIMISTIC_DISABLED_JOIN_REASON) : ((TableProxy)table).__disableJoin(GENERAL_OPTIMISTIC_DISABLED_JOIN_REASON);
        for (MutationItem item : items) {
            update.set(item.expression((Table<?>)table), item.getValue());
        }
        update.where(table.get(idProp).eq(draftSpi.__get(idProp.getId())));
        if (version != null) {
            ImmutableProp versionProp = type.getVersionProp();
            assert (versionProp != null);
            update.where(table.get(versionProp).eq(version));
        }
        update.where(lambda.apply((Table<?>)table, draftSpi));
        return update.execute(this.con);
    }

    private int executeUpdateWithoutLambda(DraftSpi draftSpi, List<MutationItem> items, Integer version) {
        ImmutableType type = draftSpi.__type();
        ImmutableProp idProp = type.getIdProp();
        SqlBuilder builder = new SqlBuilder(new AstContext(this.data.getSqlClient()));
        MetadataStrategy strategy = this.data.getSqlClient().getMetadataStrategy();
        ((SqlBuilder)((SqlBuilder)builder.sql("update ")).sql(type.getTableName(strategy))).enter(AbstractSqlBuilder.ScopeType.SET);
        for (MutationItem item : items) {
            ((SqlBuilder)((SqlBuilder)((SqlBuilder)builder.separator()).sql(item.columnName(strategy))).sql(" = ")).variable(Variables.process(item.getValue(), item.getProp(), this.data.getSqlClient()));
        }
        String versionColumName = null;
        if (version != null) {
            versionColumName = ((SingleColumn)type.getVersionProp().getStorage(strategy)).getName();
            ((SqlBuilder)((SqlBuilder)((SqlBuilder)((SqlBuilder)builder.separator()).sql(versionColumName)).sql(" = ")).sql(versionColumName)).sql(" + 1");
        }
        builder.leave();
        builder.enter(AbstractSqlBuilder.ScopeType.WHERE);
        NativePredicates.renderPredicates(false, (ColumnDefinition)type.getIdProp().getStorage(strategy), Collections.singleton(draftSpi.__get(idProp.getId())), builder);
        if (versionColumName != null) {
            ((SqlBuilder)((SqlBuilder)((SqlBuilder)builder.separator()).sql(versionColumName)).sql(" = ")).variable(version);
        }
        builder.leave();
        Tuple3<String, List<Object>, List<Integer>> sqlResult = builder.build();
        return this.data.getSqlClient().getExecutor().execute(new Executor.Args<Integer>(this.data.getSqlClient(), this.con, sqlResult.get_1(), sqlResult.get_2(), sqlResult.get_3(), ExecutionPurpose.MUTATE, null, PreparedStatement::executeUpdate));
    }

    private void callInterceptor(DraftSpi draftSpi, ImmutableSpi original) {
        ImmutableType type = draftSpi.__type();
        DraftInterceptor<?, ?> interceptor = this.data.getSqlClient().getDraftInterceptor(type);
        if (interceptor != null) {
            PropId idPropId = type.getIdProp().getId();
            Object id = draftSpi.__isLoaded(idPropId) ? draftSpi.__get(type.getIdProp().getId()) : null;
            interceptor.beforeSave(draftSpi, original);
            if (id != null) {
                if (!draftSpi.__isLoaded(idPropId)) {
                    throw new IllegalStateException("Draft handlers cannot be used to unload id");
                }
                if (!id.equals(draftSpi.__get(idPropId))) {
                    throw new IllegalStateException("Draft handlers cannot be used to change id");
                }
            }
        }
    }

    private ImmutableSpi find(DraftSpi example) {
        ImmutableSpi spi;
        ImmutableSpi cached;
        ImmutableProp prop = this.path.getProp();
        boolean requiresKey = prop != null && this.data.getAssociatedMode(prop) != AssociatedSaveMode.APPEND;
        try {
            cached = this.cache.find((ImmutableSpi)example, requiresKey);
        }
        catch (IllegalArgumentException ex) {
            throw new SaveException.NoKeyProps(this.path, ex.getMessage());
        }
        if (cached != null) {
            return cached;
        }
        ImmutableType type = example.__type();
        Collection<ImmutableProp> actualKeyProps = this.actualKeyProps((ImmutableSpi)example, requiresKey);
        if (actualKeyProps.isEmpty()) {
            return null;
        }
        List rows = (List)Internal.requiresNewDraftContext(ctx -> {
            List list = (List)Queries.createQuery(this.data.getSqlClient(), type, ExecutionPurpose.MUTATE, FilterLevel.DEFAULT, (q, table) -> {
                for (ImmutableProp keyProp : actualKeyProps) {
                    if (keyProp.isReference(TargetLevel.ENTITY)) {
                        ImmutableProp targetIdProp = keyProp.getTargetType().getIdProp();
                        PropExpression targetIdExpression = table.getAssociatedId(keyProp);
                        ImmutableSpi target = (ImmutableSpi)example.__get(keyProp.getId());
                        if (target != null) {
                            q.where(new Predicate[]{targetIdExpression.eq(target.__get(targetIdProp.getId()))});
                            continue;
                        }
                        q.where(new Predicate[]{targetIdExpression.isNull()});
                        continue;
                    }
                    Object value = example.__get(keyProp.getId());
                    if (value != null) {
                        q.where(new Predicate[]{table.get(keyProp).eq(value)});
                        continue;
                    }
                    q.where(new Predicate[]{table.get(keyProp).isNull()});
                }
                if (this.trigger != null) {
                    return q.select(table);
                }
                return q.select(table.fetch(IdAndKeyFetchers.getFetcher(this.data.getSqlClient(), type)));
            }).forUpdate(this.data.getLockMode() == LockMode.PESSIMISTIC).execute(this.con);
            return ctx.resolveList(list);
        });
        if (rows.size() > 1) {
            throw new SaveException.KeyNotUnique(this.path, "Key properties " + actualKeyProps + " cannot guarantee uniqueness under that path, do you forget to add unique constraint for that key?");
        }
        ImmutableSpi immutableSpi = spi = rows.isEmpty() ? null : (ImmutableSpi)rows.get(0);
        if (spi != null) {
            this.cache.save(spi, false);
        }
        return spi;
    }

    private Collection<ImmutableProp> actualKeyProps(ImmutableSpi spi, boolean requiresKey) {
        Object id;
        ImmutableType type = spi.__type();
        ImmutableProp idProp = type.getIdProp();
        Object object = id = spi.__isLoaded(idProp.getId()) ? spi.__get(idProp.getId()) : null;
        if (id != null) {
            return Collections.singleton(idProp);
        }
        Set<ImmutableProp> keyProps = this.data.getKeyProps(type);
        if (keyProps.isEmpty() && requiresKey) {
            throw new SaveException.NoKeyProps(this.path, "Cannot save \"" + type + "\" that have no properties decorated by \"@" + Key.class.getName() + "\"");
        }
        return keyProps;
    }

    private void addOutput(AffectedTable affectTable, int affectedRowCount) {
        if (affectedRowCount != 0) {
            this.affectedRowCountMap.merge(affectTable, affectedRowCount, Integer::sum);
        }
    }

    private boolean isNonIdPropLoaded(ImmutableSpi spi, boolean validate) {
        boolean idPropLoaded = false;
        boolean nonIdPropLoaded = false;
        for (ImmutableProp prop : spi.__type().getProps().values()) {
            if (!spi.__isLoaded(prop.getId())) continue;
            if (prop.isId()) {
                idPropLoaded = true;
                continue;
            }
            nonIdPropLoaded = true;
        }
        if (nonIdPropLoaded && !idPropLoaded) {
            Set<ImmutableProp> keyProps = this.data.getKeyProps(spi.__type());
            for (ImmutableProp keyProp : keyProps) {
                if (!validate || spi.__isLoaded(keyProp.getId())) continue;
                throw new SaveException.NeitherIdNorKey(this.path, "Cannot save illegal entity object " + spi + " whose type is \"" + spi.__type() + "\", key property \"" + keyProp + "\" must be loaded when id is unloaded");
            }
        } else if (validate && !idPropLoaded) {
            throw new SaveException.NeitherIdNorKey(this.path, "Cannot save illegal entity object " + spi + " whose type is \"" + spi.__type() + "\", neither id nor key is specified");
        }
        return nonIdPropLoaded;
    }

    private void setDraftId(DraftSpi spi, Object id) {
        ImmutableType type = spi.__type();
        ImmutableProp idProp = type.getIdProp();
        Object convertedId = Converters.tryConvert(id, idProp.getElementClass());
        if (convertedId == null) {
            throw new SaveException.IllegalGeneratedId(this.path, "The type of generated id does not match the property \"" + idProp + "\"");
        }
        spi.__set(idProp.getId(), convertedId);
    }

    private boolean isKeyOnlyDraftHandler(DraftInterceptor<?, ?> handler, ImmutableType type) {
        if (handler == null) {
            return true;
        }
        Set<ImmutableProp> keyProps = this.data.getKeyProps(type);
        Collection<TypedProp<?, ?>> dependencies = handler.dependencies();
        for (TypedProp<?, ?> typedProp : dependencies) {
            if (keyProps.contains(typedProp.unwrap())) continue;
            return false;
        }
        return true;
    }

    private static void increaseDraftVersion(DraftSpi spi) {
        ImmutableType type = spi.__type();
        ImmutableProp versionProp = type.getVersionProp();
        spi.__set(versionProp.getId(), (Object)((Integer)spi.__get(versionProp.getId()) + 1));
    }

    private static enum ObjectType {
        UNKNOWN,
        NEW,
        EXISTING;

    }
}

