/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.runtime;

import java.util.List;
import java.util.Objects;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.TargetLevel;
import org.babyfish.jimmer.sql.DissociateAction;
import org.babyfish.jimmer.sql.meta.MetadataStrategy;
import org.babyfish.jimmer.sql.meta.MiddleTable;
import org.babyfish.jimmer.sql.meta.Storage;
import org.jetbrains.annotations.NotNull;

public final class DissociationInfo {
    @NotNull
    private final List<ImmutableProp> props;
    @NotNull
    private final List<ImmutableProp> backProps;

    public DissociationInfo(List<ImmutableProp> props, List<ImmutableProp> backProps) {
        this.props = Objects.requireNonNull(props, "`props` cannot be null");
        this.backProps = Objects.requireNonNull(backProps, "`backProps` cannot be null");
    }

    public List<ImmutableProp> getProps() {
        return this.props;
    }

    public List<ImmutableProp> getBackProps() {
        return this.backProps;
    }

    public boolean isDirectlyDeletable(MetadataStrategy strategy) {
        MiddleTable middleTable;
        Storage storage;
        boolean checkRequired = false;
        for (ImmutableProp backProp : this.backProps) {
            if (backProp.isReference(TargetLevel.PERSISTENT) && backProp.getDissociateAction() != DissociateAction.LAX) {
                checkRequired = true;
                break;
            }
            storage = backProp.getStorage(strategy);
            if (!(storage instanceof MiddleTable) || (middleTable = (MiddleTable)storage).isCascadeDeletedByTarget()) continue;
            checkRequired = true;
            break;
        }
        if (!checkRequired) {
            for (ImmutableProp prop : this.props) {
                storage = prop.getStorage(strategy);
                if (!(storage instanceof MiddleTable) || (middleTable = (MiddleTable)storage).isCascadeDeletedBySource()) continue;
                checkRequired = true;
                break;
            }
        }
        return !checkRequired;
    }

    public int hashCode() {
        return Objects.hash(this.props, this.backProps);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DissociationInfo that = (DissociationInfo)o;
        return Objects.equals(this.props, that.props) && Objects.equals(this.backProps, that.backProps);
    }

    public String toString() {
        return "DissociationInfo{props=" + this.props + ", backProps=" + this.backProps + '}';
    }
}

