/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.cache;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.babyfish.jimmer.jackson.ImmutableModule;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.sql.cache.Cache;
import org.babyfish.jimmer.sql.cache.CacheOperator;
import org.babyfish.jimmer.sql.cache.LocatedCache;
import org.babyfish.jimmer.sql.cache.spi.AbstractCacheOperator;
import org.babyfish.jimmer.sql.runtime.ConnectionManager;
import org.babyfish.jimmer.sql.runtime.ExecutionException;
import org.babyfish.jimmer.sql.runtime.JSqlClientImplementor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionCacheOperator
extends AbstractCacheOperator {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransactionCacheOperator.class);
    public static final String TABLE_NAME = "JIMMER_TRANS_CACHE_OPERATOR";
    private static final String ID = "ID";
    private static final String IMMUTABLE_TYPE = "IMMUTABLE_TYPE";
    private static final String IMMUTABLE_PROP = "IMMUTABLE_PROP";
    private static final String CACHE_KEY = "CACHE_KEY";
    private static final String REASON = "REASON";
    private static final String INSERT = "insert into JIMMER_TRANS_CACHE_OPERATOR(IMMUTABLE_TYPE, IMMUTABLE_PROP, CACHE_KEY, REASON) values(?, ?, ?, ?)";
    private static final String SELECT_ID_PREFIX = "select ID from JIMMER_TRANS_CACHE_OPERATOR order by ID limit ";
    private static final String SELECT_PREFIX = "select ID, IMMUTABLE_TYPE, IMMUTABLE_PROP, CACHE_KEY, REASON from JIMMER_TRANS_CACHE_OPERATOR where ID in";
    private static final String DELETE_PREFIX = "delete from JIMMER_TRANS_CACHE_OPERATOR where ID in";
    private final ObjectMapper mapper;
    private final int batchSize;

    public TransactionCacheOperator() {
        this(null, 32);
    }

    public TransactionCacheOperator(int batchSize) {
        this(null, batchSize);
    }

    public TransactionCacheOperator(ObjectMapper mapper) {
        this(mapper, 32);
    }

    public TransactionCacheOperator(ObjectMapper mapper, int batchSize) {
        if (batchSize < 1) {
            throw new IllegalArgumentException("`batchSize` cannot be less than 1");
        }
        this.mapper = mapper != null ? mapper : new ObjectMapper().registerModule((Module)new JavaTimeModule()).registerModule((Module)new ImmutableModule());
        this.batchSize = batchSize;
    }

    @Override
    protected void onInitialize(JSqlClientImplementor sqlClient) {
        ConnectionManager connectionManager = sqlClient.getConnectionManager();
        if (connectionManager == null) {
            throw new IllegalArgumentException("The `sqlClient` must support connection manager");
        }
        connectionManager.execute(con -> {
            try {
                try (ResultSet rs = con.getMetaData().getTables(null, null, TABLE_NAME, null);){
                    if (rs.next()) {
                        Object var3_4 = null;
                        return var3_4;
                    }
                }
                rs = con.getMetaData().getTables(null, null, "jimmer_trans_cache_operator", null);
                try {
                    if (rs.next()) {
                        Object var3_6 = null;
                        return var3_6;
                    }
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
                try (Statement statement = con.createStatement();){
                    statement.execute(sqlClient.getDialect().transCacheOperatorTableDDL());
                    return null;
                }
            }
            catch (SQLException ex) {
                throw new ExecutionException("Cannot create table `JIMMER_TRANS_CACHE_OPERATOR`", ex);
            }
        });
    }

    @Override
    public void delete(LocatedCache<Object, ?> cache, Object key, Object reason) {
        if (reason != null && !(reason instanceof String)) {
            throw new IllegalArgumentException("The cache deletion reason can only be null or string when trigger type is `TRANSACTION_ONLY`");
        }
        this.save(cache.getType(), cache.getProp(), Collections.singleton(key), (String)reason);
    }

    @Override
    public void deleteAll(LocatedCache<Object, ?> cache, Collection<Object> keys, Object reason) {
        if (keys.isEmpty()) {
            return;
        }
        if (reason != null && !(reason instanceof String)) {
            throw new IllegalArgumentException("The cache deletion reason can only be null or string when trigger type is `TRANSACTION_ONLY`");
        }
        this.save(cache.getType(), cache.getProp(), keys, (String)reason);
    }

    private void save(ImmutableType type, ImmutableProp prop, Collection<Object> keys, String reason) {
        this.sqlClient().getConnectionManager().execute(con -> {
            try (PreparedStatement stmt = con.prepareStatement(INSERT);){
                for (Object key : keys) {
                    stmt.setString(1, type != null ? type.toString() : null);
                    stmt.setString(2, prop != null ? prop.toString() : null);
                    stmt.setString(3, this.mapper.writeValueAsString(key));
                    stmt.setString(4, reason);
                    stmt.addBatch();
                }
                stmt.executeBatch();
            }
            catch (JsonProcessingException | SQLException ex) {
                throw new ExecutionException("Failed to save delayed cache deletion", ex);
            }
            return null;
        });
    }

    public void flush() {
        for (int i = 0; i < 10 && this.sqlClient().getConnectionManager().execute(this::flush) >= this.batchSize; ++i) {
        }
    }

    private int flush(Connection con) {
        List<Long> ids = this.selectOperationIds(con);
        if (ids.isEmpty()) {
            return 0;
        }
        Map<MergedKey, Set<Object>> keyMap = this.getAndLockOperationKeyMap(ids, con);
        CacheOperator.suspending(() -> this.executeOperations(keyMap));
        this.deleteOperations(ids, con);
        return ids.size();
    }

    private List<Long> selectOperationIds(Connection con) {
        String sql = SELECT_ID_PREFIX + this.batchSize;
        ArrayList<Long> ids = new ArrayList<Long>();
        try (PreparedStatement stmt = con.prepareStatement(sql);
             ResultSet rs = stmt.executeQuery();){
            while (rs.next()) {
                ids.add(rs.getLong(1));
            }
        }
        catch (SQLException ex) {
            LOGGER.warn("Failed to flush transaction cache operator", (Throwable)ex);
        }
        return ids;
    }

    private Map<MergedKey, Set<Object>> getAndLockOperationKeyMap(Collection<Long> ids, Connection con) {
        StringBuilder builder = new StringBuilder();
        builder.append(SELECT_PREFIX).append('(');
        for (int i = ids.size(); i > 0; --i) {
            builder.append('?');
            if (i <= 1) continue;
            builder.append(", ");
        }
        builder.append(") for update");
        LinkedHashMap<MergedKey, Set<Object>> keyMap = new LinkedHashMap<MergedKey, Set<Object>>();
        try (PreparedStatement stmt = con.prepareStatement(builder.toString());){
            int index = 0;
            for (Long id : ids) {
                stmt.setLong(++index, id);
            }
            try (ResultSet rs = stmt.executeQuery();){
                while (rs.next()) {
                    ImmutableType type = TransactionCacheOperator.typeFromString(rs.getString(2));
                    ImmutableProp prop = TransactionCacheOperator.propFromString(rs.getString(3));
                    String json = rs.getString(4);
                    Object key = this.mapper.readValue(json, type != null ? type.getIdProp().getElementClass() : prop.getDeclaringType().getIdProp().getElementClass());
                    String reason = rs.getString(5);
                    keyMap.computeIfAbsent(new MergedKey(type, prop, reason), it -> new LinkedHashSet()).add(key);
                }
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Failed to flush transaction cache operator", (Throwable)ex);
        }
        return keyMap;
    }

    private void executeOperations(Map<MergedKey, Set<Object>> keyMap) {
        for (Map.Entry<MergedKey, Set<Object>> e : keyMap.entrySet()) {
            ImmutableType type = e.getKey().type;
            Cache cache = type != null ? this.sqlClient().getCaches().getObjectCache(type) : this.sqlClient().getCaches().getPropertyCache(e.getKey().prop);
            String reason = e.getKey().reason;
            Set<Object> keys = e.getValue();
            if (keys.size() == 1) {
                cache.delete(keys.iterator().next(), reason);
                continue;
            }
            cache.deleteAll(keys, reason);
        }
    }

    private void deleteOperations(Collection<Long> ids, Connection con) {
        StringBuilder builder = new StringBuilder();
        builder.append(DELETE_PREFIX).append('(');
        for (int i = ids.size(); i > 0; --i) {
            builder.append('?');
            if (i <= 1) continue;
            builder.append(", ");
        }
        builder.append(')');
        try (PreparedStatement stmt = con.prepareStatement(builder.toString());){
            int index = 0;
            for (Long id : ids) {
                stmt.setLong(++index, id);
            }
            stmt.executeUpdate();
        }
        catch (Exception ex) {
            LOGGER.warn("Failed to delete transaction cache operations", (Throwable)ex);
        }
    }

    private static ImmutableType typeFromString(String typeName) throws Exception {
        if (typeName == null) {
            return null;
        }
        Class<?> javaClass = Class.forName(typeName, true, Thread.currentThread().getContextClassLoader());
        return ImmutableType.get(javaClass);
    }

    private static ImmutableProp propFromString(String propPath) throws Exception {
        if (propPath == null) {
            return null;
        }
        int lastDotIndex = propPath.lastIndexOf(46);
        if (lastDotIndex == -1) {
            throw new IllegalArgumentException("Illegal property path \"" + propPath + "\"");
        }
        return TransactionCacheOperator.typeFromString(propPath.substring(0, lastDotIndex)).getProp(propPath.substring(lastDotIndex + 1));
    }

    private static class MergedKey {
        final ImmutableType type;
        final ImmutableProp prop;
        final String reason;

        private MergedKey(ImmutableType type, ImmutableProp prop, String reason) {
            this.type = type;
            this.prop = prop;
            this.reason = reason;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MergedKey mergedKey = (MergedKey)o;
            return Objects.equals(this.type, mergedKey.type) && Objects.equals(this.prop, mergedKey.prop) && Objects.equals(this.reason, mergedKey.reason);
        }

        public int hashCode() {
            return Objects.hash(this.type, this.prop, this.reason);
        }

        public String toString() {
            return "MergedKey{type=" + this.type + ", prop=" + this.prop + ", reason=" + this.reason + '}';
        }
    }
}

