/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.mutation.save;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.meta.PropId;
import org.babyfish.jimmer.meta.TargetLevel;
import org.babyfish.jimmer.runtime.DraftSpi;
import org.babyfish.jimmer.runtime.Internal;
import org.babyfish.jimmer.sql.ast.Predicate;
import org.babyfish.jimmer.sql.ast.impl.mutation.save.Batch;
import org.babyfish.jimmer.sql.ast.impl.mutation.save.MutationTrigger;
import org.babyfish.jimmer.sql.ast.impl.mutation.save.PreHandler;
import org.babyfish.jimmer.sql.ast.impl.mutation.save.SaveContext;
import org.babyfish.jimmer.sql.ast.impl.query.FilterLevel;
import org.babyfish.jimmer.sql.ast.impl.query.MutableRootQueryImpl;
import org.babyfish.jimmer.sql.ast.impl.table.TableImplementor;
import org.babyfish.jimmer.sql.meta.JoinTemplate;
import org.babyfish.jimmer.sql.meta.MiddleTable;
import org.babyfish.jimmer.sql.runtime.ExecutionPurpose;

class Saver {
    private final SaveContext ctx;

    public Saver(SaveContext ctx) {
        this.ctx = ctx;
    }

    public <E> void saveAll(Collection<E> entities) {
        if (entities.isEmpty()) {
            return;
        }
        ImmutableType immutableType = ImmutableType.get(entities.iterator().next().getClass());
        MutationTrigger trigger = this.ctx.trigger;
        List newEntities = Internal.produceList((ImmutableType)immutableType, entities, drafts -> this.saveAllImpl((List<DraftSpi>)drafts), trigger == null ? null : trigger::prepareSubmit);
        if (trigger != null) {
            trigger.submit(this.ctx.options.getSqlClient(), this.ctx.con);
        }
    }

    private void saveAllImpl(List<DraftSpi> drafts) {
        PreHandler preHandler = PreHandler.of(this.ctx);
        for (DraftSpi draftSpi : drafts) {
            preHandler.add(draftSpi);
        }
        for (Batch batch : preHandler.batches()) {
            for (ImmutableProp prop : batch.shape().getGetterMap().keySet()) {
                if (!prop.isAssociation(TargetLevel.ENTITY) || !prop.isColumnDefinition()) continue;
                this.savePreAssociation(prop, batch);
            }
        }
        this.saveSelf(preHandler);
        for (Batch batch : preHandler.batches()) {
            for (ImmutableProp prop : batch.shape().getGetterMap().keySet()) {
                if (!prop.isAssociation(TargetLevel.ENTITY) || prop.isColumnDefinition()) continue;
                this.savePostAssociation(prop, batch);
            }
        }
    }

    private void savePreAssociation(ImmutableProp prop, Batch<DraftSpi> batch) {
        if (!batch.shape().getIdGetters().isEmpty() && batch.shape().getGetterMap().size() == 1) {
            if (!this.ctx.options.isAutoCheckingProp(prop)) {
                return;
            }
            HashSet<Object> targetIds = new HashSet<Object>();
            PropId targetIdPropId = prop.getTargetType().getIdProp().getId();
            for (DraftSpi draft : batch.entities()) {
                Object targetId = draft.__get(targetIdPropId);
                if (targetId == null) continue;
                targetIds.add(targetId);
            }
            MutableRootQueryImpl q = new MutableRootQueryImpl(this.ctx.options.getSqlClient(), this.ctx.path.getType(), ExecutionPurpose.MUTATE, FilterLevel.DEFAULT);
            TableImplementor<?> table = q.getTableImplementor();
            q.where(new Predicate[]{table.getId().in(targetIds)});
            List actualTargetIds = (List)q.select(table.getId()).execute(this.ctx.con);
            if (actualTargetIds.size() < targetIds.size()) {
                actualTargetIds.forEach(targetIds::remove);
                this.ctx.to(prop).throwIllegalTargetIds(targetIds);
            }
            return;
        }
        Saver targetSaver = new Saver(this.ctx.to(prop));
        ArrayList<DraftSpi> targets = new ArrayList<DraftSpi>(batch.entities().size());
        PropId targetPropId = prop.getId();
        for (DraftSpi draft : batch.entities()) {
            DraftSpi target = (DraftSpi)draft.__get(targetPropId);
            if (target == null) continue;
            targets.add(target);
        }
        targetSaver.saveAll(targets);
    }

    private void savePostAssociation(ImmutableProp prop, Batch<DraftSpi> batch) {
        if (this.isReadOnlyMiddleTable(prop)) {
            this.ctx.throwReadonlyMiddleTable();
        }
        if (prop.isRemote() && prop.getMappedBy() != null) {
            this.ctx.throwReversedRemoteAssociation();
        }
        if (prop.getSqlTemplate() instanceof JoinTemplate) {
            this.ctx.throwUnstructuredAssociation();
        }
        Saver targetSaver = new Saver(this.ctx.to(prop));
        ArrayList<DraftSpi> targets = new ArrayList<DraftSpi>(batch.entities().size());
        PropId targetPropId = prop.getId();
        for (DraftSpi draft : batch.entities()) {
            Object value = draft.__get(targetPropId);
            if (value instanceof List) {
                targets.addAll((List)value);
                continue;
            }
            if (value == null) continue;
            targets.add((DraftSpi)value);
        }
        targetSaver.saveAll(targets);
    }

    private void saveSelf(PreHandler preHandler) {
    }

    private boolean isReadOnlyMiddleTable(ImmutableProp prop) {
        ImmutableProp mappedBy = prop.getMappedBy();
        if (mappedBy != null) {
            prop = mappedBy;
        }
        if (prop.isMiddleTableDefinition()) {
            MiddleTable middleTable = (MiddleTable)prop.getStorage(this.ctx.options.getSqlClient().getMetadataStrategy());
            return middleTable.isReadonly();
        }
        return false;
    }
}

