/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.mutation.save;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import org.babyfish.jimmer.ImmutableObjects;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.runtime.DraftContext;
import org.babyfish.jimmer.sql.JSqlClient;
import org.babyfish.jimmer.sql.event.Triggers;

class MutationTrigger {
    private final List<ChangedData> changedList = new ArrayList<ChangedData>();

    MutationTrigger() {
    }

    public void modifyEntityTable(Object oldEntity, Object newEntity) {
        this.changedList.add(new EntityChangedData(oldEntity, newEntity));
    }

    public void insertMiddleTable(ImmutableProp prop, Object sourceId, Object targetId) {
        this.changedList.add(new AssociationChangedData(prop, sourceId, null, targetId));
    }

    public void deleteMiddleTable(ImmutableProp prop, Object sourceId, Object targetId) {
        this.changedList.add(new AssociationChangedData(prop, sourceId, targetId, null));
    }

    public void prepareSubmit(DraftContext ctx) {
        if (!this.changedList.isEmpty()) {
            for (ChangedData changedData : this.changedList) {
                ChangedData data;
                if (changedData instanceof EntityChangedData) {
                    data = (EntityChangedData)changedData;
                    data.newEntity = ctx.resolveObject(data.newEntity);
                }
                if (!(changedData instanceof AssociationChangedData)) continue;
                data = (AssociationChangedData)changedData;
                ((AssociationChangedData)data).sourceId = ctx.resolveObject(((AssociationChangedData)data).sourceId);
                ((AssociationChangedData)data).detachedTargetId = ctx.resolveObject(((AssociationChangedData)data).detachedTargetId);
                ((AssociationChangedData)data).attachedTargetId = ctx.resolveObject(((AssociationChangedData)data).attachedTargetId);
            }
        }
    }

    public void submit(JSqlClient sqlClient, Connection con) {
        if (!this.changedList.isEmpty()) {
            Triggers triggers = sqlClient.getTriggers(true);
            for (ChangedData changedData : this.changedList) {
                ChangedData data;
                if (changedData instanceof EntityChangedData) {
                    data = (EntityChangedData)changedData;
                    triggers.fireEntityTableChange(data.oldEntity, ImmutableObjects.toLonely((Object)data.newEntity), con);
                    continue;
                }
                data = (AssociationChangedData)changedData;
                if (((AssociationChangedData)data).detachedTargetId == null) {
                    triggers.fireMiddleTableInsert(((AssociationChangedData)data).prop, ((AssociationChangedData)data).sourceId, ((AssociationChangedData)data).attachedTargetId, con);
                    continue;
                }
                triggers.fireMiddleTableDelete(((AssociationChangedData)data).prop, ((AssociationChangedData)data).sourceId, ((AssociationChangedData)data).detachedTargetId, con);
            }
        }
    }

    private static class EntityChangedData
    implements ChangedData {
        final Object oldEntity;
        Object newEntity;

        private EntityChangedData(Object oldEntity, Object newEntity) {
            this.oldEntity = oldEntity;
            this.newEntity = newEntity;
        }

        public String toString() {
            return "ChangedEntity{oldEntity=" + this.oldEntity + ", newEntity=" + this.newEntity + '}';
        }
    }

    private static class AssociationChangedData
    implements ChangedData {
        final ImmutableProp prop;
        Object sourceId;
        Object detachedTargetId;
        Object attachedTargetId;

        private AssociationChangedData(ImmutableProp prop, Object sourceId, Object detachedTargetId, Object attachedTargetId) {
            this.prop = prop;
            this.sourceId = sourceId;
            this.detachedTargetId = detachedTargetId;
            this.attachedTargetId = attachedTargetId;
        }

        public String toString() {
            return "ChangedAssociation{prop=" + this.prop + ", sourceId=" + this.sourceId + ", detachedTargetId=" + this.detachedTargetId + ", attachedTargetId=" + this.attachedTargetId + '}';
        }
    }

    private static interface ChangedData {
    }
}

