/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.mutation.save;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.LogicalDeletedInfo;
import org.babyfish.jimmer.sql.association.meta.AssociationType;
import org.babyfish.jimmer.sql.ast.impl.AstContext;
import org.babyfish.jimmer.sql.ast.impl.mutation.save.AbstractOperator;
import org.babyfish.jimmer.sql.ast.impl.mutation.save.ExclusiveIdPairPredicates;
import org.babyfish.jimmer.sql.ast.impl.mutation.save.IdPairs;
import org.babyfish.jimmer.sql.ast.impl.mutation.save.MutationTrigger;
import org.babyfish.jimmer.sql.ast.impl.mutation.save.SaveContext;
import org.babyfish.jimmer.sql.ast.impl.render.AbstractSqlBuilder;
import org.babyfish.jimmer.sql.ast.impl.render.BatchSqlBuilder;
import org.babyfish.jimmer.sql.ast.impl.render.ComparisonPredicates;
import org.babyfish.jimmer.sql.ast.impl.value.ValueGetter;
import org.babyfish.jimmer.sql.ast.tuple.Tuple2;
import org.babyfish.jimmer.sql.ast.tuple.Tuple3;
import org.babyfish.jimmer.sql.dialect.Dialect;
import org.babyfish.jimmer.sql.meta.JoinTableFilterInfo;
import org.babyfish.jimmer.sql.meta.MetadataStrategy;
import org.babyfish.jimmer.sql.meta.MiddleTable;
import org.babyfish.jimmer.sql.runtime.ExecutionPurpose;
import org.babyfish.jimmer.sql.runtime.Executor;
import org.babyfish.jimmer.sql.runtime.Reader;
import org.babyfish.jimmer.sql.runtime.SqlBuilder;

class MiddleTableOperator
extends AbstractOperator {
    private final ImmutableProp prop;
    private final MutationTrigger trigger;
    private final MiddleTable middleTable;
    private final List<ValueGetter> sourceGetters;
    private final List<ValueGetter> targetGetters;
    private final List<ValueGetter> getters;

    MiddleTableOperator(SaveContext ctx) {
        super(ctx.options.getSqlClient(), ctx.con);
        MiddleTable mt;
        ImmutableProp prop = ctx.path.getProp();
        MetadataStrategy strategy = ctx.options.getSqlClient().getMetadataStrategy();
        if (prop.getMappedBy() != null) {
            mt = (MiddleTable)prop.getMappedBy().getStorage(strategy);
            mt = mt.getInverse();
        } else {
            mt = (MiddleTable)prop.getStorage(strategy);
        }
        this.prop = prop;
        this.trigger = ctx.trigger;
        this.middleTable = mt;
        AssociationType associationType = AssociationType.of(prop);
        this.sourceGetters = ValueGetter.valueGetters(this.sqlClient, associationType.getSourceProp());
        this.targetGetters = ValueGetter.valueGetters(this.sqlClient, associationType.getTargetProp());
        this.getters = ValueGetter.tupleGetters(this.sourceGetters, this.targetGetters);
    }

    public int append(IdPairs idPairs) {
        int rowCount = this.connect(idPairs);
        MutationTrigger trigger = this.trigger;
        if (trigger != null) {
            for (Tuple2<Object, Object> idTuple : idPairs.tuples()) {
                trigger.insertMiddleTable(this.prop, idTuple.get_1(), idTuple.get_2());
            }
        }
        return rowCount;
    }

    public int merge(IdPairs idPairs) {
        if (this.isUpsertUsed()) {
            int[] rowCounts = this.connectIfNecessary(idPairs);
            int sumRowCount = 0;
            int index = 0;
            MutationTrigger trigger = this.trigger;
            for (Tuple2<Object, Object> idTuple : idPairs.tuples()) {
                if (rowCounts[index++] == 0) continue;
                ++sumRowCount;
                if (trigger == null) continue;
                trigger.insertMiddleTable(this.prop, idTuple.get_1(), idTuple.get_2());
            }
            return sumRowCount;
        }
        LinkedHashSet<Object> sourceIds = new LinkedHashSet<Object>();
        for (Tuple2<Object, Object> idTuple : idPairs.tuples()) {
            sourceIds.add(idTuple.get_1());
        }
        Set<Tuple2<Object, Object>> existingIdTuples = this.find(sourceIds);
        ArrayList<Tuple2<Object, Object>> insertingIdTuples = new ArrayList<Tuple2<Object, Object>>(idPairs.tuples().size() - existingIdTuples.size());
        for (Tuple2<Object, Object> idTuple : idPairs.tuples()) {
            if (existingIdTuples.contains(idTuple)) continue;
            insertingIdTuples.add(idTuple);
        }
        return this.append(IdPairs.of(insertingIdTuples));
    }

    public int replace(IdPairs idPairs) {
        MutationTrigger trigger = this.trigger;
        if (trigger == null && this.isUpsertUsed()) {
            int[] rowCounts;
            int sumRowCount = this.disconnectExcept(idPairs);
            for (int rowCount : rowCounts = this.connectIfNecessary(idPairs)) {
                if (rowCount == 0) continue;
                sumRowCount += rowCount;
            }
            return sumRowCount;
        }
        Collection<Tuple2<Object, Object>> idTuples = idPairs.tuples();
        if (!(idTuples instanceof Set)) {
            idTuples = new LinkedHashSet<Tuple2<Object, Object>>(idTuples);
        }
        LinkedHashSet<Object> sourceIds = new LinkedHashSet<Object>();
        for (Tuple2<Object, Object> idTuple : idTuples) {
            sourceIds.add(idTuple.get_1());
        }
        Set<Tuple2<Object, Object>> existingIdTuples = this.find(sourceIds);
        ArrayList<Tuple2<Object, Object>> insertingIdTuples = new ArrayList<Tuple2<Object, Object>>(idTuples.size() - existingIdTuples.size());
        ArrayList<Tuple2<Object, Object>> deletingIdTuples = new ArrayList<Tuple2<Object, Object>>();
        for (Tuple2<Object, Object> idTuple : idTuples) {
            if (existingIdTuples.contains(idTuple)) continue;
            insertingIdTuples.add(idTuple);
        }
        for (Tuple2<Object, Object> existingIdTuple : existingIdTuples) {
            if (idTuples.contains(existingIdTuple)) continue;
            deletingIdTuples.add(existingIdTuple);
        }
        int rowCount = this.disconnect(IdPairs.of(deletingIdTuples)) + this.connect(IdPairs.of(insertingIdTuples));
        if (trigger != null) {
            for (Tuple2 tuple2 : insertingIdTuples) {
                trigger.insertMiddleTable(this.prop, tuple2.get_1(), tuple2.get_2());
            }
            for (Tuple2 tuple2 : deletingIdTuples) {
                trigger.deleteMiddleTable(this.prop, tuple2.get_1(), tuple2.get_2());
            }
        }
        return rowCount;
    }

    Set<Tuple2<Object, Object>> find(Collection<Object> ids) {
        SqlBuilder builder = new SqlBuilder(new AstContext(this.sqlClient));
        builder.enter(AbstractSqlBuilder.ScopeType.SELECT);
        for (ValueGetter getter : this.getters) {
            ((SqlBuilder)builder.separator()).sql(getter);
        }
        builder.leave();
        ((SqlBuilder)((SqlBuilder)builder.sql(" from ")).sql(this.middleTable.getTableName())).enter(AbstractSqlBuilder.ScopeType.WHERE);
        ComparisonPredicates.renderIn(false, this.sourceGetters, ids, builder);
        this.addLogicalDeletedPredicate(builder);
        this.addFilterPredicate(builder);
        builder.leave();
        Tuple3<String, List<Object>, List<Integer>> tuple = builder.build();
        Reader<?> sourceIdReader = this.sqlClient.getReader(this.prop.getDeclaringType().getIdProp());
        Reader<?> targetIdReader = this.sqlClient.getReader(this.prop.getTargetType().getIdProp());
        return this.sqlClient.getExecutor().execute(new Executor.Args<Set>(this.sqlClient, this.con, tuple.get_1(), tuple.get_2(), tuple.get_3(), ExecutionPurpose.QUERY, null, stmt -> {
            Reader.Context ctx = new Reader.Context(null, this.sqlClient);
            LinkedHashSet idTuples = new LinkedHashSet();
            try (ResultSet rs = stmt.executeQuery();){
                while (rs.next()) {
                    ctx.resetCol();
                    Object sourceId = sourceIdReader.read(rs, ctx);
                    Object targetId = targetIdReader.read(rs, ctx);
                    idTuples.add(new Tuple2(sourceId, targetId));
                }
            }
            return idTuples;
        }));
    }

    int connect(IdPairs idPairs) {
        BatchSqlBuilder builder = new BatchSqlBuilder(this.sqlClient);
        ((BatchSqlBuilder)((BatchSqlBuilder)builder.sql("insert into ")).sql(this.middleTable.getTableName())).enter(AbstractSqlBuilder.ScopeType.TUPLE);
        this.appendColumns(builder);
        builder.leave();
        ((BatchSqlBuilder)builder.sql(" values")).enter(AbstractSqlBuilder.ScopeType.TUPLE);
        this.appendValues(builder);
        builder.leave();
        return this.execute(builder, idPairs.tuples());
    }

    int[] connectIfNecessary(IdPairs idPairs) {
        BatchSqlBuilder builder = new BatchSqlBuilder(this.sqlClient);
        this.sqlClient.getDialect().upsert(new UpsertContextImpl(builder));
        return this.executeImpl(builder, idPairs.tuples());
    }

    int disconnect(IdPairs idPairs) {
        BatchSqlBuilder builder = new BatchSqlBuilder(this.sqlClient);
        ((BatchSqlBuilder)((BatchSqlBuilder)builder.sql("delete from ")).sql(this.middleTable.getTableName())).enter(AbstractSqlBuilder.ScopeType.WHERE);
        for (ValueGetter getter : this.getters) {
            ((BatchSqlBuilder)((BatchSqlBuilder)((BatchSqlBuilder)builder.separator()).sql(getter)).sql(" = ")).variable(getter);
        }
        builder.leave();
        return this.execute(builder, idPairs.tuples());
    }

    int disconnectExcept(IdPairs idPairs) {
        if (idPairs.entries().size() < 2) {
            Tuple2<Object, Collection<Object>> idTuple = idPairs.entries().iterator().next();
            return this.disconnectExceptBySimpleInPredicate(idTuple.get_1(), idTuple.get_2());
        }
        if (this.targetGetters.size() == 1 && this.sqlClient.getDialect().isAnyEqualityOfArraySupported()) {
            return this.disconnectExceptByBatch(idPairs);
        }
        return this.disconnectExceptByComplexInPredicate(idPairs);
    }

    private int disconnectExceptByBatch(IdPairs idPairs) {
        BatchSqlBuilder builder = new BatchSqlBuilder(this.sqlClient);
        ((BatchSqlBuilder)builder.sql("delete from ")).sql(this.middleTable.getTableName());
        builder.enter(AbstractSqlBuilder.ScopeType.WHERE);
        ExclusiveIdPairPredicates.addPredicates(builder, this.sourceGetters, this.targetGetters);
        this.addLogicalDeletedPredicate(builder);
        this.addFilterPredicate(builder);
        builder.leave();
        return this.execute(builder, idPairs.entries());
    }

    private int disconnectExceptBySimpleInPredicate(Object sourceId, Collection<Object> targetIds) {
        AstContext astContext = new AstContext(this.sqlClient);
        SqlBuilder builder = new SqlBuilder(astContext);
        ((SqlBuilder)builder.sql("delete from ")).sql(this.middleTable.getTableName());
        builder.enter(AbstractSqlBuilder.ScopeType.WHERE);
        ExclusiveIdPairPredicates.addPredicates(builder, this.sourceGetters, this.targetGetters, sourceId, targetIds);
        this.addLogicalDeletedPredicate(builder);
        this.addFilterPredicate(builder);
        builder.leave();
        return this.execute(builder);
    }

    private int disconnectExceptByComplexInPredicate(IdPairs idPairs) {
        SqlBuilder builder = new SqlBuilder(new AstContext(this.sqlClient));
        Collection<Object> sourceIds = Tuple2.projection1(idPairs.entries());
        ((SqlBuilder)builder.sql("delete from ")).sql(this.middleTable.getTableName());
        builder.enter(AbstractSqlBuilder.ScopeType.WHERE);
        ExclusiveIdPairPredicates.addPredicates(builder, this.sourceGetters, this.targetGetters, idPairs);
        this.addLogicalDeletedPredicate(builder);
        this.addFilterPredicate(builder);
        builder.leave();
        return this.execute(builder);
    }

    private void addLogicalDeletedPredicate(AbstractSqlBuilder<?> builder) {
        LogicalDeletedInfo logicalDeletedInfo = this.middleTable.getLogicalDeletedInfo();
        if (logicalDeletedInfo == null) {
            return;
        }
        builder.separator();
        LogicalDeletedInfo.Action action = logicalDeletedInfo.getAction();
        if (action instanceof LogicalDeletedInfo.Action.Eq) {
            LogicalDeletedInfo.Action.Eq eq = (LogicalDeletedInfo.Action.Eq)action;
            ((AbstractSqlBuilder)((AbstractSqlBuilder)builder.sql(logicalDeletedInfo.getColumnName())).sql(" = ")).rawVariable(eq.getValue());
        } else if (action instanceof LogicalDeletedInfo.Action.Ne) {
            LogicalDeletedInfo.Action.Ne ne = (LogicalDeletedInfo.Action.Ne)action;
            ((AbstractSqlBuilder)((AbstractSqlBuilder)builder.sql(logicalDeletedInfo.getColumnName())).sql(" <> ")).rawVariable(ne.getValue());
        } else if (action instanceof LogicalDeletedInfo.Action.IsNull) {
            ((AbstractSqlBuilder)builder.sql(logicalDeletedInfo.getColumnName())).sql(" is null");
        } else if (action instanceof LogicalDeletedInfo.Action.IsNotNull) {
            ((AbstractSqlBuilder)builder.sql(logicalDeletedInfo.getColumnName())).sql(" is not null");
        }
    }

    private void addFilterPredicate(AbstractSqlBuilder<?> builder) {
        JoinTableFilterInfo filterInfo = this.middleTable.getFilterInfo();
        if (filterInfo == null) {
            return;
        }
        ((AbstractSqlBuilder)builder.separator()).sql(filterInfo.getColumnName());
        if (filterInfo.getValues().size() == 1) {
            ((AbstractSqlBuilder)builder.sql(" = ")).rawVariable(filterInfo.getValues().get(0));
        } else {
            ((AbstractSqlBuilder)builder.sql(" in ")).enter(AbstractSqlBuilder.ScopeType.LIST);
            for (Object value : filterInfo.getValues()) {
                ((AbstractSqlBuilder)builder.separator()).rawVariable(value);
            }
            builder.leave();
        }
    }

    private void appendColumns(BatchSqlBuilder builder) {
        for (ValueGetter getter : this.getters) {
            ((BatchSqlBuilder)builder.separator()).sql(getter);
        }
        if (this.middleTable.getLogicalDeletedInfo() != null) {
            ((BatchSqlBuilder)builder.separator()).sql(this.middleTable.getLogicalDeletedInfo().getColumnName());
        }
        if (this.middleTable.getFilterInfo() != null) {
            ((BatchSqlBuilder)builder.separator()).sql(this.middleTable.getFilterInfo().getColumnName());
        }
    }

    private void appendValues(BatchSqlBuilder builder) {
        for (ValueGetter getter : this.getters) {
            ((BatchSqlBuilder)builder.separator()).variable(getter);
        }
        if (this.middleTable.getLogicalDeletedInfo() != null) {
            ((BatchSqlBuilder)builder.separator()).rawVariable(this.middleTable.getLogicalDeletedInfo().allocateInitializedValue());
        }
        if (this.middleTable.getFilterInfo() != null) {
            ((BatchSqlBuilder)builder.separator()).rawVariable(this.middleTable.getFilterInfo().getValues().get(0));
        }
    }

    private boolean isUpsertUsed() {
        Dialect dialect = this.sqlClient.getDialect();
        return dialect.isUpsertSupported() && !dialect.isAffectCountOfInsertIgnoreWrong();
    }

    private class UpsertContextImpl
    implements Dialect.UpsertContext {
        private final BatchSqlBuilder builder;

        UpsertContextImpl(BatchSqlBuilder builder) {
            this.builder = builder;
        }

        @Override
        public boolean hasUpdatedColumns() {
            return false;
        }

        @Override
        public boolean hasOptimisticLock() {
            return false;
        }

        @Override
        public Dialect.UpsertContext sql(String sql) {
            this.builder.sql(sql);
            return this;
        }

        @Override
        public Dialect.UpsertContext appendTableName() {
            this.builder.sql(MiddleTableOperator.this.middleTable.getTableName());
            return this;
        }

        @Override
        public Dialect.UpsertContext appendInsertedColumns() {
            this.builder.enter(AbstractSqlBuilder.ScopeType.COMMA);
            MiddleTableOperator.this.appendColumns(this.builder);
            this.builder.leave();
            return this;
        }

        @Override
        public Dialect.UpsertContext appendConflictColumns() {
            this.builder.enter(AbstractSqlBuilder.ScopeType.COMMA);
            MiddleTableOperator.this.appendColumns(this.builder);
            this.builder.leave();
            return this;
        }

        @Override
        public Dialect.UpsertContext appendInsertingValues() {
            this.builder.enter(AbstractSqlBuilder.ScopeType.COMMA);
            MiddleTableOperator.this.appendValues(this.builder);
            this.builder.leave();
            return this;
        }

        @Override
        public Dialect.UpsertContext appendUpdatingAssignments(String prefix, String suffix) {
            return this;
        }

        @Override
        public Dialect.UpsertContext appendOptimisticLockCondition() {
            return this;
        }
    }
}

