/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.cache.spi;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.StringWriter;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.sql.cache.SerializationException;
import org.babyfish.jimmer.sql.cache.chain.SimpleBinder;
import org.babyfish.jimmer.sql.cache.spi.AbstractRemoteBinder;

public abstract class AbstractRemoteHashBinder<K, V>
extends AbstractRemoteBinder<K, V>
implements SimpleBinder.Parameterized<K, V> {
    protected AbstractRemoteHashBinder(ObjectMapper objectMapper, ImmutableType type, ImmutableProp prop, Duration duration, int randomPercent) {
        super(objectMapper, type, prop, duration, randomPercent);
    }

    @Override
    public final Map<K, V> getAll(Collection<K> keys) {
        return this.getAll(keys, Collections.emptySortedMap());
    }

    @Override
    public final void setAll(Map<K, V> map) {
        this.setAll(map, Collections.emptySortedMap());
    }

    @Override
    public final Map<K, V> getAll(Collection<K> keys, SortedMap<String, Object> parameterMap) {
        List<String> redisKeys = this.redisKeys(keys);
        String hashKey = this.hashKey(parameterMap);
        List<byte[]> values = this.read(redisKeys, hashKey);
        return this.valueSerializer.deserialize(keys, values);
    }

    @Override
    public final void setAll(Map<K, V> map, SortedMap<String, Object> parameterMap) {
        Map<String, byte[]> convertedMap = this.valueSerializer.serialize(map, this::redisKey);
        String hashKey = this.hashKey(parameterMap);
        this.write(convertedMap, hashKey);
    }

    protected abstract List<byte[]> read(Collection<String> var1, String var2);

    protected abstract void write(Map<String, byte[]> var1, String var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String hashKey(SortedMap<String, Object> parameterMap) {
        String string;
        StringWriter writer = new StringWriter();
        try {
            writer.write("{");
            boolean addComma = false;
            for (Map.Entry<String, Object> e : parameterMap.entrySet()) {
                if (addComma) {
                    writer.write(",");
                } else {
                    addComma = true;
                }
                writer.write("\"");
                writer.write(e.getKey());
                writer.write("\":");
                writer.write(this.objectMapper.writeValueAsString(e.getValue()));
            }
            writer.write("}");
            writer.flush();
            string = writer.toString();
        }
        catch (Throwable throwable) {
            try {
                writer.close();
                throw throwable;
            }
            catch (IOException ex) {
                throw new SerializationException(ex);
            }
        }
        writer.close();
        return string;
    }
}

