/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.cache.spi;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.time.Duration;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import org.babyfish.jimmer.jackson.ImmutableModule;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.sql.cache.ValueSerializer;

abstract class AbstractRemoteBinder<K, V> {
    final ObjectMapper objectMapper;
    private final String keyPrefix;
    private final long minMills;
    private final long maxMillis;
    final ValueSerializer<V> valueSerializer;

    AbstractRemoteBinder(ObjectMapper objectMapper, ImmutableType type, ImmutableProp prop, Duration duration, int randomPercent) {
        if (objectMapper != null) {
            if (!objectMapper.getRegisteredModuleIds().contains(ImmutableModule.MODULE_ID)) {
                throw new IllegalArgumentException("There is no ImmutableModule in object mapper");
            }
        } else {
            objectMapper = new ObjectMapper().registerModule((Module)new ImmutableModule()).registerModule((Module)new JavaTimeModule());
        }
        this.objectMapper = objectMapper;
        if (type == null == (prop == null)) {
            throw new IllegalArgumentException("The nullity of type and prop cannot be same");
        }
        if (randomPercent < 0 || randomPercent > 99) {
            throw new IllegalArgumentException("randomPercent must between 0 and 99");
        }
        this.keyPrefix = type != null ? this.getKeyPrefix(type) : this.getKeyPrefix(prop);
        long millis = duration.toMillis();
        this.minMills = millis - (long)randomPercent * millis / 100L;
        this.maxMillis = millis + (long)randomPercent * millis / 100L;
        this.valueSerializer = type != null ? new ValueSerializer(type, objectMapper) : new ValueSerializer(prop, objectMapper);
    }

    protected String getKeyPrefix(ImmutableType type) {
        return type.getJavaClass().getSimpleName() + '-';
    }

    protected String getKeyPrefix(ImmutableProp prop) {
        return prop.getDeclaringType().getJavaClass().getSimpleName() + '.' + prop.getName() + '-';
    }

    protected long nextExpireMillis() {
        return ThreadLocalRandom.current().nextLong(this.minMills, this.maxMillis);
    }

    public final void deleteAll(Collection<K> keys, Object reason) {
        if (reason == null || reason.equals(this.reason())) {
            List<String> redisKeys = this.redisKeys(keys);
            this.delete(redisKeys);
        }
    }

    protected abstract void delete(Collection<String> var1);

    protected abstract String reason();

    String redisKey(K key) {
        return this.keyPrefix + key;
    }

    List<String> redisKeys(Collection<K> keys) {
        if (!(keys instanceof Set)) {
            keys = new LinkedHashSet<K>(keys);
        }
        return keys.stream().map(this::redisKey).collect(Collectors.toList());
    }
}

