/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.cache;

import java.util.HashSet;
import java.util.Set;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.meta.TypedProp;
import org.babyfish.jimmer.sql.ast.table.Table;

public class CacheDisableConfig {
    private boolean disableAll;
    private final Set<ImmutableType> disabledTypes = new HashSet<ImmutableType>();
    private final Set<ImmutableProp> disabledProps = new HashSet<ImmutableProp>();

    public void disableAll() {
        this.disableAll = true;
    }

    public void disable(Class<?> entityType) {
        this.disabledTypes.add(ImmutableType.get(entityType));
    }

    public void disable(ImmutableType type) {
        this.disabledTypes.add(type);
    }

    public <ST extends Table<?>> void disable(TypedProp<?, ?> prop) {
        this.disabledProps.add(prop.unwrap());
    }

    public void disable(ImmutableProp prop) {
        this.disabledProps.add(prop);
    }

    boolean isDisableAll() {
        return this.disableAll;
    }

    Set<ImmutableType> getDisabledTypes() {
        return this.disabledTypes;
    }

    Set<ImmutableProp> getDisabledProps() {
        return this.disabledProps;
    }
}

