/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.mutation;

import java.util.Collections;
import java.util.List;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.sql.ast.PropExpression;
import org.babyfish.jimmer.sql.ast.impl.mutation.MutationItem;
import org.babyfish.jimmer.sql.ast.table.Table;
import org.babyfish.jimmer.sql.meta.MetadataStrategy;
import org.babyfish.jimmer.sql.meta.SingleColumn;

class SingleMutationImpl
implements MutationItem {
    private final ImmutableProp prop;
    private final Object value;

    SingleMutationImpl(ImmutableProp prop, Object value) {
        this.prop = prop;
        this.value = value;
    }

    @Override
    public ImmutableProp getProp() {
        return this.prop;
    }

    @Override
    public List<ImmutableProp> getProps() {
        return Collections.singletonList(this.prop);
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public String columnName(MetadataStrategy strategy) {
        return ((SingleColumn)this.prop.getStorage(strategy)).getName();
    }

    @Override
    public PropExpression<Object> expression(Table<?> table) {
        return table.get(this.prop);
    }

    public String toString() {
        return "SingleMutationImpl{prop=" + this.prop + ", value=" + this.value + '}';
    }
}

