/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.mutation;

import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.babyfish.jimmer.runtime.ImmutableSpi;
import org.babyfish.jimmer.sql.ast.impl.mutation.SavedShape;
import org.babyfish.jimmer.sql.ast.impl.mutation.SemNode;
import org.jetbrains.annotations.NotNull;

class ShapedEntityMap<E>
extends SemNode<E>
implements Iterable<List<E>> {
    private static final int CAPACITY = 8;
    private SemNode<E>[] tab;
    private int modCount;

    public ShapedEntityMap() {
        super(0, null, null, null, null, null);
        this.before = this;
        this.after = this;
    }

    public void add(E entity) {
        SemNode<E> startNode;
        if (this.tab == null) {
            this.tab = new SemNode[8];
        }
        SavedShape key = SavedShape.of((ImmutableSpi)entity);
        int h = System.identityHashCode(key);
        h ^= h >>> 16;
        int index = 7 & h;
        SemNode<E> node = startNode = this.tab[index];
        while (node != null) {
            if (node.key == key) {
                node.entities.add(entity);
                ++this.modCount;
                return;
            }
            node = node.next;
        }
        SemNode last = this.before;
        SemNode<E> node2 = new SemNode<E>(h, key, entity, startNode, last, this);
        last.after = node2;
        this.before = node2;
        this.tab[index] = node2;
        ++this.modCount;
    }

    public List<E> remove() {
        SemNode node = this.after;
        if (node == this) {
            return Collections.emptyList();
        }
        SemNode<E>[] tab = this.tab;
        node.before.after = node.after;
        node.after.before = node.before;
        int index = node.hash & 7;
        SemNode<E> p = null;
        SemNode<E> n = tab[index];
        while (n != null) {
            if (node == n) {
                if (p != null) {
                    p.next = n.next;
                    break;
                }
                tab[index] = n.next;
                break;
            }
            p = n;
            n = n.next;
        }
        ++this.modCount;
        return node.entities;
    }

    public boolean isEmpty() {
        return this.after == this;
    }

    @Override
    @NotNull
    public Iterator<List<E>> iterator() {
        if (this.after == this) {
            return Collections.emptyIterator();
        }
        return new Itr();
    }

    public String toString() {
        if (this.after == this) {
            return "{}";
        }
        StringBuilder builder = new StringBuilder("{");
        boolean addComma = false;
        SemNode n = this.after;
        while (n != this) {
            if (addComma) {
                builder.append(", ");
            } else {
                addComma = true;
            }
            builder.append(n.key).append(": ").append(n.entities);
            n = n.after;
        }
        builder.append('}');
        return builder.toString();
    }

    private class Itr
    implements Iterator<List<E>> {
        private final int modCount;
        private SemNode<E> current;

        public Itr() {
            this.modCount = ShapedEntityMap.this.modCount;
            this.current = ShapedEntityMap.this.after;
        }

        @Override
        public boolean hasNext() {
            if (ShapedEntityMap.this.modCount != this.modCount) {
                throw new ConcurrentModificationException();
            }
            return this.current != ShapedEntityMap.this;
        }

        @Override
        public List<E> next() {
            if (ShapedEntityMap.this.modCount != this.modCount) {
                throw new ConcurrentModificationException();
            }
            if (this.current == ShapedEntityMap.this) {
                throw new NoSuchElementException();
            }
            List entities = this.current.entities;
            this.current = this.current.after;
            return entities;
        }
    }
}

