/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl;

import java.util.Objects;
import org.babyfish.jimmer.meta.EmbeddedLevel;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.TargetLevel;
import org.babyfish.jimmer.sql.ast.ComparableExpression;
import org.babyfish.jimmer.sql.ast.Expression;
import org.babyfish.jimmer.sql.ast.NumericExpression;
import org.babyfish.jimmer.sql.ast.PropExpression;
import org.babyfish.jimmer.sql.ast.StringExpression;
import org.babyfish.jimmer.sql.ast.impl.AbstractExpression;
import org.babyfish.jimmer.sql.ast.impl.Ast;
import org.babyfish.jimmer.sql.ast.impl.AstContext;
import org.babyfish.jimmer.sql.ast.impl.AstVisitor;
import org.babyfish.jimmer.sql.ast.impl.CoalesceBuilder;
import org.babyfish.jimmer.sql.ast.impl.ComparableExpressionImplementor;
import org.babyfish.jimmer.sql.ast.impl.NumericExpressionImplementor;
import org.babyfish.jimmer.sql.ast.impl.StringExpressionImplementor;
import org.babyfish.jimmer.sql.ast.impl.table.TableImplementor;
import org.babyfish.jimmer.sql.ast.impl.table.TableProxies;
import org.babyfish.jimmer.sql.ast.table.Table;
import org.babyfish.jimmer.sql.ast.table.spi.PropExpressionImplementor;
import org.babyfish.jimmer.sql.meta.ColumnDefinition;
import org.babyfish.jimmer.sql.meta.EmbeddedColumns;
import org.babyfish.jimmer.sql.meta.FormulaTemplate;
import org.babyfish.jimmer.sql.meta.MetadataStrategy;
import org.babyfish.jimmer.sql.runtime.SqlBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PropExpressionImpl<T>
extends AbstractExpression<T>
implements PropExpressionImplementor<T> {
    protected final Table<?> table;
    protected final ImmutableProp prop;
    protected final ImmutableProp deepestProp;
    protected final EmbeddedImpl<?> base;
    protected final String path;
    protected final boolean rawId;

    public static PropExpressionImpl<?> of(EmbeddedImpl<?> base, ImmutableProp prop) {
        if (prop.isEmbedded(EmbeddedLevel.SCALAR)) {
            return new EmbeddedImpl(base, prop);
        }
        Class elementClass = prop.getElementClass();
        if (String.class.isAssignableFrom(elementClass)) {
            return new StrImpl(base, prop);
        }
        if (elementClass.isPrimitive() || Number.class.isAssignableFrom(elementClass)) {
            return new NumImpl(base, prop);
        }
        if (Comparable.class.isAssignableFrom(elementClass)) {
            return new CmpImpl(base, prop);
        }
        return new PropExpressionImpl(base, prop);
    }

    public static PropExpressionImpl<?> of(Table<?> table, ImmutableProp prop, boolean rawId) {
        if (prop.isTransient()) {
            throw new IllegalArgumentException("Cannot create prop expression for transient property \"" + prop + "\"");
        }
        if (prop.isView()) {
            throw new IllegalArgumentException("Cannot create prop expression for view property \"" + prop + "\"");
        }
        if (!prop.getDependencies().isEmpty()) {
            throw new IllegalArgumentException("Cannot create prop expression for java/kotlin based calculated property \"" + prop + "\"");
        }
        if (prop.isAssociation(TargetLevel.PERSISTENT)) {
            throw new IllegalArgumentException("Cannot create prop expression for java/kotlin based association property \"" + prop + "\"");
        }
        if (prop.isEmbedded(EmbeddedLevel.SCALAR)) {
            return new EmbeddedImpl(table, prop, rawId);
        }
        Class elementClass = prop.getElementClass();
        if (String.class.isAssignableFrom(elementClass)) {
            return new StrImpl(table, prop, rawId);
        }
        if (elementClass.isPrimitive() || Number.class.isAssignableFrom(elementClass)) {
            return new NumImpl(table, prop, rawId);
        }
        if (Comparable.class.isAssignableFrom(elementClass)) {
            return new CmpImpl(table, prop, rawId);
        }
        return new PropExpressionImpl(table, prop, rawId);
    }

    PropExpressionImpl(Table<?> table, ImmutableProp prop, boolean rawId) {
        if (prop.isAssociation(TargetLevel.PERSISTENT)) {
            throw new IllegalArgumentException("The property '" + prop + "' cannot be association property");
        }
        if (!prop.isColumnDefinition() && !(prop.getSqlTemplate() instanceof FormulaTemplate)) {
            throw new IllegalArgumentException("The property '" + prop + "' is not selectable");
        }
        this.table = table;
        this.prop = prop;
        this.deepestProp = prop;
        this.base = null;
        this.path = null;
        this.rawId = rawId && prop.isId();
    }

    PropExpressionImpl(EmbeddedImpl<?> base, ImmutableProp prop) {
        if (prop.isAssociation(TargetLevel.PERSISTENT)) {
            throw new IllegalArgumentException("prop '" + prop + "' cannot be association property");
        }
        this.table = base.table;
        this.prop = base.getProp();
        this.deepestProp = prop;
        this.base = base;
        this.path = base.path == null ? prop.getName() : base.path + "." + prop.getName();
        this.rawId = base.rawId;
    }

    @Override
    public Table<?> getTable() {
        return this.table;
    }

    @Override
    public ImmutableProp getProp() {
        return this.prop;
    }

    @Override
    public ImmutableProp getDeepestProp() {
        return this.deepestProp;
    }

    @Override
    public EmbeddedImpl<?> getBase() {
        return this.base;
    }

    @Override
    public boolean isRawId() {
        return this.rawId;
    }

    @Override
    @Nullable
    public EmbeddedColumns.Partial getPartial(MetadataStrategy strategy) {
        if (this.base != null || this.prop.isEmbedded(EmbeddedLevel.SCALAR)) {
            return ((EmbeddedColumns)this.prop.getStorage(strategy)).partial(this.path);
        }
        return null;
    }

    @Override
    public void accept(@NotNull AstVisitor visitor) {
        visitor.visitTableReference(TableProxies.resolve(this.table, visitor.getAstContext()), this.prop, this.rawId);
    }

    @Override
    public void renderTo(@NotNull SqlBuilder builder) {
        this.renderTo(builder, false);
    }

    @Override
    protected boolean determineHasVirtualPredicate() {
        return false;
    }

    @Override
    protected Ast onResolveVirtualPredicate(AstContext ctx) {
        return this;
    }

    @Override
    public void renderTo(@NotNull SqlBuilder builder, boolean ignoreBrackets) {
        TableImplementor<?> tableImplementor = TableProxies.resolve(this.table, builder.getAstContext());
        EmbeddedColumns.Partial partial = this.getPartial(builder.getAstContext().getSqlClient().getMetadataStrategy());
        if (partial != null) {
            if (ignoreBrackets || partial.size() == 1) {
                tableImplementor.renderSelection(this.prop, this.rawId, builder, (ColumnDefinition)(this.path != null ? partial : null));
            } else {
                builder.enter(SqlBuilder.ScopeType.TUPLE);
                tableImplementor.renderSelection(this.prop, this.rawId, builder, (ColumnDefinition)(this.path != null ? partial : null));
                builder.leave();
            }
        } else {
            tableImplementor.renderSelection(this.prop, this.rawId, builder, null);
        }
    }

    @Override
    public int precedence() {
        return 0;
    }

    @Override
    public Class<T> getType() {
        return this.deepestProp.getElementClass();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PropExpressionImpl that = (PropExpressionImpl)o;
        return this.table.equals(that.table) && this.prop.equals((Object)that.prop) && this.path.equals(that.path);
    }

    public int hashCode() {
        return Objects.hash(this.table, this.prop, this.path);
    }

    public String toString() {
        if (this.path == null) {
            return this.prop.toString();
        }
        return this.prop.toString() + '.' + this.path;
    }

    @Override
    public PropExpressionImpl<T> unwrap() {
        return this;
    }

    public static class EmbeddedImpl<T>
    extends PropExpressionImpl<T>
    implements PropExpression.Embedded<T> {
        protected EmbeddedImpl(Table<?> table, ImmutableProp prop, boolean rawId) {
            super(table, prop, rawId);
        }

        protected EmbeddedImpl(EmbeddedImpl<?> base, ImmutableProp prop) {
            super(base, prop);
        }

        @Override
        public <XE extends Expression<?>> XE get(String prop) {
            ImmutableProp deeperProp = this.deepestProp.getTargetType().getProp(prop);
            return (XE)PropExpressionImpl.of(this, deeperProp);
        }

        @Override
        public <XE extends Expression<?>> XE get(ImmutableProp prop) {
            if (prop.getDeclaringType() != this.deepestProp.getTargetType()) {
                throw new IllegalArgumentException("The property \"" + prop + "\" does not belong to the current embeddable type \"" + this.deepestProp.getTargetType() + "\"");
            }
            return (XE)PropExpressionImpl.of(this, prop);
        }

        @Override
        @NotNull
        public final Expression<T> coalesce(T defaultValue) {
            return PropExpression.Embedded.super.coalesce(defaultValue);
        }

        @Override
        @NotNull
        public final Expression<T> coalesce(Expression<T> defaultExpr) {
            return PropExpression.Embedded.super.coalesce(defaultExpr);
        }

        @Override
        @NotNull
        public final CoalesceBuilder<T> coalesceBuilder() {
            return PropExpression.Embedded.super.coalesceBuilder();
        }
    }

    private static class StrImpl
    extends PropExpressionImpl<String>
    implements PropExpression.Str,
    StringExpressionImplementor {
        StrImpl(Table<?> table, ImmutableProp prop, boolean rawId) {
            super(table, prop, rawId);
        }

        StrImpl(EmbeddedImpl<?> base, ImmutableProp prop) {
            super(base, prop);
        }

        @Override
        @NotNull
        public StringExpression coalesce(String defaultValue) {
            return StringExpressionImplementor.super.coalesce(defaultValue);
        }

        @Override
        @NotNull
        public StringExpression coalesce(Expression<String> defaultExpr) {
            return StringExpressionImplementor.super.coalesce((Expression)defaultExpr);
        }

        @Override
        public @NotNull CoalesceBuilder.Str coalesceBuilder() {
            return StringExpressionImplementor.super.coalesceBuilder();
        }

        @Override
        public Table<?> getTable() {
            return super.getTable();
        }
    }

    private static class NumImpl<N extends Number>
    extends PropExpressionImpl<N>
    implements PropExpression.Num<N>,
    NumericExpressionImplementor<N> {
        NumImpl(Table<?> table, ImmutableProp prop, boolean rawId) {
            super(table, prop, rawId);
        }

        NumImpl(EmbeddedImpl<?> base, ImmutableProp prop) {
            super(base, prop);
        }

        @Override
        @NotNull
        public NumericExpression<N> coalesce(N defaultValue) {
            return NumericExpressionImplementor.super.coalesce(defaultValue);
        }

        @Override
        @NotNull
        public NumericExpression<N> coalesce(Expression<N> defaultExpr) {
            return NumericExpressionImplementor.super.coalesce((Expression)defaultExpr);
        }

        @Override
        public @NotNull CoalesceBuilder.Num<N> coalesceBuilder() {
            return NumericExpressionImplementor.super.coalesceBuilder();
        }
    }

    private static class CmpImpl<T extends Comparable<?>>
    extends PropExpressionImpl<T>
    implements PropExpression.Cmp<T>,
    ComparableExpressionImplementor<T> {
        CmpImpl(Table<?> table, ImmutableProp prop, boolean rawId) {
            super(table, prop, rawId);
        }

        CmpImpl(EmbeddedImpl<?> base, ImmutableProp prop) {
            super(base, prop);
        }

        @Override
        @NotNull
        public ComparableExpression<T> coalesce(T defaultValue) {
            return ComparableExpressionImplementor.super.coalesce(defaultValue);
        }

        @Override
        @NotNull
        public ComparableExpression<T> coalesce(Expression<T> defaultExpr) {
            return ComparableExpressionImplementor.super.coalesce((Expression)defaultExpr);
        }

        @Override
        public @NotNull CoalesceBuilder.Cmp<T> coalesceBuilder() {
            return ComparableExpressionImplementor.super.coalesceBuilder();
        }
    }
}

