/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl;

import java.util.Objects;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.sql.ast.Expression;
import org.babyfish.jimmer.sql.ast.Predicate;
import org.babyfish.jimmer.sql.ast.PropExpression;
import org.babyfish.jimmer.sql.ast.impl.AbstractPredicate;
import org.babyfish.jimmer.sql.ast.impl.Ast;
import org.babyfish.jimmer.sql.ast.impl.AstContext;
import org.babyfish.jimmer.sql.ast.impl.AstVisitor;
import org.babyfish.jimmer.sql.ast.impl.table.JoinUtils;
import org.babyfish.jimmer.sql.ast.impl.table.TableImplementor;
import org.babyfish.jimmer.sql.ast.impl.table.TableProxies;
import org.babyfish.jimmer.sql.ast.table.spi.PropExpressionImplementor;
import org.babyfish.jimmer.sql.meta.ColumnDefinition;
import org.babyfish.jimmer.sql.meta.EmbeddedColumns;
import org.babyfish.jimmer.sql.meta.SingleColumn;
import org.babyfish.jimmer.sql.runtime.SqlBuilder;
import org.jetbrains.annotations.NotNull;

class NullityPredicate
extends AbstractPredicate {
    private Expression<?> expression;
    private final boolean negative;

    public NullityPredicate(Expression<?> expression, boolean negative) {
        PropExpressionImplementor propExpr;
        if (!negative && expression instanceof PropExpression && !(propExpr = (PropExpressionImplementor)expression).getProp().isNullable() && !JoinUtils.hasLeftJoin(propExpr.getTable())) {
            throw new IllegalArgumentException("Unable to instantiate `is null` predicate which attempts to check if a non-null property of root table or inner joined table is null (eg: `table.parent().isNull()`). There are two solutions: 1. Use associated id property (eg: `table.parentId().isNull()`), 2. This non-property must belong to a join table and table join path needs to have at least one left join (eg: `table.parent(JoinType.LEFT).isNull()`). The non-null property is `" + propExpr.getProp().getName() + "` of table `" + propExpr.getTable().getImmutableType().getClass().getName() + "`.");
        }
        this.expression = expression;
        this.negative = negative;
    }

    @Override
    public void accept(@NotNull AstVisitor visitor) {
        ((Ast)((Object)this.expression)).accept(visitor);
    }

    @Override
    public void renderTo(@NotNull SqlBuilder builder) {
        PropExpressionImplementor propExpr;
        EmbeddedColumns.Partial partial;
        if (this.expression instanceof PropExpression && (partial = (propExpr = (PropExpressionImplementor)this.expression).getPartial(builder.getAstContext().getSqlClient().getMetadataStrategy())) != null) {
            TableImplementor<?> tableImplementor = TableProxies.resolve(propExpr.getTable(), builder.getAstContext());
            ImmutableProp prop = propExpr.getProp();
            builder.enter(SqlBuilder.ScopeType.AND);
            for (String column : partial) {
                builder.separator();
                tableImplementor.renderSelection(prop, propExpr.isRawId(), builder, (ColumnDefinition)new SingleColumn(column, false, null));
                if (this.negative) {
                    builder.sql(" is not null");
                    continue;
                }
                builder.sql(" is null");
            }
            builder.leave();
            return;
        }
        this.renderChild((Ast)((Object)this.expression), builder);
        if (this.negative) {
            builder.sql(" is not null");
        } else {
            builder.sql(" is null");
        }
    }

    @Override
    protected boolean determineHasVirtualPredicate() {
        return NullityPredicate.hasVirtualPredicate(this.expression);
    }

    @Override
    protected Ast onResolveVirtualPredicate(AstContext ctx) {
        this.expression = ctx.resolveVirtualPredicate(this.expression);
        return this;
    }

    @Override
    public int precedence() {
        return 0;
    }

    @Override
    public Predicate not() {
        return new NullityPredicate(this.expression, !this.negative);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NullityPredicate)) {
            return false;
        }
        NullityPredicate that = (NullityPredicate)o;
        return this.negative == that.negative && this.expression.equals(that.expression);
    }

    public int hashCode() {
        return Objects.hash(this.expression, this.negative);
    }
}

