/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl;

import java.util.function.Consumer;
import org.babyfish.jimmer.sql.ast.ComparableExpression;
import org.babyfish.jimmer.sql.ast.Expression;
import org.babyfish.jimmer.sql.ast.NumericExpression;
import org.babyfish.jimmer.sql.ast.StringExpression;
import org.babyfish.jimmer.sql.ast.impl.CaseBuilder;
import org.babyfish.jimmer.sql.ast.impl.Literals;
import org.babyfish.jimmer.sql.ast.impl.NullExpression;
import org.babyfish.jimmer.sql.ast.impl.SimpleCaseBuilder;
import org.babyfish.jimmer.sql.ast.impl.SqlExpressionContext;
import org.babyfish.jimmer.sql.ast.impl.SqlExpressions;
import org.jetbrains.annotations.NotNull;

public class ExpressionFactories {
    private ExpressionFactories() {
    }

    public static <F> F of(Class<F> factoryType) {
        if (factoryType == Expression.StringFactory.class) {
            return (F)Str.INSTANCE;
        }
        if (factoryType == Expression.NumericFactory.class) {
            return (F)Num.INSTANCE;
        }
        if (factoryType == Expression.ComparableFactory.class) {
            return (F)Cmp.INSTANCE;
        }
        if (factoryType == Expression.AnyFactory.class) {
            return (F)Any.INSTANCE;
        }
        throw new IllegalStateException("Unknown factory type \"" + factoryType.getName() + "\"");
    }

    private static class Str
    implements Expression.StringFactory {
        static final Str INSTANCE = new Str();

        private Str() {
        }

        @Override
        @NotNull
        public StringExpression value(String value) {
            return Literals.string(value);
        }

        @Override
        @NotNull
        public StringExpression sql(String sql) {
            return (StringExpression)SqlExpressions.of(String.class, sql, null);
        }

        @Override
        @NotNull
        public StringExpression sql(String sql, Expression<?> expression, Object ... values) {
            return (StringExpression)SqlExpressions.of(String.class, sql, new Expression[]{expression}, values);
        }

        @Override
        @NotNull
        public StringExpression sql(String sql, Expression<?>[] expressions, Object ... values) {
            return (StringExpression)SqlExpressions.of(String.class, sql, expressions, values);
        }

        @Override
        @NotNull
        public StringExpression sql(String sql, Consumer<SqlExpressionContext> block) {
            return (StringExpression)SqlExpressions.of(String.class, sql, block);
        }

        @Override
        public <C> @NotNull SimpleCaseBuilder.Str<C> caseBuilder(C value) {
            return this.caseBuilder(Literals.any(value));
        }

        @Override
        public <C> @NotNull SimpleCaseBuilder.Str<C> caseBuilder(Expression<C> expression) {
            return new SimpleCaseBuilder.Str(expression);
        }

        @Override
        public @NotNull CaseBuilder.Str caseBuilder() {
            return new CaseBuilder.Str();
        }
    }

    private static class Num
    implements Expression.NumericFactory {
        static final Num INSTANCE = new Num();

        private Num() {
        }

        @Override
        @NotNull
        public <N extends Number> NumericExpression<N> value(N value) {
            return Literals.number(value);
        }

        @Override
        @NotNull
        public <N extends Number> NumericExpression<N> sql(Class<N> type, String sql) {
            return (NumericExpression)SqlExpressions.of(type, sql, null);
        }

        @Override
        @NotNull
        public <N extends Number> NumericExpression<N> sql(Class<N> type, String sql, Expression<?> expression, Object ... values) {
            return (NumericExpression)SqlExpressions.of(type, sql, new Expression[]{expression}, values);
        }

        @Override
        @NotNull
        public <N extends Number> NumericExpression<N> sql(Class<N> type, String sql, Expression<?>[] expressions, Object ... values) {
            return (NumericExpression)SqlExpressions.of(type, sql, expressions, values);
        }

        @Override
        @NotNull
        public <N extends Number> NumericExpression<N> sql(Class<N> type, String sql, Consumer<SqlExpressionContext> block) {
            return (NumericExpression)SqlExpressions.of(type, sql, block);
        }

        @Override
        public <C, N extends Number> @NotNull SimpleCaseBuilder.Num<C, N> caseBuilder(Class<N> type, C value) {
            return this.caseBuilder(type, Literals.any(value));
        }

        @Override
        public <C, N extends Number> @NotNull SimpleCaseBuilder.Num<C, N> caseBuilder(Class<N> type, Expression<C> expression) {
            return new SimpleCaseBuilder.Num(type, (Expression<?>)expression);
        }

        @Override
        public <N extends Number> @NotNull CaseBuilder.Num<N> caseBuilder(Class<N> type) {
            return new CaseBuilder.Num<N>(type);
        }
    }

    private static class Cmp
    implements Expression.ComparableFactory {
        static final Cmp INSTANCE = new Cmp();

        private Cmp() {
        }

        @Override
        @NotNull
        public <T extends Comparable<?>> ComparableExpression<T> value(T value) {
            return Literals.comparable(value);
        }

        @Override
        @NotNull
        public <T extends Comparable<?>> ComparableExpression<T> sql(Class<T> type, String sql) {
            return (ComparableExpression)SqlExpressions.of(type, sql, null);
        }

        @Override
        @NotNull
        public <T extends Comparable<?>> ComparableExpression<T> sql(Class<T> type, String sql, Expression<?> expression, Object ... values) {
            return (ComparableExpression)SqlExpressions.of(type, sql, new Expression[]{expression}, values);
        }

        @Override
        @NotNull
        public <T extends Comparable<?>> ComparableExpression<T> sql(Class<T> type, String sql, Expression<?>[] expressions, Object ... values) {
            return (ComparableExpression)SqlExpressions.of(type, sql, expressions, values);
        }

        @Override
        @NotNull
        public <T extends Comparable<?>> ComparableExpression<T> sql(Class<T> type, String sql, Consumer<SqlExpressionContext> block) {
            return (ComparableExpression)SqlExpressions.of(type, sql, block);
        }

        @Override
        public <C, T extends Comparable<?>> @NotNull SimpleCaseBuilder.Cmp<C, T> caseBuilder(Class<T> type, C value) {
            return this.caseBuilder(type, Literals.any(value));
        }

        @Override
        public <C, T extends Comparable<?>> @NotNull SimpleCaseBuilder.Cmp<C, T> caseBuilder(Class<T> type, Expression<C> expression) {
            return new SimpleCaseBuilder.Cmp(type, expression);
        }

        @Override
        public <T extends Comparable<?>> @NotNull CaseBuilder.Cmp<T> caseBuilder(Class<T> type) {
            return new CaseBuilder.Cmp<T>(type);
        }
    }

    private static class Any
    implements Expression.AnyFactory {
        static final Any INSTANCE = new Any();

        private Any() {
        }

        @Override
        @NotNull
        public <T> Expression<T> value(T value) {
            return Literals.any(value);
        }

        @Override
        @NotNull
        public <T> Expression<T> nullValue(Class<T> type) {
            return new NullExpression<T>(type);
        }

        @Override
        @NotNull
        public <T> Expression<T> sql(Class<T> type, String sql) {
            return SqlExpressions.of(type, sql, null);
        }

        @Override
        @NotNull
        public <T> Expression<T> sql(Class<T> type, String sql, Expression<?> expression, Object ... values) {
            return SqlExpressions.of(type, sql, new Expression[]{expression}, values);
        }

        @Override
        @NotNull
        public <T> Expression<T> sql(Class<T> type, String sql, Expression<?>[] expressions, Object ... values) {
            return SqlExpressions.of(type, sql, expressions, values);
        }

        @Override
        @NotNull
        public <T> Expression<T> sql(Class<T> type, String sql, Consumer<SqlExpressionContext> block) {
            return SqlExpressions.of(type, sql, block);
        }

        @Override
        @NotNull
        public <C, T> SimpleCaseBuilder<C, T> caseBuilder(Class<T> type, C value) {
            return this.caseBuilder(type, Literals.any(value));
        }

        @Override
        @NotNull
        public <C, T> SimpleCaseBuilder<C, T> caseBuilder(Class<T> type, Expression<C> expression) {
            return new SimpleCaseBuilder(type, expression);
        }

        @Override
        @NotNull
        public <T> CaseBuilder<T> caseBuilder(Class<T> type) {
            return new CaseBuilder<T>(type);
        }
    }
}

