/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl;

import java.util.Objects;
import org.babyfish.jimmer.sql.ast.Expression;
import org.babyfish.jimmer.sql.ast.Predicate;
import org.babyfish.jimmer.sql.ast.impl.AbstractPredicate;
import org.babyfish.jimmer.sql.ast.impl.Ast;
import org.babyfish.jimmer.sql.ast.impl.AstContext;
import org.babyfish.jimmer.sql.ast.impl.AstVisitor;
import org.babyfish.jimmer.sql.ast.impl.ComparisonPredicates;
import org.babyfish.jimmer.sql.ast.impl.ExpressionImplementor;
import org.babyfish.jimmer.sql.ast.impl.Literals;
import org.babyfish.jimmer.sql.runtime.SqlBuilder;
import org.jetbrains.annotations.NotNull;

abstract class ComparisonPredicate
extends AbstractPredicate {
    protected Expression<?> left;
    protected Expression<?> right;

    public ComparisonPredicate(Expression<?> left, Expression<?> right) {
        this.left = left;
        this.right = right;
        Literals.bind(left, right);
        Literals.bind(right, left);
    }

    protected abstract String operator();

    @Override
    public void accept(@NotNull AstVisitor visitor) {
        ((Ast)((Object)this.left)).accept(visitor);
        ((Ast)((Object)this.right)).accept(visitor);
    }

    @Override
    public void renderTo(@NotNull SqlBuilder builder) {
        ComparisonPredicates.renderComparison((ExpressionImplementor)this.left, this.operator(), this.right, builder);
    }

    @Override
    protected boolean determineHasVirtualPredicate() {
        return ComparisonPredicate.hasVirtualPredicate(this.left) || ComparisonPredicate.hasVirtualPredicate(this.right);
    }

    @Override
    protected Ast onResolveVirtualPredicate(AstContext ctx) {
        this.left = ctx.resolveVirtualPredicate(this.left);
        this.right = ctx.resolveVirtualPredicate(this.right);
        return this;
    }

    @Override
    public int precedence() {
        return 4;
    }

    public int hashCode() {
        return Objects.hash(this.left, this.right);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ComparisonPredicate that = (ComparisonPredicate)o;
        return this.left.equals(that.left) && this.right.equals(that.right);
    }

    static class Ge
    extends ComparisonPredicate {
        public Ge(Expression<?> left, Expression<?> right) {
            super(left, right);
        }

        @Override
        protected String operator() {
            return ">=";
        }

        @Override
        public Predicate not() {
            return new Lt(this.left, this.right);
        }
    }

    static class Gt
    extends ComparisonPredicate {
        public Gt(Expression<?> left, Expression<?> right) {
            super(left, right);
        }

        @Override
        protected String operator() {
            return ">";
        }

        @Override
        public Predicate not() {
            return new Le(this.left, this.right);
        }
    }

    static class Le
    extends ComparisonPredicate {
        public Le(Expression<?> left, Expression<?> right) {
            super(left, right);
        }

        @Override
        protected String operator() {
            return "<=";
        }

        @Override
        public Predicate not() {
            return new Gt(this.left, this.right);
        }
    }

    static class Lt
    extends ComparisonPredicate {
        public Lt(Expression<?> left, Expression<?> right) {
            super(left, right);
        }

        @Override
        protected String operator() {
            return "<";
        }

        @Override
        public Predicate not() {
            return new Ge(this.left, this.right);
        }
    }

    static class Ne
    extends ComparisonPredicate {
        public Ne(Expression<?> left, Expression<?> right) {
            super(left, right);
        }

        @Override
        protected String operator() {
            return "<>";
        }

        @Override
        public Predicate not() {
            return new Eq(this.left, this.right);
        }
    }

    static class Eq
    extends ComparisonPredicate {
        public Eq(Expression<?> left, Expression<?> right) {
            super(left, right);
        }

        @Override
        protected String operator() {
            return "=";
        }

        @Override
        public Predicate not() {
            return new Ne(this.left, this.right);
        }
    }
}

