/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.event.binlog.impl;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.sql.association.meta.AssociationType;
import org.babyfish.jimmer.sql.event.Triggers;
import org.babyfish.jimmer.sql.event.binlog.BinLog;
import org.babyfish.jimmer.sql.event.binlog.impl.BinLogParser;
import org.babyfish.jimmer.sql.event.binlog.impl.MiddleRow;
import org.babyfish.jimmer.sql.meta.JoinTableFilterInfo;
import org.babyfish.jimmer.sql.meta.MetadataStrategy;
import org.babyfish.jimmer.sql.meta.impl.DatabaseIdentifiers;
import org.babyfish.jimmer.sql.runtime.EntityManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BinLogImpl
implements BinLog {
    private static final Logger LOGGER = LoggerFactory.getLogger(BinLog.class);
    private static final Set<String> EXCLUDED_TABLE_NAMES = BinLogImpl.standardTableNames("JIMMER_TRANS_CACHE_OPERATOR");
    private final EntityManager entityManager;
    private final String microServiceName;
    private final MetadataStrategy strategy;
    private final BinLogParser parser;
    private final Triggers triggers;

    public BinLogImpl(EntityManager entityManager, String microServiceName, MetadataStrategy strategy, BinLogParser parser, Triggers triggers) {
        this.entityManager = entityManager;
        this.microServiceName = microServiceName;
        this.strategy = strategy;
        this.parser = parser;
        this.triggers = triggers;
    }

    @Override
    public void accept(String tableName, JsonNode oldData, JsonNode newData) {
        this.accept(tableName, oldData, newData, null);
    }

    @Override
    public void accept(String tableName, JsonNode oldData, JsonNode newData, String reason) {
        boolean isNewNull;
        boolean isOldNull = oldData == null || oldData.isNull();
        boolean bl = isNewNull = newData == null || newData.isNull();
        if (isOldNull && isNewNull) {
            return;
        }
        Map<List<Object>, ImmutableType> typeMap = this.entityManager.getTypeMapByServiceAndTable(this.microServiceName, tableName, this.strategy);
        if (typeMap.isEmpty()) {
            if (!EXCLUDED_TABLE_NAMES.contains(DatabaseIdentifiers.comparableIdentifier((String)tableName))) {
                LOGGER.warn("Illegal table name \"{}\" of micro service \"{}\", it is not managed by current entity manager", (Object)tableName, (Object)this.microServiceName);
            }
            return;
        }
        for (ImmutableType type : typeMap.values()) {
            if (type instanceof AssociationType) {
                MiddleRow newRow;
                AssociationType associationType = (AssociationType)type;
                JoinTableFilterInfo filterInfo = associationType.getJoinTableFilterInfo();
                MiddleRow oldRow = isOldNull ? null : this.parser.parseMiddleRow(associationType.getBaseProp(), oldData);
                MiddleRow middleRow = newRow = isNewNull ? null : MiddleRow.merge(oldRow, this.parser.parseMiddleRow(associationType.getBaseProp(), newData));
                if (oldRow != null && !Boolean.TRUE.equals(oldRow.deleted) && (filterInfo == null || oldRow.filteredValue == null || filterInfo.getValues().contains(oldRow.filteredValue))) {
                    this.triggers.fireMiddleTableDelete(associationType.getBaseProp(), oldRow.sourceId, oldRow.targetId, null, reason);
                }
                if (newRow == null || Boolean.TRUE.equals(newRow.deleted) || filterInfo != null && newRow.filteredValue != null && !filterInfo.getValues().contains(newRow.filteredValue)) continue;
                this.triggers.fireMiddleTableInsert(associationType.getBaseProp(), newRow.sourceId, newRow.targetId, null, reason);
                continue;
            }
            this.triggers.fireEntityTableChange(this.parser.parseEntity(type, oldData), this.parser.parseEntity(type, newData), null, reason);
        }
    }

    public BinLogParser parser() {
        return this.parser;
    }

    private static Set<String> standardTableNames(String ... tableNames) {
        HashSet<String> set = new HashSet<String>();
        for (String tableName : tableNames) {
            set.add(DatabaseIdentifiers.comparableIdentifier((String)tableName));
        }
        return set;
    }

    private static JsonNode nodeOf(JsonNode jsonNode, String columnName) {
        JsonNode childNode = jsonNode.get(columnName);
        if (childNode != null) {
            return childNode;
        }
        String comparableIdentifier = DatabaseIdentifiers.comparableIdentifier((String)columnName);
        for (Map.Entry e : jsonNode.properties()) {
            if (!DatabaseIdentifiers.comparableIdentifier((String)((String)e.getKey())).equals(comparableIdentifier)) continue;
            return (JsonNode)e.getValue();
        }
        return null;
    }
}

