/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.event;

import java.sql.Connection;
import java.util.Objects;
import org.babyfish.jimmer.impl.util.Classes;
import org.babyfish.jimmer.meta.EmbeddedLevel;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.TargetLevel;
import org.babyfish.jimmer.meta.TypedProp;
import org.babyfish.jimmer.sql.event.DatabaseEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AssociationEvent
implements DatabaseEvent {
    private final ImmutableProp prop;
    private final Object sourceId;
    private final Object detachedTargetId;
    private final Object attachedTargetId;
    private final Connection con;
    private final Object reason;

    public AssociationEvent(ImmutableProp prop, Object sourceId, Connection con, Object reason) {
        this.validateConstructorArgs(prop, sourceId);
        this.prop = prop;
        this.sourceId = sourceId;
        this.detachedTargetId = null;
        this.attachedTargetId = null;
        this.con = con;
        this.reason = reason;
    }

    public AssociationEvent(ImmutableProp prop, Object sourceId, Object detachedTargetId, Object attachedTargetId, Connection con, Object reason) {
        this.validateConstructorArgs(prop, sourceId);
        if (detachedTargetId == null && attachedTargetId == null) {
            throw new IllegalArgumentException("Both `detachedTargetId` and `attachedTargetId` is null, this is not allowed");
        }
        ImmutableProp targetIdProp = prop.getTargetType().getIdProp();
        boolean validDetachedTargetId = detachedTargetId == null ? true : (targetIdProp.isEmbedded(EmbeddedLevel.SCALAR) ? targetIdProp.getTargetType().getJavaClass().isAssignableFrom(detachedTargetId.getClass()) : Classes.matches((Class)targetIdProp.getElementClass(), detachedTargetId.getClass()));
        if (!validDetachedTargetId) {
            throw new IllegalArgumentException("The type of detachedTargetId \"" + sourceId + "\" does not match the type of \"" + prop.getTargetType().getIdProp() + "\"");
        }
        boolean validAttachedTargetId = attachedTargetId == null ? true : (targetIdProp.isEmbedded(EmbeddedLevel.SCALAR) ? targetIdProp.getTargetType().getJavaClass().isAssignableFrom(attachedTargetId.getClass()) : Classes.matches((Class)targetIdProp.getElementClass(), attachedTargetId.getClass()));
        if (!validAttachedTargetId) {
            throw new IllegalArgumentException("The type of attachedTargetId \"" + sourceId + "\" does not match the type of \"" + prop.getTargetType().getIdProp() + "\"");
        }
        this.prop = prop;
        this.sourceId = sourceId;
        this.detachedTargetId = detachedTargetId;
        this.attachedTargetId = attachedTargetId;
        this.con = con;
        this.reason = reason;
    }

    private void validateConstructorArgs(ImmutableProp prop, Object sourceId) {
        if (prop == null) {
            throw new IllegalArgumentException("prop cannot be null");
        }
        if (!prop.isAssociation(TargetLevel.PERSISTENT)) {
            throw new IllegalArgumentException("prop must be persistent association");
        }
        ImmutableProp idProp = prop.getDeclaringType().getIdProp();
        boolean validId = false;
        if (sourceId != null) {
            if (idProp.isEmbedded(EmbeddedLevel.SCALAR)) {
                validId = idProp.getTargetType().getJavaClass().isAssignableFrom(sourceId.getClass());
            } else if (Classes.matches((Class)idProp.getElementClass(), sourceId.getClass())) {
                validId = true;
            }
        }
        if (!validId) {
            throw new IllegalArgumentException("The type of sourceId \"" + sourceId + "\" does not match the type of \"" + idProp + "\"");
        }
    }

    @NotNull
    public ImmutableProp getImmutableProp() {
        return this.prop;
    }

    @NotNull
    public Object getSourceId() {
        return this.sourceId;
    }

    @Nullable
    public Object getDetachedTargetId() {
        this.validateTarget();
        return this.detachedTargetId;
    }

    @Nullable
    public Object getAttachedTargetId() {
        this.validateTarget();
        return this.attachedTargetId;
    }

    @Override
    public boolean isChanged(ImmutableProp prop) {
        return this.prop == prop;
    }

    @Override
    public boolean isChanged(TypedProp<?, ?> prop) {
        return this.isChanged(prop.unwrap());
    }

    @Override
    @Nullable
    public Connection getConnection() {
        return this.con;
    }

    @Override
    @Nullable
    public Object getReason() {
        return this.reason;
    }

    @NotNull
    public Type getType() {
        Object dtId = this.detachedTargetId;
        Object atId = this.attachedTargetId;
        if (dtId == null && atId == null) {
            return Type.EVICT;
        }
        if (dtId == null) {
            return Type.ATTACH;
        }
        if (atId == null) {
            return Type.DETACH;
        }
        return Type.REPLACE;
    }

    @Override
    public boolean isEvict() {
        return this.detachedTargetId == null && this.attachedTargetId == null;
    }

    private void validateTarget() {
        if (this.detachedTargetId == null && this.attachedTargetId == null) {
            throw new IllegalStateException("Cannot get target id because the event type is `EVICT`");
        }
    }

    public int hashCode() {
        return Objects.hash(this.prop, this.sourceId, this.detachedTargetId, this.attachedTargetId, this.reason);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AssociationEvent that = (AssociationEvent)o;
        return this.prop.equals((Object)that.prop) && this.sourceId.equals(that.sourceId) && Objects.equals(this.detachedTargetId, that.detachedTargetId) && Objects.equals(this.attachedTargetId, that.attachedTargetId) && Objects.equals(this.reason, that.reason);
    }

    public String toString() {
        return "AssociationEvent{prop=" + this.prop + ", sourceId=" + this.sourceId + ", detachedTargetId=" + this.detachedTargetId + ", attachedTargetId=" + this.attachedTargetId + ", reason=" + this.reason + '}';
    }

    public static enum Type {
        EVICT,
        ATTACH,
        DETACH,
        REPLACE;

    }
}

