/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.util;

import java.util.Collection;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;

public class InList<E>
implements Iterable<Iterable<E>> {
    private final Collection<E> values;
    private final boolean padding;
    private final int maximum;

    public InList(Collection<E> values, boolean padding, int maximum) {
        this.values = values;
        this.padding = padding;
        this.maximum = maximum;
    }

    @Override
    @NotNull
    public Iterator<Iterable<E>> iterator() {
        return new Itr(this.values.iterator());
    }

    private class Itr
    implements Iterator<Iterable<E>> {
        private final Iterator<E> rawItr;

        private Itr(Iterator<E> rawItr) {
            this.rawItr = rawItr;
        }

        @Override
        public boolean hasNext() {
            return this.rawItr.hasNext();
        }

        @Override
        public Iterable<E> next() {
            return new Iterable<E>(){

                @Override
                @NotNull
                public Iterator<E> iterator() {
                    return new NestedItr(Itr.this.rawItr);
                }
            };
        }
    }

    private class NestedItr
    implements Iterator<E> {
        private final Iterator<E> rawItr;
        private int visited;
        private E value;

        private NestedItr(Iterator<E> rawItr) {
            this.rawItr = rawItr;
        }

        @Override
        public boolean hasNext() {
            int v = this.visited;
            if (v >= InList.this.maximum) {
                return false;
            }
            if (this.rawItr.hasNext()) {
                return true;
            }
            return InList.this.padding && (v & v - 1) != 0;
        }

        @Override
        public E next() {
            ++this.visited;
            if (!this.rawItr.hasNext()) {
                return this.value;
            }
            this.value = this.rawItr.next();
            return this.value;
        }
    }
}

