/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.mutation;

import java.sql.Connection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.meta.TargetLevel;
import org.babyfish.jimmer.meta.TypedProp;
import org.babyfish.jimmer.sql.DissociateAction;
import org.babyfish.jimmer.sql.ast.Predicate;
import org.babyfish.jimmer.sql.ast.impl.mutation.SaveCommandCfgImplementor;
import org.babyfish.jimmer.sql.ast.mutation.AbstractEntitySaveCommand;
import org.babyfish.jimmer.sql.ast.mutation.AssociatedSaveMode;
import org.babyfish.jimmer.sql.ast.mutation.DeleteMode;
import org.babyfish.jimmer.sql.ast.mutation.LockMode;
import org.babyfish.jimmer.sql.ast.mutation.SaveMode;
import org.babyfish.jimmer.sql.ast.table.Table;
import org.babyfish.jimmer.sql.event.TriggerType;
import org.babyfish.jimmer.sql.event.Triggers;
import org.babyfish.jimmer.sql.runtime.JSqlClientImplementor;

abstract class AbstractEntitySaveCommandImpl
implements AbstractEntitySaveCommand {
    final JSqlClientImplementor sqlClient;
    final Connection con;
    final Data data;

    AbstractEntitySaveCommandImpl(JSqlClientImplementor sqlClient, Connection con, Data data) {
        this.sqlClient = sqlClient;
        this.con = con;
        this.data = data != null ? data : new Data(sqlClient);
    }

    @Override
    public AbstractEntitySaveCommand configure(Consumer<AbstractEntitySaveCommand.Cfg> block) {
        Data newData = new Data(this.data);
        block.accept(newData);
        if (this.data.equals(newData)) {
            return this;
        }
        return this.create(newData);
    }

    abstract AbstractEntitySaveCommand create(Data var1);

    static final class Data
    implements SaveCommandCfgImplementor {
        private final JSqlClientImplementor sqlClient;
        private final Triggers triggers;
        private boolean frozen;
        private SaveMode mode;
        private AssociatedSaveMode associatedMode;
        private Map<ImmutableProp, AssociatedSaveMode> associatedModeMap;
        private DeleteMode deleteMode;
        private Map<ImmutableType, Set<ImmutableProp>> keyPropMultiMap;
        private boolean autoCheckingAll;
        private Set<ImmutableProp> autoCheckingSet;
        private Set<ImmutableProp> autoUncheckingSet;
        private Map<ImmutableProp, DissociateAction> dissociateActionMap;
        private LockMode lockMode;
        private Map<ImmutableType, BiFunction<Table<?>, Object, Predicate>> optimisticLockLambdaMap;

        Data(JSqlClientImplementor sqlClient) {
            this.sqlClient = sqlClient;
            this.triggers = sqlClient.getTriggerType() == TriggerType.BINLOG_ONLY ? null : sqlClient.getTriggers(true);
            this.frozen = false;
            this.mode = SaveMode.UPSERT;
            this.associatedMode = AssociatedSaveMode.REPLACE;
            this.associatedModeMap = new HashMap<ImmutableProp, AssociatedSaveMode>();
            this.deleteMode = DeleteMode.AUTO;
            this.keyPropMultiMap = new LinkedHashMap<ImmutableType, Set<ImmutableProp>>();
            this.autoCheckingSet = new HashSet<ImmutableProp>();
            this.autoUncheckingSet = new HashSet<ImmutableProp>();
            this.dissociateActionMap = new LinkedHashMap<ImmutableProp, DissociateAction>();
            this.lockMode = LockMode.AUTO;
            this.optimisticLockLambdaMap = new LinkedHashMap();
        }

        Data(Data base) {
            this.sqlClient = base.sqlClient;
            this.triggers = base.triggers;
            this.mode = base.mode;
            this.associatedMode = base.associatedMode;
            this.associatedModeMap = base.associatedModeMap;
            this.deleteMode = base.deleteMode;
            this.keyPropMultiMap = new LinkedHashMap<ImmutableType, Set<ImmutableProp>>(base.keyPropMultiMap);
            this.autoCheckingAll = base.autoCheckingAll;
            this.autoCheckingSet = new HashSet<ImmutableProp>(base.autoCheckingSet);
            this.autoUncheckingSet = new HashSet<ImmutableProp>(base.autoUncheckingSet);
            this.dissociateActionMap = new LinkedHashMap<ImmutableProp, DissociateAction>(base.dissociateActionMap);
            this.lockMode = base.lockMode;
            this.optimisticLockLambdaMap = base.optimisticLockLambdaMap;
            this.frozen = false;
        }

        public JSqlClientImplementor getSqlClient() {
            return this.sqlClient;
        }

        public Triggers getTriggers() {
            return this.triggers;
        }

        public SaveMode getMode() {
            return this.mode;
        }

        public AssociatedSaveMode getAssociatedMode(ImmutableProp prop) {
            AssociatedSaveMode mode = this.associatedModeMap.get(prop);
            return mode != null ? mode : this.associatedMode;
        }

        public DeleteMode getDeleteMode() {
            return this.deleteMode;
        }

        public Set<ImmutableProp> getKeyProps(ImmutableType type) {
            Set<ImmutableProp> keyProps = this.keyPropMultiMap.get(type);
            if (keyProps != null) {
                return keyProps;
            }
            return type.getKeyProps();
        }

        public boolean isAutoCheckingProp(ImmutableProp prop) {
            if (this.autoUncheckingSet.contains(prop)) {
                return false;
            }
            switch (this.sqlClient.getIdOnlyTargetCheckingLevel()) {
                case ALL: {
                    return true;
                }
                case FAKE: {
                    if (prop.isTargetForeignKeyReal(this.sqlClient.getMetadataStrategy())) break;
                    return true;
                }
            }
            return this.autoCheckingAll || this.autoCheckingSet.contains(prop);
        }

        public DissociateAction getDissociateAction(ImmutableProp prop) {
            DissociateAction action = this.dissociateActionMap.get(prop);
            return action != null ? action : prop.getDissociateAction();
        }

        Map<ImmutableProp, DissociateAction> dissociateActionMap() {
            return this.dissociateActionMap;
        }

        LockMode getLockMode() {
            LockMode lockMode = this.lockMode;
            return lockMode != null && lockMode != LockMode.AUTO ? lockMode : this.sqlClient.getDefaultLockMode();
        }

        BiFunction<Table<?>, Object, Predicate> getOptimisticLockLambda(ImmutableType type) {
            return this.optimisticLockLambdaMap.get(type);
        }

        @Override
        public AbstractEntitySaveCommand.Cfg setMode(SaveMode mode) {
            this.validate();
            this.mode = Objects.requireNonNull(mode, "mode cannot be null");
            return this;
        }

        @Override
        public AbstractEntitySaveCommand.Cfg setAssociatedModeAll(AssociatedSaveMode mode) {
            this.associatedMode = mode != null ? mode : AssociatedSaveMode.REPLACE;
            return this;
        }

        @Override
        public AbstractEntitySaveCommand.Cfg setAssociatedMode(ImmutableProp prop, AssociatedSaveMode mode) {
            if (!prop.isAssociation(TargetLevel.PERSISTENT)) {
                throw new IllegalArgumentException("Cannot set associated mode for \"" + prop + "\" because it is ORM association");
            }
            this.associatedModeMap.put(prop, Objects.requireNonNull(mode, "mode cannot be null"));
            return null;
        }

        @Override
        public AbstractEntitySaveCommand.Cfg setAssociatedMode(TypedProp.Association<?, ?> prop, AssociatedSaveMode mode) {
            return this.setAssociatedMode(prop.unwrap(), mode);
        }

        @Override
        public AbstractEntitySaveCommand.Cfg setKeyProps(ImmutableProp ... props) {
            this.validate();
            ImmutableType type = null;
            LinkedHashSet<ImmutableProp> set = new LinkedHashSet<ImmutableProp>();
            for (ImmutableProp prop : props) {
                if (prop == null) continue;
                if (prop.isId()) {
                    throw new IllegalArgumentException("'" + prop + "' cannot be key property because it is id property");
                }
                if (prop.isVersion()) {
                    throw new IllegalArgumentException("'" + prop + "' cannot be key property because it is version property");
                }
                if (!prop.isColumnDefinition()) {
                    throw new IllegalArgumentException("'" + prop + "' cannot be key property because it is not property with column definition");
                }
                if (type == null) {
                    type = prop.getDeclaringType();
                } else if (type != prop.getDeclaringType()) {
                    throw new IllegalArgumentException("all key properties must belong to one type");
                }
                set.add(prop);
            }
            if (type != null) {
                this.keyPropMultiMap.put(type, set);
            }
            return this;
        }

        @Override
        public AbstractEntitySaveCommand.Cfg setAutoIdOnlyTargetCheckingAll() {
            this.autoCheckingAll = true;
            return this;
        }

        @Override
        public AbstractEntitySaveCommand.Cfg setAutoIdOnlyTargetChecking(ImmutableProp prop, boolean checking) {
            if (checking) {
                this.autoCheckingSet.add(prop);
                this.autoUncheckingSet.remove(prop);
            } else {
                this.autoCheckingSet.remove(prop);
                this.autoUncheckingSet.add(prop);
            }
            return this;
        }

        @Override
        public AbstractEntitySaveCommand.Cfg setDissociateAction(ImmutableProp prop, DissociateAction dissociateAction) {
            this.validate();
            if (!prop.isReference(TargetLevel.PERSISTENT) || !prop.isColumnDefinition()) {
                throw new IllegalArgumentException("'" + prop + "' must be an reference property bases on foreign key");
            }
            if (dissociateAction == DissociateAction.SET_NULL && !prop.isNullable()) {
                throw new IllegalArgumentException("'" + prop + "' is not nullable so that it does not support 'on delete set null'");
            }
            if (dissociateAction == DissociateAction.SET_NULL && prop.isInputNotNull()) {
                throw new IllegalArgumentException("'" + prop + "' is `inputNotNull` so that it does not support 'on delete set null'");
            }
            this.dissociateActionMap.put(prop, dissociateAction);
            return this;
        }

        @Override
        public AbstractEntitySaveCommand.Cfg setLockMode(LockMode lockMode) {
            this.lockMode = lockMode;
            return this;
        }

        @Override
        public <E, T extends Table<E>> AbstractEntitySaveCommand.Cfg setOptimisticLock(Class<T> tableType, BiFunction<T, E, Predicate> block) {
            this.setEntityOptimisticLock(ImmutableType.get(tableType), block);
            return this;
        }

        @Override
        public void setEntityOptimisticLock(ImmutableType type, BiFunction<Table<?>, Object, Predicate> block) {
            if (this.optimisticLockLambdaMap.put(type, block) != null) {
                throw new IllegalStateException("The optimistic lock of \"" + type + "\" has already been set");
            }
        }

        @Override
        public AbstractEntitySaveCommand.Cfg setDeleteMode(DeleteMode mode) {
            this.deleteMode = Objects.requireNonNull(mode, "mode cannot be null");
            return this;
        }

        public Data freeze() {
            if (!this.frozen) {
                this.associatedModeMap = Collections.unmodifiableMap(this.associatedModeMap);
                this.keyPropMultiMap = Collections.unmodifiableMap(this.keyPropMultiMap);
                this.autoCheckingSet = Collections.unmodifiableSet(this.autoCheckingSet);
                this.dissociateActionMap = Collections.unmodifiableMap(this.dissociateActionMap);
                this.frozen = true;
            }
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Data)) {
                return false;
            }
            Data data = (Data)o;
            return this.autoCheckingAll == data.autoCheckingAll && this.associatedMode == data.associatedMode && this.lockMode == data.lockMode && this.sqlClient.equals(data.sqlClient) && Objects.equals(this.triggers, data.triggers) && this.mode == data.mode && this.deleteMode == data.deleteMode && this.associatedModeMap.equals(data.associatedModeMap) && this.keyPropMultiMap.equals(data.keyPropMultiMap) && this.autoCheckingSet.equals(data.autoCheckingSet) && this.dissociateActionMap.equals(data.dissociateActionMap);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.sqlClient, this.triggers, this.mode, this.associatedMode, this.associatedModeMap, this.deleteMode, this.keyPropMultiMap, this.autoCheckingAll, this.autoCheckingSet, this.dissociateActionMap, this.lockMode});
        }

        public String toString() {
            return "Data{sqlClient=" + this.sqlClient + ", triggers=" + this.triggers + ", frozen=" + this.frozen + ", mode=" + (Object)((Object)this.mode) + ", associatedMode=" + (Object)((Object)this.associatedMode) + ", associatedModeMap=" + this.associatedModeMap + ", deleteMode=" + (Object)((Object)this.deleteMode) + ", keyPropMultiMap=" + this.keyPropMultiMap + ", autoCheckingAll=" + this.autoCheckingAll + ", autoCheckingSet=" + this.autoCheckingSet + ", autoUncheckingSet=" + this.autoUncheckingSet + ", dissociateActionMap=" + this.dissociateActionMap + ", lockMode=" + (Object)((Object)this.lockMode) + ", optimisticLockLambdaMap=" + this.optimisticLockLambdaMap + '}';
        }

        private void validate() {
            if (this.frozen) {
                throw new IllegalStateException("The current configuration is frozen");
            }
        }
    }
}

