/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.runtime;

import java.sql.PreparedStatement;
import java.util.Iterator;
import java.util.List;
import org.babyfish.jimmer.sql.collection.TypedList;
import org.babyfish.jimmer.sql.runtime.DbLiteral;
import org.babyfish.jimmer.sql.runtime.ExecutionException;
import org.babyfish.jimmer.sql.runtime.Executor;
import org.babyfish.jimmer.sql.runtime.JSqlClientImplementor;
import org.babyfish.jimmer.sql.runtime.ParameterIndex;
import org.jetbrains.annotations.NotNull;

public class DefaultExecutor
implements Executor {
    public static final DefaultExecutor INSTANCE = new DefaultExecutor();

    DefaultExecutor() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <R> R execute(@NotNull Executor.Args<R> args) {
        String sql = args.sql;
        List<Object> variables = args.variables;
        JSqlClientImplementor sqlClient = args.sqlClient;
        try (PreparedStatement stmt = args.statementFactory != null ? args.statementFactory.preparedStatement(args.con, sql) : args.con.prepareStatement(sql);){
            ParameterIndex parameterIndex = new ParameterIndex();
            for (Object variable : variables) {
                if (variable instanceof DbLiteral) {
                    DbLiteral literal = (DbLiteral)variable;
                    literal.setParameter(stmt, parameterIndex, sqlClient);
                    continue;
                }
                if (variable instanceof TypedList) {
                    TypedList typedList = (TypedList)variable;
                    stmt.setArray(parameterIndex.get(), args.con.createArrayOf(typedList.getSqlElementType(), typedList.toArray()));
                    continue;
                }
                stmt.setObject(parameterIndex.get(), variable);
            }
            Iterator<Object> iterator = args.block.apply(stmt);
            return (R)iterator;
        }
        catch (Exception ex) {
            throw new ExecutionException("Cannot execute SQL statement: " + sql + ", variables: " + variables, ex);
        }
    }
}

