/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.fetcher.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.babyfish.jimmer.meta.Dependency;
import org.babyfish.jimmer.meta.EmbeddedLevel;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.meta.PropId;
import org.babyfish.jimmer.meta.TargetLevel;
import org.babyfish.jimmer.sql.ManyToManyView;
import org.babyfish.jimmer.sql.ast.table.Table;
import org.babyfish.jimmer.sql.fetcher.Fetcher;
import org.babyfish.jimmer.sql.fetcher.Field;
import org.babyfish.jimmer.sql.fetcher.FieldConfig;
import org.babyfish.jimmer.sql.fetcher.FieldFilter;
import org.babyfish.jimmer.sql.fetcher.IdOnlyFetchType;
import org.babyfish.jimmer.sql.fetcher.RecursionStrategy;
import org.babyfish.jimmer.sql.fetcher.impl.DefaultRecursionStrategy;
import org.babyfish.jimmer.sql.fetcher.impl.FetcherImplementor;
import org.babyfish.jimmer.sql.fetcher.impl.FetcherMergeContext;
import org.babyfish.jimmer.sql.fetcher.impl.FetcherWriter;
import org.babyfish.jimmer.sql.fetcher.impl.FieldConfigImpl;
import org.babyfish.jimmer.sql.fetcher.impl.FieldImpl;
import org.babyfish.jimmer.sql.fetcher.impl.MiddleEntityJoinFieldFilter;
import org.babyfish.jimmer.sql.meta.FormulaTemplate;

public class FetcherImpl<E>
implements FetcherImplementor<E> {
    final FetcherImpl<E> prev;
    private final ImmutableType immutableType;
    final boolean negative;
    final boolean implicit;
    final boolean rawId;
    final ImmutableProp prop;
    private final FieldFilter<?> filter;
    private final int batchSize;
    private final int limit;
    private final int offset;
    private final RecursionStrategy<?> recursionStrategy;
    final FetcherImpl<?> childFetcher;
    private Map<String, Field> fieldMap;
    private Map<String, Field> unresolvedFieldMap;
    private List<PropId> shownPropIds;
    private List<PropId> hiddenPropIds;
    private Boolean isSimpleFetcher;
    private transient int hash;

    public FetcherImpl(Class<E> javaClass) {
        this(javaClass, null);
    }

    public FetcherImpl(Class<E> javaClass, FetcherImpl<E> base) {
        if (base != null) {
            if (base.getJavaClass() != javaClass) {
                throw new IllegalArgumentException("The owner type of base fetcher must be \"" + javaClass.getName() + "\"");
            }
            this.prev = base.prev;
            this.immutableType = base.immutableType;
            this.negative = base.negative;
            this.implicit = base.implicit;
            this.rawId = base.rawId;
            this.prop = base.prop;
            this.filter = base.filter;
            this.batchSize = base.batchSize;
            this.limit = base.limit;
            this.offset = base.offset;
            this.recursionStrategy = base.recursionStrategy;
            this.childFetcher = base.childFetcher;
        } else {
            this.prev = null;
            this.immutableType = ImmutableType.get(javaClass);
            this.negative = false;
            this.implicit = false;
            this.rawId = false;
            this.prop = this.immutableType.getIdProp();
            this.filter = null;
            this.batchSize = 0;
            this.limit = Integer.MAX_VALUE;
            this.offset = 0;
            this.recursionStrategy = null;
            this.childFetcher = null;
        }
    }

    protected FetcherImpl(FetcherImpl<E> prev, ImmutableProp prop, boolean negative, IdOnlyFetchType idOnlyFetchType) {
        this.prev = prev;
        this.immutableType = prev.immutableType;
        this.negative = negative;
        this.implicit = false;
        this.rawId = idOnlyFetchType == IdOnlyFetchType.RAW;
        this.prop = prop;
        this.filter = null;
        this.batchSize = 0;
        this.limit = Integer.MAX_VALUE;
        this.offset = 0;
        this.recursionStrategy = null;
        this.childFetcher = negative || !prop.isAssociation(TargetLevel.PERSISTENT) ? null : new FetcherImpl<E>(prop.getTargetType().getJavaClass());
    }

    protected FetcherImpl(FetcherImpl<E> prev, ImmutableProp prop, FieldConfig<?, ? extends Table<?>> fieldConfig) {
        this.prev = prev;
        this.immutableType = prev.immutableType;
        this.negative = false;
        this.implicit = false;
        this.rawId = false;
        this.prop = prop;
        if (fieldConfig != null) {
            FieldConfigImpl loaderImpl = (FieldConfigImpl)fieldConfig;
            this.filter = loaderImpl.getFilter();
            this.batchSize = loaderImpl.getBatchSize();
            this.limit = prop.isReferenceList(TargetLevel.PERSISTENT) ? loaderImpl.getLimit() : Integer.MAX_VALUE;
            this.offset = prop.isAssociation(TargetLevel.PERSISTENT) ? loaderImpl.getOffset() : 0;
            this.recursionStrategy = loaderImpl.getRecursionStrategy();
            this.childFetcher = FetcherImpl.standardChildFetcher(loaderImpl);
        } else {
            this.filter = null;
            this.batchSize = 0;
            this.limit = Integer.MAX_VALUE;
            this.offset = 0;
            this.recursionStrategy = null;
            this.childFetcher = null;
        }
    }

    FetcherImpl(FetcherImpl<E> prev, FetcherImpl<E> base, FetcherImpl<?> child) {
        this.prev = prev;
        this.immutableType = base.immutableType;
        this.negative = base.negative;
        this.implicit = false;
        this.rawId = base.rawId;
        this.prop = base.prop;
        this.filter = base.filter;
        this.batchSize = base.batchSize;
        this.limit = base.limit;
        this.offset = base.offset;
        this.recursionStrategy = child != null ? base.recursionStrategy : null;
        this.childFetcher = child;
    }

    public FetcherImpl(FetcherImpl<E> prev, ImmutableProp prop, FetcherImpl<?> child, boolean implicit) {
        this.prev = prev;
        this.immutableType = prev != null ? prev.immutableType : prop.getDeclaringType();
        this.negative = false;
        this.implicit = implicit;
        this.rawId = false;
        this.prop = prop;
        this.filter = null;
        this.batchSize = prev != null ? prev.batchSize : 0;
        this.limit = Integer.MAX_VALUE;
        this.offset = 0;
        this.recursionStrategy = null;
        this.childFetcher = child;
    }

    @Override
    public Class<E> getJavaClass() {
        return this.immutableType.getJavaClass();
    }

    @Override
    public ImmutableType getImmutableType() {
        return this.immutableType;
    }

    @Override
    public Map<String, Field> getFieldMap() {
        Map<String, Field> map = this.fieldMap;
        if (map == null) {
            map = new HashMap<String, Field>();
            LinkedList<Object> orderedNames = new LinkedList<Object>();
            FetcherImpl<E> fetcher = this;
            while (fetcher != null) {
                if (fetcher.prop != null) {
                    String name = fetcher.prop.getName();
                    FieldImpl field = fetcher.negative ? null : new FieldImpl(this.immutableType, fetcher.prop, fetcher.filter, fetcher.batchSize, fetcher.limit, fetcher.offset, fetcher.recursionStrategy, fetcher.recursionStrategy == null ? fetcher.childFetcher : super.realRecursiveChild(fetcher), fetcher.implicit, fetcher.rawId);
                    if (!map.containsKey(name)) {
                        map.putIfAbsent(name, field);
                        orderedNames.add(0, name);
                    }
                }
                fetcher = fetcher.prev;
            }
            LinkedHashMap<String, Field> orderedMap = new LinkedHashMap<String, Field>();
            LinkedList<Field> extensionFields = new LinkedList<Field>();
            for (String string : orderedNames) {
                Field field = map.get(string);
                if (field == null) continue;
                orderedMap.put(string, field);
                ImmutableProp prop = field.getProp();
                if (prop.getDependencies().isEmpty()) continue;
                extensionFields.add(field);
            }
            while (!extensionFields.isEmpty()) {
                Field field = (Field)extensionFields.remove(0);
                for (Dependency dependency : field.getProp().getDependencies()) {
                    Fetcher<E> childFetcher;
                    ImmutableProp depProp = (ImmutableProp)dependency.getProps().get(0);
                    ImmutableProp deeperDepProp = dependency.getProps().size() > 1 ? (ImmutableProp)dependency.getProps().get(1) : null;
                    Field dependencyField = (Field)orderedMap.get(depProp.getName());
                    if (dependencyField == null) {
                        childFetcher = field.getProp().getManyToManyViewBaseProp() != null ? (FetcherImpl)new FetcherImpl<E>(depProp.getTargetType().getJavaClass()).add(deeperDepProp.getName(), (Fetcher)field.getChildFetcher()) : (deeperDepProp != null ? FetcherImpl.createEmbeddedFormulaChildFetcher(dependency) : null);
                        dependencyField = new FieldImpl(this.immutableType, depProp, deeperDepProp != null && this.filter != null ? new MiddleEntityJoinFieldFilter(field.getFilter(), deeperDepProp.getName()) : null, field.getBatchSize(), field.getLimit(), field.getOffset(), null, (FetcherImpl<?>)childFetcher, true, false);
                        orderedMap.put(depProp.getName(), dependencyField);
                        if (this.prop == null || !this.prop.isFormula() || this.prop.getSqlTemplate() instanceof FormulaTemplate) continue;
                        extensionFields.add(dependencyField);
                        continue;
                    }
                    if (deeperDepProp == null) continue;
                    childFetcher = (FetcherImpl)dependencyField.getChildFetcher();
                    try {
                        if (this.prop != null && this.prop.getManyToManyViewBaseProp() != null) {
                            Field deeperField = childFetcher.getFieldMap().get(deeperDepProp.getName());
                            Fetcher<?> deeperFetcher = deeperField != null ? deeperField.getChildFetcher() : null;
                            childFetcher = childFetcher.add(deeperDepProp.getName(), (Fetcher)new FetcherMergeContext().merge(field.getChildFetcher(), deeperFetcher, depProp.isEmbedded(EmbeddedLevel.SCALAR)));
                        } else {
                            childFetcher = (FetcherImplementor)new FetcherMergeContext().merge(FetcherImpl.createEmbeddedFormulaChildFetcher(dependency), childFetcher, depProp.isEmbedded(EmbeddedLevel.SCALAR));
                        }
                    }
                    catch (FetcherMergeContext.ConflictException ex) {
                        throw new IllegalArgumentException("Cannot merge the fetcher field \"" + field.getProp().getName() + ex.path + "\" and \"" + depProp.getName() + '.' + deeperDepProp.getName() + ex.path + "\", the configuration `" + ex.cfgName + "` is conflict");
                    }
                    dependencyField = new FieldImpl((FieldImpl)dependencyField, (FetcherImpl<?>)childFetcher);
                    orderedMap.put(depProp.getName(), dependencyField);
                }
            }
            this.fieldMap = map = Collections.unmodifiableMap(orderedMap);
        }
        return map;
    }

    @Override
    public Map<String, Field> __unresolvedFieldMap() {
        Map<String, Field> map = this.unresolvedFieldMap;
        if (map == null) {
            map = new LinkedHashMap<String, Field>();
            for (Map.Entry<String, Field> e : this.getFieldMap().entrySet()) {
                Field field = e.getValue();
                ImmutableProp prop = field.getProp();
                if (!prop.getDependencies().isEmpty() || !prop.hasTransientResolver() && !prop.isAssociation(TargetLevel.ENTITY)) continue;
                map.put(e.getKey(), field);
            }
            map = map.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(map);
            this.unresolvedFieldMap = map;
        }
        return map;
    }

    @Override
    public List<PropId> __shownPropIds() {
        List<Object> list = this.shownPropIds;
        if (list == null) {
            list = new ArrayList<PropId>();
            for (Field field : this.getFieldMap().values()) {
                ImmutableProp prop = field.getProp();
                if (prop.getDependencies().isEmpty()) continue;
                list.add(prop.getId());
            }
            list = list.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(list);
            this.shownPropIds = list;
        }
        return list;
    }

    @Override
    public List<PropId> __hiddenPropIds() {
        List<Object> list = this.hiddenPropIds;
        if (list == null) {
            list = new ArrayList<PropId>();
            for (Field field : this.getFieldMap().values()) {
                if (!field.isImplicit()) continue;
                list.add(field.getProp().getId());
            }
            list = list.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(list);
            this.hiddenPropIds = list;
        }
        return list;
    }

    @Override
    public FetcherImplementor<E> allTableFields() {
        FetcherImpl<E> fetcher = this;
        for (ImmutableProp prop : this.immutableType.getSelectableProps().values()) {
            ImmutableProp idViewProp = prop.getIdViewProp();
            fetcher = fetcher.addImpl(idViewProp != null ? idViewProp : prop, null);
        }
        return fetcher;
    }

    @Override
    public FetcherImplementor<E> allScalarFields() {
        FetcherImpl<E> fetcher = this;
        for (ImmutableProp prop : this.immutableType.getSelectableScalarProps().values()) {
            fetcher = fetcher.addImpl(prop, null);
        }
        return fetcher;
    }

    @Override
    public Fetcher<E> allReferenceFields() {
        FetcherImpl<E> fetcher = this;
        for (ImmutableProp prop : this.immutableType.getReferenceProps().values()) {
            ImmutableProp idViewProp = prop.getIdViewProp();
            fetcher = fetcher.addImpl(idViewProp != null ? idViewProp : prop, null);
        }
        return fetcher;
    }

    @Override
    public FetcherImplementor<E> add(String prop) {
        ImmutableProp immutableProp = this.immutableType.getProp(prop);
        return this.addImpl(immutableProp, false, IdOnlyFetchType.DEFAULT);
    }

    @Override
    public FetcherImplementor<E> remove(String prop) {
        ImmutableProp immutableProp = this.immutableType.getProp(prop);
        if (immutableProp.isId()) {
            throw new IllegalArgumentException("Id property \"" + immutableProp + "\" cannot be removed");
        }
        return this.addImpl(immutableProp, true, IdOnlyFetchType.DEFAULT);
    }

    @Override
    public FetcherImplementor<E> add(String prop, Fetcher<?> childFetcher) {
        return this.add(prop, (Fetcher)childFetcher, (Consumer)null);
    }

    @Override
    public FetcherImplementor<E> add(String prop, Fetcher<?> childFetcher, Consumer<? extends FieldConfig<?, ? extends Table<?>>> loaderBlock) {
        Objects.requireNonNull(prop, "'prop' cannot be null");
        ImmutableProp immutableProp = this.immutableType.getProp(prop);
        if (childFetcher != null && !immutableProp.isAssociation(TargetLevel.ENTITY) && !immutableProp.isEmbedded(EmbeddedLevel.SCALAR)) {
            throw new IllegalArgumentException("Cannot load the property \"" + immutableProp + "\" with child fetcher because it is neither association nor embeddable");
        }
        if (childFetcher != null && immutableProp.getTargetType().getJavaClass() != childFetcher.getJavaClass()) {
            throw new IllegalArgumentException("Illegal type of childFetcher");
        }
        FieldConfigImpl<Object, Table<Object>> loaderImpl = new FieldConfigImpl<Object, Table<Object>>(immutableProp, (FetcherImpl)childFetcher);
        if (loaderBlock != null) {
            loaderBlock.accept(loaderImpl);
            FetcherImpl.validateConfig(immutableProp, loaderImpl);
            if (loaderImpl.getRecursionStrategy() != null) {
                FetcherImpl.validateRecursiveProp(immutableProp);
                if (childFetcher != null) {
                    throw new IllegalArgumentException("Fetcher field based on \"" + immutableProp + "\" cannot have child fetcher because itself is recursive field");
                }
            }
        }
        return this.addImpl(immutableProp, loaderImpl);
    }

    @Override
    public FetcherImplementor<E> addRecursion(String prop, Consumer<? extends FieldConfig<?, ? extends Table<?>>> loaderBlock) {
        Objects.requireNonNull(prop, "'prop' cannot be null");
        ImmutableProp immutableProp = this.immutableType.getProp(prop);
        FetcherImpl.validateRecursiveProp(immutableProp);
        FieldConfigImpl<Object, Table<Object>> loaderImpl = new FieldConfigImpl<Object, Table<Object>>(immutableProp, null);
        if (loaderBlock != null) {
            loaderBlock.accept(loaderImpl);
            FetcherImpl.validateConfig(immutableProp, loaderImpl);
        }
        if (loaderImpl.getRecursionStrategy() == null) {
            loaderImpl.recursive((RecursionStrategy)DefaultRecursionStrategy.of(Integer.MAX_VALUE));
        }
        return this.addImpl(immutableProp, loaderImpl);
    }

    @Override
    public FetcherImplementor<E> add(String prop, IdOnlyFetchType idOnlyFetchType) {
        Objects.requireNonNull(prop, "'prop' cannot be null");
        ImmutableProp immutableProp = this.immutableType.getProp(prop);
        ImmutableProp associationProp = immutableProp.getIdViewBaseProp();
        if (associationProp == null) {
            associationProp = immutableProp;
        }
        if (!associationProp.isAssociation(TargetLevel.PERSISTENT) || associationProp.getMappedBy() != null) {
            idOnlyFetchType = IdOnlyFetchType.DEFAULT;
        }
        return this.addImpl(immutableProp, false, idOnlyFetchType);
    }

    private FetcherImpl<E> addImpl(ImmutableProp prop, boolean negative, IdOnlyFetchType idOnlyFetchType) {
        if (prop.isId()) {
            return this;
        }
        if (prop.isTransient() && !prop.hasTransientResolver()) {
            throw new IllegalArgumentException("Cannot fetch \"" + prop + "\", it is transient property without resolver");
        }
        return this.createFetcher(prop, negative, idOnlyFetchType);
    }

    private FetcherImpl<E> addImpl(ImmutableProp prop, FieldConfigImpl<?, ? extends Table<?>> loader) {
        if (prop.isId()) {
            return this;
        }
        return this.createFetcher(prop, loader);
    }

    private FetcherImpl<E> realRecursiveChild(FetcherImpl<E> recursivePropHolder) {
        ArrayList<FetcherImpl<E>> subFetchers = new ArrayList<FetcherImpl<E>>();
        FetcherImpl<E> f = this;
        while (f != null) {
            if (!f.negative && f.recursionStrategy == null) {
                subFetchers.add(f);
            }
            f = f.prev;
        }
        FetcherImpl<E> realRecursiveChild = new FetcherImpl<E>(this.getJavaClass());
        for (int i = subFetchers.size() - 1; i >= 0; --i) {
            FetcherImpl subFetcher = (FetcherImpl)subFetchers.get(i);
            realRecursiveChild = new FetcherImpl<E>(realRecursiveChild, subFetcher, subFetcher.childFetcher);
        }
        if (recursivePropHolder.prop.isColumnDefinition()) {
            realRecursiveChild = new FetcherImpl<E>(realRecursiveChild, recursivePropHolder, null);
        }
        return realRecursiveChild;
    }

    public int hashCode() {
        int h = this.hash;
        if (h == 0) {
            h = this.immutableType.hashCode() ^ this.getFieldMap().hashCode();
            if (h == 0) {
                h = -1;
            }
            this.hash = h;
        }
        return h;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Fetcher)) {
            return false;
        }
        Fetcher other = (Fetcher)obj;
        return this.immutableType == other.getImmutableType() && this.getFieldMap().equals(other.getFieldMap());
    }

    public String toString() {
        return this.toString(false);
    }

    @Override
    public String toString(boolean multiLine) {
        FetcherWriter writer = new FetcherWriter(multiLine ? 4 : 0);
        writer.writeRoot(this);
        return writer.toString();
    }

    @Override
    public boolean __isSimpleFetcher() {
        Boolean isSimple = this.isSimpleFetcher;
        if (isSimple == null) {
            isSimple = true;
            for (Field field : this.getFieldMap().values()) {
                if (field.isSimpleField()) continue;
                isSimple = false;
                break;
            }
            this.isSimpleFetcher = isSimple;
        }
        return isSimple;
    }

    protected FetcherImpl<E> createFetcher(ImmutableProp prop, boolean negative, IdOnlyFetchType idOnlyFetchType) {
        return new FetcherImpl<E>(this, prop, negative, idOnlyFetchType);
    }

    protected FetcherImpl<E> createFetcher(ImmutableProp prop, FieldConfig<?, ? extends Table<?>> fieldConfig) {
        return new FetcherImpl<E>(this, prop, fieldConfig);
    }

    private static FetcherImpl<?> standardChildFetcher(FieldConfigImpl<?, Table<?>> loaderImpl) {
        FetcherImpl childFetcher = loaderImpl.getChildFetcher();
        if (!loaderImpl.getProp().isColumnDefinition()) {
            return childFetcher;
        }
        RecursionStrategy<?> strategy = loaderImpl.getRecursionStrategy();
        if (strategy == null) {
            return childFetcher;
        }
        if (strategy instanceof DefaultRecursionStrategy && ((DefaultRecursionStrategy)strategy).getDepth() == 1) {
            return childFetcher;
        }
        if (childFetcher == null) {
            childFetcher = new FetcherImpl(loaderImpl.getProp().getElementClass());
        }
        childFetcher = (FetcherImpl)childFetcher.add(loaderImpl.getProp().getName());
        return childFetcher;
    }

    private static void validateRecursiveProp(ImmutableProp immutableProp) {
        if (!immutableProp.isAssociation(TargetLevel.ENTITY)) {
            throw new IllegalArgumentException("Fetcher field based on \"" + immutableProp + "\" cannot be recursive because it is the property is not association");
        }
        if (!immutableProp.getDeclaringType().isEntity()) {
            throw new IllegalArgumentException("Fetcher field based on \"" + immutableProp + "\" cannot be recursive because the declaring type \"" + immutableProp.getDeclaringType() + "\" is not entity type");
        }
        if (!immutableProp.getDeclaringType().isAssignableFrom(immutableProp.getTargetType())) {
            throw new IllegalArgumentException("Fetcher field based on \"" + immutableProp + "\" cannot be recursive because the declaring type \"" + immutableProp.getDeclaringType() + "\" is not assignable from the target type \"" + immutableProp.getTargetType() + "\"");
        }
    }

    private static void validateConfig(ImmutableProp immutableProp, FieldConfigImpl<Object, Table<Object>> loaderImpl) {
        if (immutableProp.isRemote()) {
            if (loaderImpl.getFilter() != null) {
                throw new IllegalArgumentException("Fetcher field based one \"" + immutableProp + "\" does not support `filter` because the association is remote");
            }
            if (loaderImpl.getLimit() != Integer.MAX_VALUE || loaderImpl.getOffset() != 0) {
                if (immutableProp.isRemote()) {
                    throw new IllegalArgumentException("Fetcher field based one \"" + immutableProp + "\" does not support `pagination` because the association is remote");
                }
                if (!immutableProp.isReferenceList(TargetLevel.PERSISTENT)) {
                    throw new IllegalArgumentException("Fetcher field based one \"" + immutableProp + "\" does not support `pagination` because the association is not list(one-to-many/many-to-many)");
                }
            }
        }
        if (immutableProp.getManyToManyViewBaseProp() != null && loaderImpl.getRecursionStrategy() != null) {
            throw new IllegalArgumentException("Fetcher field based on \"" + immutableProp + "\" does not support recursion strategy because it is decorated by @" + ManyToManyView.class.getName());
        }
    }

    private static FetcherImpl<?> createEmbeddedFormulaChildFetcher(Dependency dependency) {
        List props = dependency.getProps();
        if (props.size() < 2) {
            return null;
        }
        FetcherImpl childFetcher = null;
        for (int i = props.size() - 1; i > 0; --i) {
            ImmutableProp prop = (ImmutableProp)props.get(i);
            childFetcher = new FetcherImpl(null, prop, childFetcher, true);
        }
        return childFetcher;
    }
}

