/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.mutation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.runtime.ImmutableSpi;

class SavedShape {
    private final List<ImmutableProp> props;
    private final int hash;

    private SavedShape(List<ImmutableProp> props, int hash) {
        this.props = props;
        this.hash = hash;
    }

    public static SavedShape of(ImmutableSpi spi) {
        ArrayList<ImmutableProp> props = new ArrayList<ImmutableProp>();
        int hash = 0;
        for (ImmutableProp prop : spi.__type().getProps().values()) {
            if (!spi.__isLoaded(prop.getId())) continue;
            props.add(prop);
            hash += prop.hashCode();
        }
        return new SavedShape(Collections.unmodifiableList(props), hash);
    }

    public List<ImmutableProp> getProps() {
        return this.props;
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SavedShape)) {
            return false;
        }
        SavedShape other = (SavedShape)obj;
        return this.hash == other.hash && this.props.equals(other.props);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append('[');
        boolean addComma = false;
        for (ImmutableProp prop : this.props) {
            if (addComma) {
                builder.append(", ");
            } else {
                addComma = true;
            }
            builder.append(prop.getName());
        }
        builder.append(']');
        return builder.toString();
    }
}

