/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.mutation;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.meta.LogicalDeletedInfo;
import org.babyfish.jimmer.meta.PropId;
import org.babyfish.jimmer.runtime.DraftSpi;
import org.babyfish.jimmer.runtime.ImmutableSpi;
import org.babyfish.jimmer.runtime.Internal;
import org.babyfish.jimmer.sql.DissociateAction;
import org.babyfish.jimmer.sql.LogicalDeleted;
import org.babyfish.jimmer.sql.ast.Predicate;
import org.babyfish.jimmer.sql.ast.impl.AstContext;
import org.babyfish.jimmer.sql.ast.impl.mutation.ChildTableOperator;
import org.babyfish.jimmer.sql.ast.impl.mutation.DeleteCommandImpl;
import org.babyfish.jimmer.sql.ast.impl.mutation.MiddleTableOperator;
import org.babyfish.jimmer.sql.ast.impl.mutation.MutationCache;
import org.babyfish.jimmer.sql.ast.impl.mutation.MutationTrigger;
import org.babyfish.jimmer.sql.ast.impl.mutation.NativePredicates;
import org.babyfish.jimmer.sql.ast.impl.query.FilterLevel;
import org.babyfish.jimmer.sql.ast.impl.query.MutableRootQueryImpl;
import org.babyfish.jimmer.sql.ast.impl.table.TableImplementor;
import org.babyfish.jimmer.sql.ast.mutation.AffectedTable;
import org.babyfish.jimmer.sql.ast.mutation.DeleteMode;
import org.babyfish.jimmer.sql.ast.mutation.DeleteResult;
import org.babyfish.jimmer.sql.ast.tuple.Tuple3;
import org.babyfish.jimmer.sql.event.TriggerType;
import org.babyfish.jimmer.sql.meta.ColumnDefinition;
import org.babyfish.jimmer.sql.meta.MetadataStrategy;
import org.babyfish.jimmer.sql.meta.SingleColumn;
import org.babyfish.jimmer.sql.meta.SqlContext;
import org.babyfish.jimmer.sql.runtime.DissociationInfo;
import org.babyfish.jimmer.sql.runtime.ExecutionException;
import org.babyfish.jimmer.sql.runtime.ExecutionPurpose;
import org.babyfish.jimmer.sql.runtime.Executor;
import org.babyfish.jimmer.sql.runtime.Reader;
import org.babyfish.jimmer.sql.runtime.SqlBuilder;

public class Deleter {
    private final DeleteCommandImpl.Data data;
    private final Connection con;
    private final MutationCache cache;
    private final MutationTrigger trigger;
    private final Map<AffectedTable, Integer> affectedRowCountMap;
    private Map<ImmutableType, Set<Object>> preHandleIdInputMap = new LinkedHashMap<ImmutableType, Set<Object>>();
    private Map<ImmutableType, Set<Object>> postHandleIdInputMap = new LinkedHashMap<ImmutableType, Set<Object>>();
    private final Map<String, Deleter> childDeleterMap = new LinkedHashMap<String, Deleter>();

    Deleter(DeleteCommandImpl.Data data, Connection con, MutationCache cache, MutationTrigger trigger, Map<AffectedTable, Integer> affectedRowCountMap) {
        this.data = data;
        this.con = con;
        this.cache = cache;
        this.trigger = trigger;
        this.affectedRowCountMap = affectedRowCountMap;
    }

    public void addPreHandleInput(ImmutableType type, Collection<?> ids) {
        Set idSet = this.preHandleIdInputMap.computeIfAbsent(type, t -> new LinkedHashSet());
        for (Object id : ids) {
            if (id == null) continue;
            idSet.add(id);
        }
    }

    private void addPostHandleInput(ImmutableType type, Collection<?> ids) {
        Set idSet = this.postHandleIdInputMap.computeIfAbsent(type, t -> new LinkedHashSet());
        for (Object id : ids) {
            if (id == null) continue;
            idSet.add(id);
        }
    }

    private void addOutput(AffectedTable affectTable, int affectedRowCount) {
        if (affectedRowCount != 0) {
            this.affectedRowCountMap.merge(affectTable, affectedRowCount, Integer::sum);
        }
    }

    public DeleteResult execute() {
        return this.execute(true);
    }

    public DeleteResult execute(boolean submit) {
        while (!this.preHandleIdInputMap.isEmpty() || !this.postHandleIdInputMap.isEmpty()) {
            while (!this.preHandleIdInputMap.isEmpty()) {
                this.preHandle();
            }
            this.postHandle();
        }
        MutationTrigger trigger = this.trigger;
        if (!submit || trigger == null) {
            return new DeleteResult(this.affectedRowCountMap);
        }
        trigger.submit(this.data.getSqlClient(), this.con);
        return new DeleteResult(this.affectedRowCountMap);
    }

    private void preHandle() {
        Map<ImmutableType, Set<Object>> idMultiMap = this.preHandleIdInputMap;
        this.preHandleIdInputMap = new LinkedHashMap<ImmutableType, Set<Object>>();
        for (Map.Entry<ImmutableType, Set<Object>> e : idMultiMap.entrySet()) {
            this.preHandle(e.getKey(), (Collection<Object>)e.getValue());
        }
    }

    private void preHandle(ImmutableType immutableType, Collection<Object> ids) {
        if (ids.isEmpty()) {
            return;
        }
        DissociationInfo dissociationInfo = this.data.getSqlClient().getEntityManager().getDissociationInfo(immutableType);
        if (dissociationInfo != null) {
            MiddleTableOperator middleTableOperator;
            for (ImmutableProp prop : dissociationInfo.getProps()) {
                int affectedRowCount;
                middleTableOperator = MiddleTableOperator.tryGet(this.data.getSqlClient(), this.con, prop, this.trigger);
                if (!middleTableOperator.isActive() || middleTableOperator.isCascadeDeletedBySource()) continue;
                try {
                    boolean logical = this.logical(immutableType);
                    affectedRowCount = logical && middleTableOperator.isLogicalDeletionSupported() ? middleTableOperator.logicallyDeleteBySourceIds(ids) : (!logical || middleTableOperator.isDeletedWhenEndpointIsLogicallyDeleted() ? middleTableOperator.physicallyDeleteBySourceIds(ids) : 0);
                }
                catch (MiddleTableOperator.DeletionPreventedException ex) {
                    throw new ExecutionException("Cannot delete rows from middle table \"" + ex.middleTable.getTableName() + "\" when the object of \"" + immutableType + "\" is being deleted, because the `@JoinTable.preventDeletionBySource` of \"" + prop.getMappedBy() + "\" is true");
                }
                this.addOutput(AffectedTable.of(prop), affectedRowCount);
            }
            for (ImmutableProp backProp : dissociationInfo.getBackProps()) {
                middleTableOperator = MiddleTableOperator.tryGetByBackProp(this.data.getSqlClient(), this.con, backProp, this.trigger);
                if (middleTableOperator != null && middleTableOperator.isActive() && !middleTableOperator.isCascadeDeletedByTarget()) {
                    int affectedRowCount;
                    try {
                        boolean logical = this.logical(immutableType);
                        affectedRowCount = logical && middleTableOperator.isLogicalDeletionSupported() ? middleTableOperator.logicallyDeleteBySourceIds(ids) : (!logical || middleTableOperator.isDeletedWhenEndpointIsLogicallyDeleted() ? middleTableOperator.physicallyDeleteBySourceIds(ids) : 0);
                    }
                    catch (MiddleTableOperator.DeletionPreventedException ex) {
                        throw new ExecutionException("Cannot delete rows from middle table \"" + ex.middleTable.getTableName() + "\" when the object of \"" + immutableType + "\" is being deleted, because the " + (backProp.getMappedBy() != null ? "`@JoinTable.preventDeletionBySource` of \"" + backProp.getMappedBy() + "\" is true" : "`@JoinTable.preventDeletionByTarget` of \"" + backProp + "\" is true"));
                    }
                    this.addOutput(AffectedTable.of(backProp), affectedRowCount);
                    continue;
                }
                if (middleTableOperator != null) continue;
                DissociateAction dissociateAction = this.data.getDissociateAction(backProp);
                if (dissociateAction == DissociateAction.SET_NULL) {
                    ChildTableOperator childTableOperator = new ChildTableOperator(this.data.getSqlClient(), this.con, backProp, false, this.cache, this.trigger);
                    int affectedRowCount = childTableOperator.unsetParents(ids);
                    this.addOutput(AffectedTable.of(backProp.getDeclaringType()), affectedRowCount);
                    continue;
                }
                if (dissociateAction == DissociateAction.LAX) {
                    TriggerType triggerType = this.data.getSqlClient().getTriggerType();
                    if (triggerType == TriggerType.BINLOG_ONLY || this.logical(backProp.getTargetType()) || !backProp.isTargetForeignKeyReal(this.data.getSqlClient().getMetadataStrategy())) continue;
                    throw new ExecutionException("There is foreign key constraint for property \"" + backProp + "\" and the dissociate action is \"LAX\", that means \"on delete cascade\" of foreign key constraint is required and child objects of the deleted object will be automatically deleted by database. However, the trigger type is \"" + triggerType.name() + "\" which is not allowed, because there is not way to known the database changeset before transaction commit");
                }
                this.tryDeleteFromChildTable(backProp, ids);
            }
        }
        this.addPostHandleInput(immutableType, ids);
    }

    private void tryDeleteFromChildTable(ImmutableProp backProp, Collection<?> ids) {
        List childIds;
        ImmutableType childType = backProp.getDeclaringType();
        FilterLevel filterLevel = this.data.getMode() != DeleteMode.PHYSICAL && this.logical(backProp.getDeclaringType()) ? FilterLevel.DEFAULT : FilterLevel.IGNORE_ALL;
        if (this.trigger != null || filterLevel != FilterLevel.IGNORE_ALL) {
            childIds = this.findChildIdsByDsl(backProp, ids, filterLevel);
        } else {
            MetadataStrategy strategy = this.data.getSqlClient().getMetadataStrategy();
            ColumnDefinition definition = (ColumnDefinition)backProp.getStorage(strategy);
            SqlBuilder builder = new SqlBuilder(new AstContext(this.data.getSqlClient()));
            Reader<?> reader = this.data.getSqlClient().getReader(childType.getIdProp());
            builder.enter(SqlBuilder.ScopeType.SELECT).definition((ColumnDefinition)childType.getIdProp().getStorage(strategy)).leave().from().sql(childType.getTableName(strategy)).enter(SqlBuilder.ScopeType.WHERE);
            NativePredicates.renderPredicates(false, definition, ids, builder);
            builder.leave();
            Tuple3<String, List<Object>, List<Integer>> sqlResult = builder.build();
            childIds = this.data.getSqlClient().getExecutor().execute(new Executor.Args<List>(this.data.getSqlClient(), this.con, sqlResult.get_1(), sqlResult.get_2(), sqlResult.get_3(), ExecutionPurpose.DELETE, null, stmt -> {
                ArrayList values = new ArrayList();
                try (ResultSet rs = stmt.executeQuery();){
                    while (rs.next()) {
                        values.add(reader.read(rs, new Reader.Context(null, true, this.data.getSqlClient().getDialect())));
                    }
                }
                return values;
            }));
        }
        if (!childIds.isEmpty()) {
            if (this.data.getDissociateAction(backProp) != DissociateAction.DELETE) {
                throw new ExecutionException("Cannot delete entities whose type are \"" + backProp.getTargetType().getJavaClass().getName() + "\" because there are some child entities whose type are \"" + backProp.getDeclaringType().getJavaClass().getName() + "\", these child entities use the association property \"" + backProp + "\" to reference current entities.");
            }
            Deleter childDeleter = this.childDeleterMap.computeIfAbsent(backProp.toString(), it -> new Deleter(this.data, this.con, this.cache, this.trigger, this.affectedRowCountMap));
            childDeleter.addPreHandleInput(childType, childIds);
            childDeleter.preHandle();
        }
    }

    private List<Object> findChildIdsByDsl(ImmutableProp backProp, Collection<?> ids, FilterLevel filterLevel) {
        ImmutableType childType = backProp.getDeclaringType();
        MutableRootQueryImpl query = new MutableRootQueryImpl(this.data.getSqlClient(), childType, ExecutionPurpose.MUTATE, filterLevel);
        TableImplementor<?> table = query.getTableImplementor();
        query.where(new Predicate[]{table.getAssociatedId(backProp).in(ids)});
        List childRows = (List)query.select(table).execute(this.con);
        ArrayList<Object> childIds = new ArrayList<Object>(childRows.size());
        PropId childIdProp = childType.getIdProp().getId();
        MutationCache cache = this.cache;
        for (Object childRow : childRows) {
            if (cache != null) {
                cache.save((ImmutableSpi)childRow, false);
            }
            childIds.add(((ImmutableSpi)childRow).__get(childIdProp));
        }
        return childIds;
    }

    private void postHandle() {
        this.childDeleterMap.values().forEach(Deleter::postHandle);
        Map<ImmutableType, Set<Object>> idMultiMap = this.postHandleIdInputMap;
        this.postHandleIdInputMap = new LinkedHashMap<ImmutableType, Set<Object>>();
        for (Map.Entry<ImmutableType, Set<Object>> e : idMultiMap.entrySet()) {
            if (this.logical(e.getKey())) {
                this.logicallyDeleteImpl(e.getKey(), (Collection<Object>)e.getValue());
                continue;
            }
            this.deleteImpl(e.getKey(), (Collection<Object>)e.getValue());
        }
    }

    private void logicallyDeleteImpl(ImmutableType type, Collection<Object> ids) {
        if (ids.isEmpty()) {
            return;
        }
        LogicalDeletedInfo info = type.getLogicalDeletedInfo();
        assert (info != null);
        ImmutableProp prop = info.getProp();
        Object deletedValue = type.getLogicalDeletedValueGenerator((SqlContext)this.data.getSqlClient()).generate();
        if ((ids = this.prepareLogicEvents(type, ids, prop.getId(), deletedValue)).isEmpty()) {
            return;
        }
        MetadataStrategy strategy = this.data.getSqlClient().getMetadataStrategy();
        ColumnDefinition definition = (ColumnDefinition)type.getIdProp().getStorage(strategy);
        SqlBuilder builder = new SqlBuilder(new AstContext(this.data.getSqlClient()));
        builder.sql("update ");
        builder.sql(type.getTableName(strategy));
        builder.sql(" set ");
        builder.sql(((SingleColumn)info.getProp().getStorage(strategy)).getName());
        builder.sql(" = ");
        if (deletedValue != null) {
            builder.variable(deletedValue);
        } else {
            builder.nullVariable(prop.getElementClass());
        }
        builder.enter(SqlBuilder.ScopeType.WHERE);
        NativePredicates.renderPredicates(false, definition, ids, builder);
        builder.leave();
        Tuple3<String, List<Object>, List<Integer>> sqlResult = builder.build();
        int affectedRowCount = this.data.getSqlClient().getExecutor().execute(new Executor.Args<Integer>(this.data.getSqlClient(), this.con, sqlResult.get_1(), sqlResult.get_2(), sqlResult.get_3(), ExecutionPurpose.DELETE, null, PreparedStatement::executeUpdate));
        this.addOutput(AffectedTable.of(type), affectedRowCount);
    }

    private void deleteImpl(ImmutableType type, Collection<Object> ids) {
        if (ids.isEmpty()) {
            return;
        }
        if ((ids = this.prepareEvents(type, ids)).isEmpty()) {
            return;
        }
        MetadataStrategy strategy = this.data.getSqlClient().getMetadataStrategy();
        ColumnDefinition definition = (ColumnDefinition)type.getIdProp().getStorage(strategy);
        SqlBuilder builder = new SqlBuilder(new AstContext(this.data.getSqlClient()));
        builder.sql("delete from ").sql(type.getTableName(strategy)).enter(SqlBuilder.ScopeType.WHERE);
        NativePredicates.renderPredicates(false, definition, ids, builder);
        builder.leave();
        Tuple3<String, List<Object>, List<Integer>> sqlResult = builder.build();
        int affectedRowCount = this.data.getSqlClient().getExecutor().execute(new Executor.Args<Integer>(this.data.getSqlClient(), this.con, sqlResult.get_1(), sqlResult.get_2(), sqlResult.get_3(), ExecutionPurpose.DELETE, null, PreparedStatement::executeUpdate));
        this.addOutput(AffectedTable.of(type), affectedRowCount);
    }

    private Collection<Object> prepareLogicEvents(ImmutableType type, Collection<Object> ids, PropId propId, Object deletedValue) {
        if (ids.isEmpty()) {
            return ids;
        }
        MutationTrigger trigger = this.trigger;
        if (trigger == null) {
            return ids;
        }
        PropId idPropId = type.getIdProp().getId();
        List<ImmutableSpi> rows = this.cache.withFilter(this.logical(type)).loadByIds(type, ids, this.con);
        Iterator<ImmutableSpi> itr = rows.iterator();
        ArrayList<Object> changedIds = new ArrayList<Object>();
        while (itr.hasNext()) {
            ImmutableSpi row = itr.next();
            if (Objects.equals(row.__get(propId), deletedValue)) {
                itr.remove();
                continue;
            }
            trigger.modifyEntityTable(row, Internal.produce((ImmutableType)type, (Object)row, draft -> ((DraftSpi)draft).__set(propId, deletedValue)));
            changedIds.add(row.__get(idPropId));
        }
        return changedIds;
    }

    private Collection<Object> prepareEvents(ImmutableType type, Collection<Object> ids) {
        MutationTrigger trigger = this.trigger;
        if (trigger == null) {
            return ids;
        }
        List<ImmutableSpi> rows = this.cache.withFilter(false).loadByIds(type, ids, this.con);
        for (ImmutableSpi row : rows) {
            trigger.modifyEntityTable(row, null);
        }
        if (rows.size() == ids.size()) {
            return ids;
        }
        PropId idPropId = type.getIdProp().getId();
        ArrayList<Object> rowIds = new ArrayList<Object>(ids.size());
        for (ImmutableSpi row : rows) {
            rowIds.add(row.__get(idPropId));
        }
        return rowIds;
    }

    private boolean logical(ImmutableType type) {
        boolean hasLogicalInfo;
        DeleteMode mode = this.data.getMode();
        if (mode == DeleteMode.PHYSICAL) {
            return false;
        }
        boolean bl = hasLogicalInfo = type.getLogicalDeletedInfo() != null;
        if (!hasLogicalInfo && mode == DeleteMode.LOGICAL) {
            throw new ExecutionException("The data of \"" + type + "\" cannot be logically deleted, because there is no property decorated by `@" + LogicalDeleted.class.getName() + "` in that type");
        }
        return hasLogicalInfo;
    }
}

