/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.mutation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.babyfish.jimmer.meta.EmbeddedLevel;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.meta.PropId;
import org.babyfish.jimmer.runtime.ImmutableSpi;
import org.babyfish.jimmer.sql.ast.PropExpression;
import org.babyfish.jimmer.sql.ast.impl.mutation.MutationItem;
import org.babyfish.jimmer.sql.ast.table.Table;
import org.babyfish.jimmer.sql.meta.ColumnDefinition;
import org.babyfish.jimmer.sql.meta.MetadataStrategy;

class ChainedMutationItemImpl
implements MutationItem {
    private final List<ImmutableProp> props;
    private final Object value;
    private final int columnIndex;

    ChainedMutationItemImpl(List<ImmutableProp> props, Object value, int columnIndex) {
        if (value == Context.UNLOADED) {
            throw new AssertionError((Object)"The value should not be UNLOADED flag");
        }
        this.props = props;
        this.value = value;
        this.columnIndex = columnIndex;
    }

    @Override
    public ImmutableProp getProp() {
        return this.props.get(this.props.size() - 1);
    }

    @Override
    public List<ImmutableProp> getProps() {
        return this.props;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public String columnName(MetadataStrategy strategy) {
        return ((ColumnDefinition)this.props.get(0).getStorage(strategy)).name(this.columnIndex);
    }

    @Override
    public PropExpression<Object> expression(Table<?> table) {
        PropExpression expr = null;
        for (ImmutableProp prop : this.props) {
            if (expr != null) {
                expr = (PropExpression)((PropExpression.Embedded)expr).get(prop);
                continue;
            }
            expr = table.get(prop);
        }
        return expr;
    }

    static List<MutationItem> expand(ImmutableProp parentProp, ImmutableType type, Object obj) {
        Context ctx = new Context();
        if (parentProp != null) {
            ctx.push(parentProp);
        }
        ChainedMutationItemImpl.collectItems(type, (ImmutableSpi)obj, ctx);
        return ctx.toMutationItems();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void collectItems(ImmutableType type, Object obj, Context ctx) {
        for (ImmutableProp prop : type.getProps().values()) {
            PropId propId;
            ImmutableSpi spi;
            if (prop.isFormula()) continue;
            Object value = obj != null && obj != Context.UNLOADED ? ((spi = (ImmutableSpi)obj).__isLoaded(propId = prop.getId()) ? spi.__get(propId) : Context.UNLOADED) : obj;
            if (prop.isEmbedded(EmbeddedLevel.BOTH)) {
                ctx.push(prop);
                try {
                    ChainedMutationItemImpl.collectItems(prop.getTargetType(), (ImmutableSpi)value, ctx);
                    continue;
                }
                finally {
                    ctx.pop();
                    continue;
                }
            }
            ctx.addResult(prop, value);
        }
    }

    public String toString() {
        return "ChainedMutationItemImpl{props=" + this.props + ", value=" + this.value + ", columnIndex=" + this.columnIndex + '}';
    }

    private static class Context {
        private static final Object UNLOADED = new Object();
        private List<ImmutableProp> stack = new ArrayList<ImmutableProp>();
        private int columnIndex;
        private List<MutationItem> results = new ArrayList<MutationItem>();

        private Context() {
        }

        public void push(ImmutableProp prop) {
            this.stack.add(prop);
        }

        public void pop() {
            this.stack.remove(this.stack.size() - 1);
        }

        public void addResult(ImmutableProp prop, Object value) {
            if (value == UNLOADED) {
                ++this.columnIndex;
                return;
            }
            ArrayList<ImmutableProp> props = new ArrayList<ImmutableProp>(this.stack.size() + 1);
            props.addAll(this.stack);
            props.add(prop);
            ChainedMutationItemImpl item = new ChainedMutationItemImpl(Collections.unmodifiableList(props), value, this.columnIndex++);
            this.results.add(item);
        }

        public List<MutationItem> toMutationItems() {
            return Collections.unmodifiableList(this.results);
        }
    }
}

