/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl;

import java.lang.reflect.Array;
import java.util.Collection;
import org.babyfish.jimmer.impl.util.Classes;
import org.babyfish.jimmer.meta.EmbeddedLevel;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.TargetLevel;
import org.babyfish.jimmer.runtime.ImmutableSpi;
import org.babyfish.jimmer.sql.collection.TypedList;
import org.babyfish.jimmer.sql.meta.SingleColumn;
import org.babyfish.jimmer.sql.meta.Storage;
import org.babyfish.jimmer.sql.runtime.DbLiteral;
import org.babyfish.jimmer.sql.runtime.ExecutionException;
import org.babyfish.jimmer.sql.runtime.JSqlClientImplementor;
import org.babyfish.jimmer.sql.runtime.ScalarProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Variables {
    public static Object process(@Nullable Object value, @NotNull ImmutableProp prop, @NotNull JSqlClientImplementor sqlClient) {
        return Variables.process(value, prop, true, sqlClient);
    }

    public static Object process(@Nullable Object value, @NotNull ImmutableProp prop, boolean applyScalarProvider, @NotNull JSqlClientImplementor sqlClient) {
        SingleColumn singleColumn;
        Storage storage;
        if (value instanceof DbLiteral) {
            return value;
        }
        if (prop.isReference(TargetLevel.ENTITY)) {
            if (value != null) {
                value = ((ImmutableSpi)value).__get(prop.getTargetType().getIdProp().getId());
            }
            prop = prop.getTargetType().getIdProp();
        }
        if (prop.isEmbedded(EmbeddedLevel.SCALAR)) {
            return new DbLiteral.DbValue(prop, value, false);
        }
        if (applyScalarProvider) {
            ScalarProvider scalarProvider = sqlClient.getScalarProvider(prop);
            if (scalarProvider != null && value != null) {
                try {
                    value = scalarProvider.toSql(value);
                }
                catch (Exception ex) {
                    throw new ExecutionException("The value \"" + value + "\" cannot be converted by the scalar provider \"" + scalarProvider + "\"");
                }
            }
            if (value == null) {
                return new DbLiteral.DbNull(scalarProvider != null ? scalarProvider.getSqlType() : prop.getReturnClass());
            }
            if (scalarProvider != null) {
                return scalarProvider.isJsonScalar() ? new DbLiteral.DbValue(prop, value, true) : value;
            }
        }
        if (value == null) {
            return new DbLiteral.DbNull(prop.getReturnClass());
        }
        if (value instanceof Collection && prop.isScalar(TargetLevel.ENTITY)) {
            TypedList arr = (Object[])Array.newInstance(Classes.boxTypeOf((Class)prop.getElementClass()), ((Collection)value).size());
            ((Collection)value).toArray((T[])arr);
            value = arr;
        }
        if (value.getClass().isArray() && (storage = prop.getStorage(sqlClient.getMetadataStrategy())) instanceof SingleColumn && (singleColumn = (SingleColumn)storage).getSqlElementType() != null) {
            value = new TypedList(singleColumn.getSqlElementType(), (Object[])value);
        }
        return value;
    }
}

